/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.ConflictException;
import de.captaingoldfish.scim.sdk.common.exceptions.NotImplementedException;
import de.captaingoldfish.scim.sdk.common.exceptions.PreconditionFailedException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.request.BulkRequest;
import de.captaingoldfish.scim.sdk.common.request.BulkRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.BulkConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.response.BulkResponse;
import de.captaingoldfish.scim.sdk.common.response.BulkResponseGetOperation;
import de.captaingoldfish.scim.sdk.common.response.BulkResponseOperation;
import de.captaingoldfish.scim.sdk.common.response.CreateResponse;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.GetResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.common.response.UpdateResponse;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceEndpoint;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkget.BulkGetResolver;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdResolver;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdResolverAbstract;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import de.captaingoldfish.scim.sdk.server.schemas.SchemaFactory;
import de.captaingoldfish.scim.sdk.server.schemas.validation.RequestSchemaValidator;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import de.captaingoldfish.scim.sdk.server.utils.UriInfos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkEndpoint.class);
    private final ResourceEndpoint resourceEndpoint;
    private final ServiceProvider serviceProvider;
    private final ResourceTypeFactory resourceTypeFactory;
    private final Consumer<ResourceType> doBeforeExecution;
    private final Map<String, String> originalHttpHeaders;
    private final Map<String, String> originalQueryParams;
    private final BulkIdResolver bulkIdResolver = new BulkIdResolver();

    public BulkEndpoint(ResourceEndpoint resourceEndpoint, ServiceProvider serviceProvider, ResourceTypeFactory resourceTypeFactory, Map<String, String> originalHttpHeaders, Map<String, String> originalQueryParams, Consumer<ResourceType> doBeforeExecution) {
        this.resourceEndpoint = resourceEndpoint;
        this.serviceProvider = serviceProvider;
        this.resourceTypeFactory = resourceTypeFactory;
        this.originalHttpHeaders = originalHttpHeaders;
        this.originalQueryParams = originalQueryParams;
        this.doBeforeExecution = doBeforeExecution;
    }

    public BulkResponse bulk(String baseUri, String requestBody, Context context) {
        BulkRequest bulkRequest = this.parseAndValidateBulkRequest(requestBody);
        List operations = bulkRequest.getBulkRequestOperations();
        ArrayList<BulkResponseOperation> responseOperations = new ArrayList<BulkResponseOperation>();
        int failOnErrors = RequestUtils.getEffectiveFailOnErrors(bulkRequest);
        int httpStatus = this.handleBulkOperationList(baseUri, operations, responseOperations, failOnErrors, context);
        return BulkResponse.builder().httpStatus(httpStatus).bulkResponseOperation(responseOperations).build();
    }

    private int handleBulkOperationList(String baseUri, List<BulkRequestOperation> operations, List<BulkResponseOperation> responseOperations, int failOnErrors, Context context) {
        int errorCounter = 0;
        long maxIterations = (long)this.serviceProvider.getBulkConfig().getMaxOperations().intValue() * 2L;
        int iterations = 0;
        while (!operations.isEmpty() && (long)iterations < maxIterations) {
            ++iterations;
            BulkRequestOperation requestOperation = operations.get(0);
            if (errorCounter >= failOnErrors) {
                operations.remove(0);
                BulkResponseOperation.BulkResponseOperationBuilder responseBuilder = BulkResponseOperation.builder();
                String errorMessage = String.format("Operation with bulkId '%s' at iteration '%s' was not handled due to previous failed precondition", requestOperation.getBulkId().orElse(null), iterations);
                PreconditionFailedException ex = new PreconditionFailedException(errorMessage);
                responseOperations.add(responseBuilder.status(Integer.valueOf(412)).bulkId((String)requestOperation.getBulkId().orElse(null)).response((ScimObjectNode)new ErrorResponse((ScimException)ex)).method(requestOperation.getMethod()).build());
                continue;
            }
            try {
                this.validateOperation(requestOperation);
            }
            catch (BadRequestException ex) {
                ++errorCounter;
                BulkResponseOperation.BulkResponseOperationBuilder responseBuilder = BulkResponseOperation.builder();
                responseOperations.add(responseBuilder.status(Integer.valueOf(ex.getStatus())).response((ScimObjectNode)new ErrorResponse((ScimException)ex)).build());
                operations.remove(0);
                continue;
            }
            BulkResponseOperation bulkResponseOperation = this.handleSingleBulkOperation(baseUri, requestOperation, context);
            if (bulkResponseOperation == null) {
                String operationIdentifier = UUID.randomUUID().toString();
                requestOperation.setUniqueIdentifier(operationIdentifier);
                operations.remove(0);
                operations.add(requestOperation);
                continue;
            }
            operations.remove(0);
            boolean isSuccessfulResponseCode = this.isSuccessResponseCode(requestOperation, bulkResponseOperation);
            if (!isSuccessfulResponseCode) {
                ++errorCounter;
            }
            responseOperations.add(bulkResponseOperation);
        }
        int httpStatus = 200;
        if (errorCounter >= failOnErrors) {
            httpStatus = 412;
        } else if ((long)iterations >= maxIterations) {
            httpStatus = 500;
        }
        return httpStatus;
    }

    private boolean isSuccessResponseCode(BulkRequestOperation requestOperation, BulkResponseOperation responseOperation) {
        switch (requestOperation.getMethod()) {
            case POST: {
                return 201 == responseOperation.getStatus();
            }
            case DELETE: {
                return 204 == responseOperation.getStatus();
            }
            case PATCH: {
                return 200 == responseOperation.getStatus() || 204 == responseOperation.getStatus();
            }
        }
        return 200 == responseOperation.getStatus();
    }

    private BulkResponseOperation handleSingleBulkOperation(String baseUri, BulkRequestOperation operation, Context context) {
        boolean isResourceResponse;
        HttpMethod httpMethod = operation.getMethod();
        Map<String, String> httpHeaders = this.getHttpHeadersForBulk(operation);
        boolean lenientContentTypeChecking = this.getServiceProvider().isLenientContentTypeChecking();
        UriInfos operationUriInfo = UriInfos.getRequestUrlInfos(this.getResourceTypeFactory(), baseUri + operation.getPath(), httpMethod, httpHeaders, lenientContentTypeChecking);
        operationUriInfo.getQueryParameters().putAll(this.originalQueryParams);
        String id = Optional.ofNullable(operationUriInfo.getResourceId()).map(resourceId -> "/" + resourceId).orElse("");
        String location = baseUri + operationUriInfo.getResourceEndpoint() + id;
        String bulkId = operation.getBulkId().orElseGet(() -> {
            String bId = UUID.randomUUID().toString();
            operation.setBulkId(bId);
            return bId;
        });
        BulkResponseOperation.BulkResponseOperationBuilder responseBuilder = BulkResponseOperation.builder().bulkId(bulkId).method(httpMethod).location(location);
        try {
            Optional<BulkIdResolverAbstract> bulkIdResolver = this.resolveBulkIds(operation, httpMethod, operationUriInfo, bulkId);
            operationUriInfo = bulkIdResolver.map(BulkIdResolverAbstract::getUriInfos).orElse(operationUriInfo);
            if (bulkIdResolver.map(BulkIdResolverAbstract::hasAnyBulkIdReferences).orElse(false).booleanValue()) {
                return null;
            }
        }
        catch (ScimException ex) {
            return responseBuilder.status(Integer.valueOf(ex.getStatus())).response((ScimObjectNode)new ErrorResponse(ex)).build();
        }
        responseBuilder.bulkId((String)operation.getBulkId().orElse(null)).method(operation.getMethod()).location(location);
        ScimResponse scimResponse = this.resourceEndpoint.resolveRequest(httpMethod, operation.getData().orElse(null), operationUriInfo, this.doBeforeExecution, context);
        boolean bl = isResourceResponse = scimResponse instanceof CreateResponse || scimResponse instanceof UpdateResponse;
        if (isResourceResponse) {
            Optional.ofNullable(scimResponse.get("id")).map(JsonNode::textValue).ifPresent(resourceId -> this.bulkIdResolver.addResolvedBulkId(bulkId, (String)resourceId));
        }
        boolean isErrorResponse = ErrorResponse.class.isAssignableFrom(scimResponse.getClass());
        responseBuilder.status(Integer.valueOf(scimResponse.getHttpStatus()));
        if (isErrorResponse) {
            responseBuilder.response((ScimObjectNode)scimResponse);
        } else if (scimResponse instanceof GetResponse && this.serviceProvider.getBulkConfig().isSupportBulkGet()) {
            String resourceTypeName = operationUriInfo.getResourceType().getName();
            BiFunction<String, ResourceType, ScimResponse> bulkGetOpCaller = this.getTransitiveBulkGetResolver(baseUri, httpHeaders, context);
            BulkGetResolver bulkGetResolver = BulkGetResolver.builder().maxResourceLevel(operation.getMaxResourceLevel()).parentResourceResponse(scimResponse).resourceTypeFactory(this.resourceTypeFactory).resourceType(operationUriInfo.getResourceType()).callResourceEndpoint(bulkGetOpCaller).build();
            List<BulkResponseGetOperation> children = bulkGetResolver.getTransitiveResources();
            BulkResponseGetOperation bulkResponseGetOperation = BulkResponseGetOperation.builder().status(Integer.valueOf(200)).resourceId(operationUriInfo.getResourceId()).resourceType(resourceTypeName).resource(scimResponse).children(children).build();
            responseBuilder.response((ScimObjectNode)bulkResponseGetOperation);
        } else {
            this.addResponse(operation, scimResponse, operationUriInfo.getResourceType(), responseBuilder);
        }
        if (isErrorResponse) {
            if (HttpMethod.POST.equals((Object)operation.getMethod())) {
                responseBuilder.location(null);
            }
        } else {
            id = Optional.ofNullable(scimResponse.get("id")).map(jsonNode -> "/" + jsonNode.textValue()).orElse("");
            location = baseUri + operationUriInfo.getResourceEndpoint() + id;
            responseBuilder.location(location);
            boolean isResourceDeleted = HttpMethod.DELETE.equals((Object)operationUriInfo.getHttpMethod());
            if (isResourceDeleted) {
                responseBuilder.resourceId(operationUriInfo.getResourceId());
            } else {
                ETag resourceVersion = Optional.ofNullable(scimResponse.get("meta")).map(JsonNode::toString).map(metaResource -> {
                    Meta meta = (Meta)JsonHelper.readJsonDocument((String)metaResource, Meta.class);
                    return meta.getVersion().orElse(null);
                }).orElse(null);
                responseBuilder.version(resourceVersion);
                String resourceId2 = Optional.ofNullable(scimResponse.get("id")).map(JsonNode::textValue).orElse(null);
                responseBuilder.resourceId(resourceId2);
            }
        }
        return responseBuilder.build();
    }

    private BiFunction<String, ResourceType, ScimResponse> getTransitiveBulkGetResolver(String baseUri, Map<String, String> httpHeaders, Context context) {
        boolean lenientContentTypeChecking = this.getServiceProvider().isLenientContentTypeChecking();
        return (resourceId, resourceType) -> {
            UriInfos uriInfos = UriInfos.getRequestUrlInfos(this.getResourceTypeFactory(), String.format("%s%s/%s", baseUri, resourceType.getEndpoint(), resourceId), HttpMethod.GET, httpHeaders, lenientContentTypeChecking);
            return this.resourceEndpoint.resolveRequest(uriInfos.getHttpMethod(), null, uriInfos, this.doBeforeExecution, context);
        };
    }

    private Optional<BulkIdResolverAbstract> resolveBulkIds(BulkRequestOperation operation, HttpMethod httpMethod, UriInfos operationUriInfo, String bulkId) {
        boolean isSecondTryToResolveIds;
        boolean allBulkIdReferencesResolved;
        if (this.bulkIdResolver.isDuplicateBulkId(bulkId)) {
            throw new BadRequestException(String.format("Found duplicate %s '%s' in bulk request operations", "bulkId", bulkId));
        }
        if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            return Optional.empty();
        }
        BulkIdResolverAbstract resolverForBulkIds = this.bulkIdResolver.getBulkIdResolver(bulkId).orElseGet(() -> this.bulkIdResolver.createNewBulkIdResolver(bulkId, operationUriInfo, operation.getData().orElse("{}")));
        boolean bl = allBulkIdReferencesResolved = !resolverForBulkIds.hasAnyBulkIdReferences();
        if (allBulkIdReferencesResolved) {
            operation.setData(resolverForBulkIds.getResource().toString());
        }
        boolean hadSuccessInLastRun = resolverForBulkIds.isHadSuccessInLastRun();
        boolean bl2 = isSecondTryToResolveIds = operation.getUniqueIdentifier() != null;
        if (isSecondTryToResolveIds && !allBulkIdReferencesResolved && !hadSuccessInLastRun) {
            String unresolvedBulkIds = resolverForBulkIds.getUnresolvedBulkIds().stream().map(id -> String.format("%s:%s", "bulkId", id)).collect(Collectors.joining(", "));
            throw new ConflictException(String.format("the operation failed because the following bulkId-references could not be resolved [%s]", unresolvedBulkIds));
        }
        return Optional.of(resolverForBulkIds);
    }

    private void addResponse(BulkRequestOperation operation, ScimResponse scimResponse, ResourceType resourceType, BulkResponseOperation.BulkResponseOperationBuilder responseBuilder) {
        if (!this.serviceProvider.getBulkConfig().isReturnResourcesEnabled()) {
            return;
        }
        if (resourceType.getFeatures().isDenyReturnResourcesOnBulk()) {
            return;
        }
        boolean returnResourceByDefault = this.serviceProvider.getBulkConfig().isReturnResourcesByDefault();
        boolean doesClientWantResourceBack = operation.isReturnResource().orElse(returnResourceByDefault);
        if (doesClientWantResourceBack) {
            responseBuilder.response((ScimObjectNode)scimResponse);
        }
    }

    private Map<String, String> getHttpHeadersForBulk(BulkRequestOperation operation) {
        HashMap<String, String> httpHeaders = new HashMap<String, String>(this.originalHttpHeaders);
        httpHeaders.put("/Bulk", "true");
        operation.getVersion().ifPresent(eTag -> httpHeaders.put("If-Match", eTag.getEntityTag()));
        return httpHeaders;
    }

    private BulkRequest parseAndValidateBulkRequest(String requestBody) {
        BulkConfig bulkConfig = this.getServiceProvider().getBulkConfig();
        if (!bulkConfig.isSupported()) {
            throw new NotImplementedException("bulk is not supported by this service provider");
        }
        try {
            JsonNode jsonNode = JsonHelper.readJsonDocument((String)requestBody);
            SchemaFactory schemaFactory = this.getResourceTypeFactory().getSchemaFactory();
            Schema bulkRequestSchema = schemaFactory.getMetaSchema("urn:ietf:params:scim:api:messages:2.0:BulkRequest");
            ScimObjectNode validatedRequest = new RequestSchemaValidator(this.serviceProvider, ScimObjectNode.class, HttpMethod.POST).validateDocument(bulkRequestSchema, jsonNode);
            BulkRequest bulkRequest = (BulkRequest)JsonHelper.copyResourceToObject((JsonNode)validatedRequest, BulkRequest.class);
            if (bulkConfig.getMaxOperations() < bulkRequest.getBulkRequestOperations().size()) {
                throw new BadRequestException("too many operations maximum number of operations is '" + bulkConfig.getMaxOperations() + "' but got '" + bulkRequest.getBulkRequestOperations().size() + "'", null, "tooMany");
            }
            if (bulkConfig.getMaxPayloadSize() < (long)requestBody.getBytes().length) {
                throw new BadRequestException("request body too large with '" + requestBody.getBytes().length + "'-bytes maximum payload size is '" + bulkConfig.getMaxPayloadSize() + "'", null, "tooLarge");
            }
            return bulkRequest;
        }
        catch (ScimException ex) {
            throw new BadRequestException(ex.getMessage(), (Throwable)ex, "unparseableRequest");
        }
    }

    private void validateOperation(BulkRequestOperation operation) {
        ArrayList<HttpMethod> validMethods = new ArrayList<HttpMethod>(Arrays.asList(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE));
        if (this.serviceProvider.getBulkConfig().isSupportBulkGet()) {
            validMethods.add(HttpMethod.GET);
        }
        if (!validMethods.contains(operation.getMethod())) {
            throw new BadRequestException("bulk request used invalid http method. Only the following methods are allowed for bulk: " + validMethods, null, "unparseableRequest");
        }
        if (HttpMethod.POST.equals((Object)operation.getMethod()) && (operation.getBulkId().isPresent() && StringUtils.isBlank((CharSequence)((CharSequence)operation.getBulkId().get())) || !operation.getBulkId().isPresent())) {
            throw new BadRequestException("missing 'bulkId' on BULK-POST request", null, "unparseableRequest");
        }
    }

    @Generated
    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    @Generated
    public ResourceTypeFactory getResourceTypeFactory() {
        return this.resourceTypeFactory;
    }
}

