/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.IOException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.exceptions.NotImplementedException;
import de.captaingoldfish.scim.sdk.common.exceptions.ResourceNotFoundException;
import de.captaingoldfish.scim.sdk.common.exceptions.ScimException;
import de.captaingoldfish.scim.sdk.common.request.PatchOpRequest;
import de.captaingoldfish.scim.sdk.common.request.SearchRequest;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.response.CreateResponse;
import de.captaingoldfish.scim.sdk.common.response.DeleteResponse;
import de.captaingoldfish.scim.sdk.common.response.EmptyPatchResponse;
import de.captaingoldfish.scim.sdk.common.response.ErrorResponse;
import de.captaingoldfish.scim.sdk.common.response.GetResponse;
import de.captaingoldfish.scim.sdk.common.response.ListResponse;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.common.response.UpdateResponse;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.EncodingUtils;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.EndpointDefinition;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import de.captaingoldfish.scim.sdk.server.endpoints.base.ResourceTypeEndpointDefinition;
import de.captaingoldfish.scim.sdk.server.endpoints.base.SchemaEndpointDefinition;
import de.captaingoldfish.scim.sdk.server.endpoints.base.ServiceProviderEndpointDefinition;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointType;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.RequestContextException;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.RequestValidatorHandler;
import de.captaingoldfish.scim.sdk.server.etag.ETagHandler;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.filter.resources.FilterResourceResolver;
import de.captaingoldfish.scim.sdk.server.interceptor.Interceptor;
import de.captaingoldfish.scim.sdk.server.patch.PatchRequestHandler;
import de.captaingoldfish.scim.sdk.server.patch.workarounds.PatchWorkaround;
import de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure.MsAzurePatchComplexValueRebuilder;
import de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure.MsAzurePatchRemoveRebuilder;
import de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure.MsAzurePatchValueSubAttributeRebuilder;
import de.captaingoldfish.scim.sdk.server.response.PartialListResponse;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import de.captaingoldfish.scim.sdk.server.schemas.custom.ResourceTypeFeatures;
import de.captaingoldfish.scim.sdk.server.schemas.validation.AbstractResourceValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.RequestResourceValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.RequestSchemaValidator;
import de.captaingoldfish.scim.sdk.server.sort.ResourceNodeComparator;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceEndpointHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceEndpointHandler.class);
    private final ServiceProvider serviceProvider;
    private final List<Supplier<PatchWorkaround>> patchWorkarounds = new ArrayList<Supplier<PatchWorkaround>>();
    private ResourceTypeFactory resourceTypeFactory = new ResourceTypeFactory();

    protected ResourceEndpointHandler(ServiceProvider serviceProvider, EndpointDefinition ... endpointDefinitions) {
        this.serviceProvider = serviceProvider;
        ArrayList<EndpointDefinition> endpointDefinitionList = new ArrayList<EndpointDefinition>(Arrays.asList(endpointDefinitions));
        this.registerEndpoint(new ServiceProviderEndpointDefinition(serviceProvider));
        this.registerEndpoint(new ResourceTypeEndpointDefinition(this.resourceTypeFactory));
        this.registerEndpoint(new SchemaEndpointDefinition(this.resourceTypeFactory));
        endpointDefinitionList.forEach(this::registerEndpoint);
        this.addDefaultPatchWorkarounds();
    }

    public void addDefaultPatchWorkarounds() {
        this.patchWorkarounds.add(MsAzurePatchRemoveRebuilder::new);
        this.patchWorkarounds.add(MsAzurePatchValueSubAttributeRebuilder::new);
        this.patchWorkarounds.add(MsAzurePatchComplexValueRebuilder::new);
    }

    public ResourceType registerEndpoint(EndpointDefinition endpointDefinition) {
        ResourceType resourceType = this.resourceTypeFactory.registerResourceType(endpointDefinition.getResourceHandler(), endpointDefinition.getResourceType(), endpointDefinition.getResourceSchema(), endpointDefinition.getResourceSchemaExtensions().toArray(new JsonNode[0]));
        ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
        resourceHandler.setServiceProvider(this.serviceProvider);
        resourceHandler.setResourceType(resourceType);
        Schema mainSchema = resourceType.getMainSchema();
        resourceHandler.setSchema(mainSchema);
        resourceHandler.setSchemaExtensions(resourceType.getAllSchemas().stream().filter(schema -> !((String)schema.getId().get()).equals(mainSchema.getId().get())).collect(Collectors.toList()));
        resourceHandler.setChangePasswordSupported(() -> this.serviceProvider.getChangePasswordConfig().isSupported());
        resourceHandler.setMaxResults(() -> this.serviceProvider.getFilterConfig().getMaxResults());
        resourceHandler.setGetResourceTypeByRef(resourceTypeRefValue -> this.getResourceTypeByName((String)resourceTypeRefValue).orElseGet(() -> {
            String[] urlParts = ((String)resourceTypeRefValue).split("/");
            String resourceTypeEndpointOrV2 = "/" + urlParts[urlParts.length - 2];
            String idOrResourceTypeEndpoint = "/" + urlParts[urlParts.length - 1];
            return Optional.ofNullable(this.resourceTypeFactory.getResourceType(resourceTypeEndpointOrV2)).orElseGet(() -> this.resourceTypeFactory.getResourceType(idOrResourceTypeEndpoint));
        }));
        resourceHandler.postConstruct(resourceType);
        return resourceType;
    }

    public Optional<ResourceType> getResourceTypeByName(String name) {
        return this.resourceTypeFactory.getResourceTypeByName(name);
    }

    public Set<String> getRegisteredResourceTypeNames() {
        return this.resourceTypeFactory.getAllResourceTypes().stream().map(ResourceType::getName).collect(Collectors.toSet());
    }

    public Set<ResourceType> getRegisteredResourceTypes() {
        return new HashSet<ResourceType>(this.resourceTypeFactory.getAllResourceTypes());
    }

    public Set<Schema> getRegisteredSchemas() {
        return this.resourceTypeFactory.getSchemaFactory().getAllResourceSchemas();
    }

    protected ScimResponse createResource(String endpoint, String resourceDocument, Supplier<String> baseUrlSupplier, Context context) {
        try {
            JsonNode resource;
            if (StringUtils.isBlank((CharSequence)resourceDocument)) {
                throw new BadRequestException("the request body is empty", null, "invalidParameters");
            }
            ResourceType resourceType = this.getResourceType(endpoint);
            try {
                resource = JsonHelper.readJsonDocument((String)resourceDocument);
            }
            catch (IOException ex) {
                throw new BadRequestException(ex.getMessage(), (Throwable)ex, "unparseableRequest");
            }
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            RequestResourceValidator resourceValidator = new RequestResourceValidator(this.serviceProvider, resourceType, HttpMethod.POST);
            ResourceNode resourceNode = (ResourceNode)resourceValidator.validateDocument(resource);
            Meta meta = resourceNode.getMeta().orElse(Meta.builder().build());
            meta.setResourceType(resourceType.getName());
            resourceNode.remove("meta");
            resourceNode.setMeta(meta);
            new RequestValidatorHandler(resourceHandler, resourceValidator, context).validateCreate(resourceNode);
            Interceptor interceptor = resourceHandler.getInterceptor(EndpointType.CREATE);
            ResourceNode resourceNodeCreated = interceptor.doAround(() -> resourceHandler.createResource(resourceNode, context));
            if (resourceNodeCreated == null) {
                throw new NotImplementedException("create was not implemented for resourceType '" + resourceType.getName() + "'");
            }
            String resourceId = (String)resourceNodeCreated.getId().orElseThrow(() -> {
                String errorMessage = "ID attribute not set on created resource";
                return new InternalServerException(errorMessage, null, null);
            });
            String location = this.getLocation(resourceType, resourceId, baseUrlSupplier);
            Meta createdMeta = (Meta)resourceNodeCreated.getMeta().orElseThrow(() -> {
                String metaErrorMessage = "Meta attribute not set on created resource";
                return new InternalServerException(metaErrorMessage, null, null);
            });
            if (!createdMeta.getLastModified().isPresent()) {
                createdMeta.setLastModified((Instant)createdMeta.getCreated().orElse(null));
            }
            if (meta.getLocation().isPresent()) {
                createdMeta.setLocation((String)meta.getLocation().get());
            } else {
                createdMeta.setLocation(location);
            }
            createdMeta.setResourceType(resourceType.getName());
            ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNodeCreated).ifPresent(arg_0 -> ((Meta)createdMeta).setVersion(arg_0));
            Optional<AbstractResourceValidator> responseValidator = resourceHandler.getResponseValidator(null, null, resource, this.getReferenceUrlSupplier(baseUrlSupplier));
            ResourceNode responseResource = resourceNodeCreated;
            if (responseValidator.isPresent()) {
                responseResource = responseValidator.get().validateDocument((JsonNode)resourceNodeCreated);
            }
            return new CreateResponse((JsonNode)responseResource, location, createdMeta);
        }
        catch (RequestContextException ex) {
            ErrorResponse errorResponse = new ErrorResponse((ScimException)ex);
            ex.getValidationContext().writeToErrorResponse(errorResponse);
            return errorResponse;
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    protected ScimResponse getResource(String endpoint, String id, String attributes, String excludedAttributes, Supplier<String> baseUrlSupplier, Context context) {
        try {
            ResourceTypeFeatures resourceTypeFeatures;
            ResourceType resourceType = this.getResourceType(endpoint);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            List<SchemaAttribute> attributesList = RequestUtils.getAttributes(resourceType, attributes);
            List<SchemaAttribute> excludedAttributesList = RequestUtils.getAttributes(resourceType, excludedAttributes);
            Interceptor interceptor = resourceHandler.getInterceptor(EndpointType.GET);
            ResourceNode resourceNode = interceptor.doAround(() -> resourceHandler.getResource(id, attributesList, excludedAttributesList, context));
            if (resourceNode == null) {
                throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", null, null);
            }
            ETagHandler.validateVersion(this.serviceProvider, resourceType, () -> resourceNode, context.getUriInfos().getHttpHeaders());
            String resourceId = resourceNode.getId().orElse(null);
            if (resourceId != null && !resourceId.equals(id) && (resourceTypeFeatures = resourceType.getFeatures()) != null && !resourceTypeFeatures.isSingletonEndpoint()) {
                throw new InternalServerException("the id of the returned resource does not match the requested id: requestedId: '" + id + "', returnedId: '" + resourceId + "'", null, null);
            }
            String location = this.getLocation(resourceType, resourceId, baseUrlSupplier);
            resourceNode.getMeta().ifPresent(meta -> {
                if (!meta.getLastModified().isPresent()) {
                    meta.setLastModified((Instant)meta.getCreated().orElse(null));
                }
                if (!meta.getLocation().isPresent()) {
                    meta.setLocation(location);
                }
                meta.setResourceType(resourceType.getName());
                ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNode).ifPresent(arg_0 -> ((Meta)meta).setVersion(arg_0));
            });
            Optional<AbstractResourceValidator> responseValidator = resourceHandler.getResponseValidator(attributesList, excludedAttributesList, null, this.getReferenceUrlSupplier(baseUrlSupplier));
            ResourceNode responseResource = resourceNode;
            if (responseValidator.isPresent()) {
                responseResource = responseValidator.get().validateDocument((JsonNode)resourceNode);
            }
            return new GetResponse((JsonNode)responseResource, location, (Meta)resourceNode.getMeta().orElse(null));
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    protected ScimResponse listResources(String endpoint, String searchRequest, Supplier<String> baseUrlSupplier, Context context) {
        return this.listResources(endpoint, StringUtils.isBlank((CharSequence)searchRequest) ? SearchRequest.builder().build() : (SearchRequest)JsonHelper.readJsonDocument((String)searchRequest, SearchRequest.class), baseUrlSupplier, context);
    }

    protected ScimResponse listResources(String endpoint, SearchRequest searchRequest, Supplier<String> baseUrlSupplier, Context context) {
        return this.listResources(endpoint, searchRequest.getStartIndex().orElse(null), searchRequest.getCount().orElse(null), searchRequest.getFilter().orElse(null), searchRequest.getSortBy().orElse(null), searchRequest.getSortOrder().orElse(null), searchRequest.getAttributes(), searchRequest.getExcludedAttributes(), baseUrlSupplier, context);
    }

    protected <T extends ResourceNode> ScimResponse listResources(String endpoint, Long startIndex, Integer count, String filter, String sortBy, String sortOrder, List<String> attributes, List<String> excludedAttributes, Supplier<String> baseUrlSupplier, Context context) {
        try {
            long totalResults;
            ResourceType resourceType = this.getResourceType(endpoint);
            long effectiveStartIndex = RequestUtils.getEffectiveStartIndex(startIndex);
            int effectiveCount = RequestUtils.getEffectiveCount(this.serviceProvider, count);
            FilterNode filterNode = this.getFilterNode(resourceType, filter);
            boolean autoFiltering = resourceType.getFeatures().isAutoFiltering();
            SchemaAttribute sortByAttribute = this.getSortByAttribute(resourceType, sortBy);
            SortOrder sortOrdering = this.getSortOrdering(sortOrder, sortByAttribute);
            boolean autoSorting = resourceType.getFeatures().isAutoSorting();
            List<SchemaAttribute> attributesList = RequestUtils.getAttributes(resourceType, attributes);
            List<SchemaAttribute> excludedAttributesList = RequestUtils.getAttributes(resourceType, excludedAttributes);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            Interceptor interceptor = resourceHandler.getInterceptor(EndpointType.LIST);
            PartialListResponse resources = interceptor.doAround(() -> resourceHandler.listResources(effectiveStartIndex, effectiveCount, autoFiltering ? null : filterNode, autoSorting ? null : sortByAttribute, autoSorting ? null : sortOrdering, attributesList, excludedAttributesList, context));
            if (resources == null) {
                throw new NotImplementedException("listResources was not implemented for resourceType '" + resourceType.getName() + "'");
            }
            List resourceList = resources.getResources();
            List filteredResources = this.filterResources(filterNode, resourceList, resourceType);
            filteredResources = this.sortResources(filteredResources, sortByAttribute, sortOrdering, resourceType);
            long l = resourceList.size() != filteredResources.size() ? (long)filteredResources.size() : (totalResults = resources.getTotalResults() == 0L ? (long)filteredResources.size() : resources.getTotalResults());
            if (autoFiltering) {
                if (effectiveStartIndex <= (long)filteredResources.size()) {
                    filteredResources = filteredResources.subList((int)Math.min(effectiveStartIndex - 1L, (long)(filteredResources.size() - 1)), (int)Math.min(effectiveStartIndex - 1L + (long)effectiveCount, (long)filteredResources.size()));
                } else {
                    log.debug("startIndex '{}' is > than number of entries available '{}'. Returning empty list", (Object)effectiveStartIndex, (Object)filteredResources.size());
                    filteredResources = Collections.emptyList();
                }
            }
            if (filteredResources.size() > effectiveCount) {
                log.warn("The service provider tried to return more results than allowed. Tried to return '{}' results. The list will be reduced to '{}' results", (Object)filteredResources.size(), (Object)effectiveCount);
                filteredResources = filteredResources.subList(0, effectiveCount);
            }
            ArrayList<ResourceNode> validatedResourceList = new ArrayList<ResourceNode>();
            for (ResourceNode resourceNode : filteredResources) {
                String location = this.getLocation(resourceType, resourceNode.getId().orElse(null), baseUrlSupplier);
                log.trace("Determined resource location at '{}'", (Object)location);
                resourceNode.getMeta().ifPresent(meta -> {
                    if (!meta.getLastModified().isPresent()) {
                        meta.setLastModified((Instant)meta.getCreated().orElse(null));
                    }
                    if (!meta.getLocation().isPresent()) {
                        meta.setLocation(location);
                    }
                    meta.setResourceType(resourceType.getName());
                    ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNode).ifPresent(arg_0 -> ((Meta)meta).setVersion(arg_0));
                });
                Optional<AbstractResourceValidator> responseValidator = resourceHandler.getResponseValidator(attributesList, excludedAttributesList, null, this.getReferenceUrlSupplier(baseUrlSupplier));
                ResourceNode responseResource = resourceNode;
                if (responseValidator.isPresent()) {
                    responseResource = responseValidator.get().validateDocument((JsonNode)resourceNode);
                }
                validatedResourceList.add(responseResource);
            }
            return new ListResponse(validatedResourceList, Long.valueOf(totalResults), Integer.valueOf(validatedResourceList.size()), Long.valueOf(effectiveStartIndex));
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    private <T extends ResourceNode> List<T> sortResources(List<T> filteredResources, SchemaAttribute sortByAttribute, SortOrder sortOrdering, ResourceType resourceType) {
        if (!this.serviceProvider.getSortConfig().isSupported() || sortByAttribute == null || !resourceType.getFeatures().isAutoSorting()) {
            log.trace("Auto-sorting skipped for auto-sorting is not supported or missing sortBy attribute");
            return filteredResources;
        }
        log.trace("Starting auto sorting resources by attribute '{}' in order '{}'", (Object)sortByAttribute.getFullResourceName(), (Object)sortOrdering);
        try {
            return (List)((ForkJoinTask)this.serviceProvider.getThreadPool().submit(() -> filteredResources.parallelStream().sorted(new ResourceNodeComparator(sortByAttribute, sortOrdering)).collect(Collectors.toList()))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalServerException((Throwable)e);
        }
    }

    protected <T extends ResourceNode> List<T> filterResources(FilterNode filterNode, List<T> resourceList, ResourceType resourceType) {
        List<T> filteredResourceType;
        boolean isApplicationFilteringEnabled = resourceType.getFeatures().isAutoFiltering();
        if (isApplicationFilteringEnabled && filterNode != null) {
            log.trace("Starting with auto filtering resources");
            filteredResourceType = FilterResourceResolver.filterResources(this.serviceProvider, resourceList, filterNode);
        } else {
            log.trace("No filtering performed");
            filteredResourceType = resourceList;
        }
        return filteredResourceType;
    }

    private FilterNode getFilterNode(ResourceType resourceType, String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            log.trace("No filter expression found in request");
            return null;
        }
        if (this.serviceProvider.getFilterConfig().isSupported()) {
            log.trace("Evaluating filter expression '{}' for resourceType '{}'", (Object)filter, (Object)resourceType.getName());
            return RequestUtils.parseFilter(resourceType, filter);
        }
        log.debug("Filter expression '{}' is not evaluated because filter support is disabled", (Object)filter);
        return null;
    }

    private SchemaAttribute getSortByAttribute(ResourceType resourceType, String sortBy) {
        if (StringUtils.isBlank((CharSequence)sortBy)) {
            log.trace("No sortBy attribute found in request");
            return null;
        }
        if (this.serviceProvider.getSortConfig().isSupported()) {
            log.trace("Evaluating sortBy attribute '{}' for resourceType '{}'", (Object)sortBy, (Object)resourceType.getName());
            return RequestUtils.getSchemaAttributeByAttributeName(resourceType, sortBy);
        }
        log.debug("sortBy value '{}' is ignored because sorting support is disabled", (Object)sortBy);
        return null;
    }

    private SortOrder getSortOrdering(String sortOrder, SchemaAttribute sortBy) {
        if (StringUtils.isBlank((CharSequence)sortOrder) && sortBy != null) {
            log.trace("No sortBy attribute found in request. Using default '{}'", (Object)SortOrder.ASCENDING);
            return SortOrder.ASCENDING;
        }
        if (this.serviceProvider.getSortConfig().isSupported()) {
            log.trace("Evaluating sortOrder attribute '{}'", (Object)sortOrder);
            return SortOrder.getByValue((String)sortOrder);
        }
        log.debug("SortOrder value '{}' is ignored because sorting support is disabled", (Object)sortOrder);
        return null;
    }

    protected ScimResponse updateResource(String endpoint, String id, String resourceDocument, Supplier<String> baseUrlSupplier, Context context) {
        try {
            JsonNode resource;
            if (StringUtils.isBlank((CharSequence)resourceDocument)) {
                throw new BadRequestException("the request body is empty", null, "invalidParameters");
            }
            ResourceType resourceType = this.getResourceType(endpoint);
            try {
                resource = JsonHelper.readJsonDocument((String)resourceDocument);
            }
            catch (IOException ex) {
                throw new BadRequestException(ex.getMessage(), (Throwable)ex, "unparseableRequest");
            }
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            RequestResourceValidator requestResourceValidator = new RequestResourceValidator(this.serviceProvider, resourceType, HttpMethod.PUT);
            ResourceNode resourceNodeForUpdate = (ResourceNode)requestResourceValidator.validateDocument(resource);
            if (resource == null) {
                throw new BadRequestException("the request body does not contain any writable parameters", null, "unparseableRequest");
            }
            if (resourceNodeForUpdate == null) {
                throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", null, null);
            }
            resourceNodeForUpdate.setId(id);
            String location = this.getLocation(resourceType, id, baseUrlSupplier);
            Meta meta = resourceNodeForUpdate.getMeta().orElse(Meta.builder().build());
            resourceNodeForUpdate.remove("meta");
            meta.setLocation(location);
            meta.setResourceType(resourceType.getName());
            resourceNodeForUpdate.setMeta(meta);
            AtomicReference oldResourceNode = new AtomicReference();
            Supplier<ResourceNode> oldResourceSupplier = () -> {
                Object oldResource = resourceHandler.getResourceForUpdate(id, null, null, context, EndpointType.UPDATE);
                oldResourceNode.compareAndSet(null, oldResource);
                return (ResourceNode)oldResourceNode.get();
            };
            Interceptor interceptor = resourceHandler.getInterceptor(EndpointType.UPDATE);
            ResourceNode resourceNode = interceptor.doAround(() -> {
                this.validateResourceVersion(id, resourceType, oldResourceSupplier, context.getUriInfos().getHttpHeaders());
                new RequestValidatorHandler(resourceHandler, requestResourceValidator, context).validateUpdate(oldResourceSupplier, resourceNodeForUpdate);
                return resourceHandler.updateResource(resourceNodeForUpdate, context);
            });
            if (resourceNode == null) {
                throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", null, null);
            }
            Supplier<String> metaErrorMessage = () -> "Meta attribute not set on created resource";
            Meta createdMeta = (Meta)resourceNode.getMeta().orElseThrow(() -> new InternalServerException((String)metaErrorMessage.get(), null, null));
            if (!createdMeta.getLastModified().isPresent()) {
                createdMeta.setLastModified((Instant)createdMeta.getCreated().orElse(null));
            }
            if (!createdMeta.getLocation().isPresent()) {
                createdMeta.setLocation(location);
            }
            createdMeta.setResourceType(resourceType.getName());
            ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNode).ifPresent(arg_0 -> ((Meta)createdMeta).setVersion(arg_0));
            Supplier<String> errorMessage = () -> "ID attribute not set on updated resource";
            String resourceId = (String)resourceNode.getId().orElseThrow(() -> new InternalServerException((String)errorMessage.get(), null, null));
            if (!resourceId.equals(id) && !resourceType.getFeatures().isSingletonEndpoint()) {
                throw new InternalServerException("the id of the returned resource does not match the requested id: requestedId: '" + id + "', returnedId: '" + resourceId + "'", null, null);
            }
            Optional<AbstractResourceValidator> responseValidator = resourceHandler.getResponseValidator(null, null, (JsonNode)resourceNode, this.getReferenceUrlSupplier(baseUrlSupplier));
            ResourceNode responseResource = resourceNode;
            if (responseValidator.isPresent()) {
                responseResource = responseValidator.get().validateDocument((JsonNode)resourceNode);
            }
            return new UpdateResponse((JsonNode)responseResource, location, meta);
        }
        catch (RequestContextException ex) {
            ErrorResponse errorResponse = new ErrorResponse((ScimException)ex);
            ex.getValidationContext().writeToErrorResponse(errorResponse);
            return errorResponse;
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    protected ScimResponse deleteResource(String endpoint, String id, Map<String, String> httpHeaders, Context context) {
        try {
            ResourceType resourceType = this.getResourceType(endpoint);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            Interceptor interceptor = resourceHandler.getInterceptor(EndpointType.DELETE);
            return (ScimResponse)interceptor.doAround(() -> {
                Supplier<ResourceNode> oldResourceSupplier = () -> resourceHandler.getResourceForUpdate(id, null, null, context, EndpointType.DELETE);
                this.validateResourceVersion(id, resourceType, oldResourceSupplier, httpHeaders);
                resourceHandler.deleteResource(id, context);
                return new DeleteResponse();
            });
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    protected ScimResponse patchResource(String endpoint, String id, String requestBody, String attributes, String excludedAttributes, Supplier<String> baseUrlSupplier, Context context) {
        try {
            if (!this.serviceProvider.getPatchConfig().isSupported()) {
                throw new NotImplementedException("patch is not supported by this service provider");
            }
            ResourceType resourceType = this.getResourceType(endpoint);
            ResourceHandler resourceHandler = resourceType.getResourceHandlerImpl();
            Schema patchSchema = this.resourceTypeFactory.getSchemaFactory().getMetaSchema("urn:ietf:params:scim:api:messages:2.0:PatchOp");
            JsonNode patchDocument = JsonHelper.readJsonDocument((String)requestBody);
            if (patchDocument == null) {
                throw new BadRequestException("Missing patch request body");
            }
            patchDocument = new RequestSchemaValidator(this.serviceProvider, ScimObjectNode.class, HttpMethod.PATCH).validateDocument(patchSchema, patchDocument);
            PatchOpRequest patchOpRequest = (PatchOpRequest)JsonHelper.copyResourceToObject((JsonNode)patchDocument, PatchOpRequest.class);
            PatchRequestHandler patchRequestHandler = new PatchRequestHandler(id, resourceHandler, this.getPatchWorkarounds(), context);
            List<SchemaAttribute> attributesList = RequestUtils.getAttributes(resourceType, attributes);
            List<SchemaAttribute> excludedAttributesList = RequestUtils.getAttributes(resourceType, excludedAttributes);
            Supplier oldResourceSupplier = patchRequestHandler.getOldResourceSupplier(id, attributesList, excludedAttributesList);
            Interceptor patchInterceptor = resourceHandler.getInterceptor(EndpointType.PATCH);
            ResourceNode updatedResource = patchInterceptor.doAround(() -> {
                ResourceNode resourceNode = null;
                if (this.serviceProvider.getETagConfig().isSupported()) {
                    resourceNode = (ResourceNode)oldResourceSupplier.get();
                    ETagHandler.validateVersion(this.serviceProvider, resourceType, oldResourceSupplier, context.getUriInfos().getHttpHeaders());
                    Meta meta = resourceNode.getMeta().orElseGet(Meta::new);
                    resourceNode.remove("meta");
                    String location = context.getResourceReferenceUrl(id);
                    meta.setLocation(location);
                    meta.setResourceType(resourceType.getName());
                    resourceNode.setMeta(meta);
                    ETagHandler.getResourceVersion(this.serviceProvider, resourceType, resourceNode).ifPresent(arg_0 -> ((Meta)meta).setVersion(arg_0));
                }
                Object patchedResourceNode = patchRequestHandler.handlePatchRequest(patchOpRequest);
                patchedResourceNode.setId(id);
                Meta meta = patchedResourceNode.getMeta().orElseGet(Meta::new);
                Optional.ofNullable(resourceNode).flatMap(ResourceNode::getMeta).ifPresent(arg_0 -> this.lambda$patchResource$23(meta, resourceType, id, (Supplier)baseUrlSupplier, arg_0));
                return patchRequestHandler.getUpdatedResource(patchedResourceNode, attributesList, excludedAttributesList);
            });
            if (updatedResource == null) {
                return new EmptyPatchResponse(this.getLocation(resourceType, id, baseUrlSupplier));
            }
            Optional<AbstractResourceValidator> responseValidator = resourceHandler.getResponseValidator(attributesList, excludedAttributesList, (JsonNode)patchRequestHandler.getRequestedAttributes(), this.getReferenceUrlSupplier(baseUrlSupplier));
            ResourceNode responseResource = updatedResource;
            if (responseValidator.isPresent()) {
                responseResource = responseValidator.get().validateDocument((JsonNode)responseResource);
            }
            return new UpdateResponse((JsonNode)responseResource, this.getLocation(resourceType, id, baseUrlSupplier), (Meta)updatedResource.getMeta().orElseThrow(() -> new InternalServerException("Missing meta-attribute on patched resource")));
        }
        catch (RequestContextException ex) {
            ErrorResponse errorResponse = new ErrorResponse((ScimException)ex);
            ex.getValidationContext().writeToErrorResponse(errorResponse);
            return errorResponse;
        }
        catch (ScimException ex) {
            return new ErrorResponse(ex);
        }
        catch (Exception ex) {
            return new ErrorResponse((ScimException)new InternalServerException(ex.getMessage(), (Throwable)ex, null));
        }
    }

    private ResourceType getResourceType(String endpoint) {
        Supplier<String> errorMessage = () -> "no resource found for endpoint '" + endpoint + "'";
        ResourceType resourceType = Optional.ofNullable(this.resourceTypeFactory.getResourceType(endpoint)).orElseThrow(() -> new BadRequestException((String)errorMessage.get(), null, "unknownResource"));
        log.trace("Determined resource type '{}'", (Object)resourceType.getName());
        return resourceType;
    }

    private String getLocation(ResourceType resourceType, String resourceId, Supplier<String> getBaseUrlSupplier) {
        String baseUrl = getBaseUrlSupplier == null ? null : getBaseUrlSupplier.get();
        String escapedResourceId = EncodingUtils.urlEncode((String)resourceId);
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            return StringUtils.stripToEmpty((String)System.getProperty("SCIM_BASE_URL")) + resourceType.getEndpoint() + (StringUtils.isBlank((CharSequence)escapedResourceId) ? "" : "/" + escapedResourceId);
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl + resourceType.getEndpoint() + (StringUtils.isBlank((CharSequence)escapedResourceId) ? "" : "/" + escapedResourceId);
    }

    BiFunction<String, String, String> getReferenceUrlSupplier(Supplier<String> baseUrl) {
        return (resourceId, resourceName) -> {
            Optional<ResourceType> resourceType = this.resourceTypeFactory.getResourceTypeByName((String)resourceName);
            String id = StringUtils.isBlank((CharSequence)resourceId) ? "" : "/" + resourceId;
            return resourceType.map(arg_0 -> ResourceEndpointHandler.lambda$getReferenceUrlSupplier$28((Supplier)baseUrl, id, arg_0)).orElse(null);
        };
    }

    private void validateResourceVersion(String id, ResourceType resourceType, Supplier<ResourceNode> oldResourceSupplier, Map<String, String> httpHeaders) {
        try {
            ETagHandler.validateVersion(this.serviceProvider, resourceType, oldResourceSupplier, httpHeaders);
        }
        catch (ResourceNotFoundException ex) {
            throw new ResourceNotFoundException("the '" + resourceType.getName() + "' resource with id '" + id + "' does not exist", (Throwable)ex, null);
        }
    }

    @Generated
    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    @Generated
    public List<Supplier<PatchWorkaround>> getPatchWorkarounds() {
        return this.patchWorkarounds;
    }

    @Generated
    protected ResourceTypeFactory getResourceTypeFactory() {
        return this.resourceTypeFactory;
    }

    private static /* synthetic */ String lambda$getReferenceUrlSupplier$28(Supplier baseUrl, String id, ResourceType jsonNodes) {
        return (String)baseUrl.get() + jsonNodes.getEndpoint() + id;
    }

    private /* synthetic */ void lambda$patchResource$23(Meta meta, ResourceType resourceType, String id, Supplier baseUrlSupplier, Meta previousMeta) {
        meta.setResourceType(resourceType.getName());
        meta.setLocation(previousMeta.getLocation().orElse(this.getLocation(resourceType, id, baseUrlSupplier)));
        meta.setVersion((ETag)previousMeta.getVersion().orElse(null));
    }
}

