/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkget;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkget.ResourceReference;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

class BulkResourceReferenceComplex
implements ResourceReference {
    private final String resourceId;
    private final ResourceType resourceType;
    private final String nodePath;

    public BulkResourceReferenceComplex(ResourceTypeFactory resourceTypeFactory, String nodePath, JsonNode complexNode) {
        this.nodePath = nodePath;
        JsonNode valueNode = complexNode.get("value");
        this.resourceId = Optional.ofNullable(valueNode).map(JsonNode::textValue).orElseGet(() -> {
            String[] urlParts = this.getUrlPartsFromRef(complexNode).orElse(null);
            if (urlParts == null) {
                return null;
            }
            return urlParts[urlParts.length - 1];
        });
        JsonNode typeNode = complexNode.get("type");
        this.resourceType = Optional.ofNullable(typeNode).map(JsonNode::textValue).flatMap(resourceTypeFactory::getResourceTypeByName).orElseGet(() -> this.getResourceTypeFromRefValue(resourceTypeFactory, complexNode).orElse(null));
    }

    @Override
    public boolean isResourceRetrievable() {
        return this.resourceType != null && StringUtils.isNotBlank((CharSequence)this.resourceId);
    }

    private Optional<ResourceType> getResourceTypeFromRefValue(ResourceTypeFactory resourceTypeFactory, JsonNode complexNode) {
        String[] urlParts = this.getUrlPartsFromRef(complexNode).orElse(null);
        if (urlParts == null) {
            return Optional.empty();
        }
        String resourceEndpoint = String.format("/%s", urlParts[urlParts.length - 2]);
        ResourceType resourceType = resourceTypeFactory.getResourceType(resourceEndpoint);
        return Optional.ofNullable(resourceType);
    }

    private Optional<String[]> getUrlPartsFromRef(JsonNode complexNode) {
        JsonNode refNode = complexNode.get("$ref");
        String url = Optional.ofNullable(refNode).map(JsonNode::textValue).orElse(null);
        if (StringUtils.isBlank((CharSequence)url) || !this.isUrl(url)) {
            return Optional.empty();
        }
        return Optional.of(url.split("/"));
    }

    private boolean isUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Override
    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    @Generated
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    @Generated
    public String getNodePath() {
        return this.nodePath;
    }
}

