/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkget;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkget.BulkResourceReferenceComplex;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkget.BulkResourceReferenceSimple;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkget.ResourceReference;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

class ResourceReferenceExtractor {
    private final ObjectNode resource;
    private final ResourceType resourceType;
    private final ResourceTypeFactory resourceTypeFactory;

    public ResourceReferenceExtractor(ObjectNode resource, ResourceType resourceType, ResourceTypeFactory resourceTypeFactory) {
        this.resource = resource;
        this.resourceType = resourceType;
        this.resourceTypeFactory = resourceTypeFactory;
    }

    public List<ResourceReference> getResourceReferences() {
        List<ResourceReference> resourceReferences = this.extractSimpleResourceReferences();
        resourceReferences.addAll(this.extractComplexResourceReferences());
        return resourceReferences;
    }

    private List<ResourceReference> extractSimpleResourceReferences() {
        return Stream.concat(this.resourceType.getMainSchema().getSimpleBulkIdCandidates().stream().flatMap(schemaAttribute -> this.toSimpleResourceReference((SchemaAttribute)schemaAttribute, false).stream()), this.resourceType.getAllSchemaExtensions().stream().flatMap(schema -> schema.getSimpleBulkIdCandidates().stream()).flatMap(schemaAttribute -> this.toSimpleResourceReference((SchemaAttribute)schemaAttribute, true).stream())).collect(Collectors.toList());
    }

    private List<ResourceReference> extractComplexResourceReferences() {
        return Stream.concat(this.resourceType.getMainSchema().getComplexBulkIdCandidates().stream().flatMap(schemaAttribute -> this.toComplexResourceReference((SchemaAttribute)schemaAttribute, false).stream()), this.resourceType.getAllSchemaExtensions().stream().flatMap(schema -> schema.getComplexBulkIdCandidates().stream()).flatMap(schemaAttribute -> this.toComplexResourceReference((SchemaAttribute)schemaAttribute, true).stream())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<ResourceReference> toComplexResourceReference(SchemaAttribute schemaAttribute, boolean isExtensionAttribute) {
        if (isExtensionAttribute) {
            return this.getComplexAttributeReferenceFromExtension(schemaAttribute);
        }
        return this.getComplexAttributeReferenceFromResource(this.resource, schemaAttribute);
    }

    private List<ResourceReference> getComplexAttributeReferenceFromExtension(SchemaAttribute schemaAttribute) {
        String extensionUri = schemaAttribute.getSchema().getNonNullId();
        JsonNode extension = this.resource.get(extensionUri);
        if (extension == null) {
            return Collections.emptyList();
        }
        return this.getComplexAttributeReferenceFromResource((ObjectNode)extension, schemaAttribute);
    }

    private List<ResourceReference> getComplexAttributeReferenceFromResource(ObjectNode objectNode, SchemaAttribute schemaAttribute) {
        JsonNode resource = objectNode.get(schemaAttribute.getName());
        if (resource == null) {
            return Collections.emptyList();
        }
        if (schemaAttribute.isMultiValued() && resource.isArray()) {
            ArrayList<ResourceReference> resourceReferences = new ArrayList<ResourceReference>();
            for (JsonNode multivaluedComplexNode : resource) {
                this.toResourceReference(schemaAttribute.getScimNodeName(), (ObjectNode)multivaluedComplexNode).ifPresent(resourceReferences::add);
            }
            return resourceReferences;
        }
        return this.toResourceReference(schemaAttribute.getScimNodeName(), (ObjectNode)resource).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private Optional<ResourceReference> toResourceReference(String nodeName, ObjectNode complexNode) {
        BulkResourceReferenceComplex resourceReference = new BulkResourceReferenceComplex(this.resourceTypeFactory, nodeName, (JsonNode)complexNode);
        if (resourceReference.getResourceType() == null) {
            return Optional.empty();
        }
        return Optional.of(resourceReference);
    }

    private List<ResourceReference> toSimpleResourceReference(SchemaAttribute schemaAttribute, boolean isExtensionAttribute) {
        if (isExtensionAttribute) {
            return this.getSimpleAttributeReferenceFromExtension(schemaAttribute);
        }
        return this.getSimpleAttributeReferenceFromResource(this.resource, schemaAttribute);
    }

    private List<ResourceReference> getSimpleAttributeReferenceFromExtension(SchemaAttribute schemaAttribute) {
        String extensionUri = schemaAttribute.getSchema().getNonNullId();
        JsonNode extension = this.resource.get(extensionUri);
        if (extension == null) {
            return Collections.emptyList();
        }
        return this.getSimpleAttributeReferenceFromResource((ObjectNode)extension, schemaAttribute);
    }

    private List<ResourceReference> getSimpleAttributeReferenceFromResource(ObjectNode objectNode, SchemaAttribute schemaAttribute) {
        ObjectNode resource;
        boolean hasParent;
        boolean bl = hasParent = schemaAttribute.getParent() != null;
        if (hasParent) {
            resource = objectNode.get(schemaAttribute.getParent().getName());
            if (schemaAttribute.getParent().isMultiValued() && resource != null && resource.isArray()) {
                return this.getArrayNodeElementReferences((ArrayNode)resource, schemaAttribute);
            }
        } else {
            resource = objectNode;
        }
        if (resource == null) {
            return Collections.emptyList();
        }
        JsonNode attribute = resource.get(schemaAttribute.getName());
        if (attribute == null) {
            return Collections.emptyList();
        }
        if (schemaAttribute.isMultiValued() && attribute.isArray()) {
            return this.getArrayNodeElementReferences((ArrayNode)attribute, schemaAttribute);
        }
        return Collections.singletonList(new BulkResourceReferenceSimple(this.resourceTypeFactory, this.resourceType, schemaAttribute.getScimNodeName(), attribute));
    }

    private List<ResourceReference> getArrayNodeElementReferences(ArrayNode resource, SchemaAttribute schemaAttribute) {
        ArrayList<ResourceReference> resourceReferences = new ArrayList<ResourceReference>();
        for (JsonNode arrayElement : resource) {
            if (arrayElement.isObject()) {
                JsonNode attribute = arrayElement.get(schemaAttribute.getName());
                if (schemaAttribute.isMultiValued() && attribute.isArray()) {
                    resourceReferences.addAll(this.getArrayNodeElementReferences((ArrayNode)attribute, schemaAttribute));
                    continue;
                }
                resourceReferences.add(new BulkResourceReferenceSimple(this.resourceTypeFactory, this.resourceType, schemaAttribute.getScimNodeName(), attribute));
                continue;
            }
            resourceReferences.add(new BulkResourceReferenceSimple(this.resourceTypeFactory, this.resourceType, schemaAttribute.getScimNodeName(), arrayElement));
        }
        return resourceReferences;
    }

    @Generated
    public static ResourceReferenceExtractorBuilder builder() {
        return new ResourceReferenceExtractorBuilder();
    }

    @Generated
    public static class ResourceReferenceExtractorBuilder {
        @Generated
        private ObjectNode resource;
        @Generated
        private ResourceType resourceType;
        @Generated
        private ResourceTypeFactory resourceTypeFactory;

        @Generated
        ResourceReferenceExtractorBuilder() {
        }

        @Generated
        public ResourceReferenceExtractorBuilder resource(ObjectNode resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public ResourceReferenceExtractorBuilder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Generated
        public ResourceReferenceExtractorBuilder resourceTypeFactory(ResourceTypeFactory resourceTypeFactory) {
            this.resourceTypeFactory = resourceTypeFactory;
            return this;
        }

        @Generated
        public ResourceReferenceExtractor build() {
            return new ResourceReferenceExtractor(this.resource, this.resourceType, this.resourceTypeFactory);
        }

        @Generated
        public String toString() {
            return "ResourceReferenceExtractor.ResourceReferenceExtractorBuilder(resource=" + this.resource + ", resourceType=" + (Object)((Object)this.resourceType) + ", resourceTypeFactory=" + this.resourceTypeFactory + ")";
        }
    }
}

