/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkid;

import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.request.PatchOpRequest;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdResolverAbstract;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdResolverPatch;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdResolverResource;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.CircularReferenceDetector;
import de.captaingoldfish.scim.sdk.server.utils.UriInfos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class BulkIdResolver {
    private final Map<String, String> resolvedBulkIds = new HashMap<String, String>();
    private final Map<String, BulkIdResolverAbstract> bulkIdResourceResolverMap = new HashMap<String, BulkIdResolverAbstract>();
    private final CircularReferenceDetector circularReferenceDetector = new CircularReferenceDetector();

    public void addResolvedBulkId(String bulkId, String resourceId) {
        if (StringUtils.isBlank((CharSequence)bulkId)) {
            return;
        }
        this.resolvedBulkIds.put(bulkId, resourceId);
        ArrayList completelyResolvedOperations = new ArrayList();
        this.bulkIdResourceResolverMap.values().forEach(resolver -> {
            resolver.replaceBulkIdNode(bulkId, resourceId);
            if (!resolver.hasAnyBulkIdReferences()) {
                completelyResolvedOperations.add(bulkId);
            }
        });
        completelyResolvedOperations.forEach(this.bulkIdResourceResolverMap::remove);
    }

    public Optional<BulkIdResolverAbstract> getBulkIdResolver(String bulkId) {
        return Optional.ofNullable(this.bulkIdResourceResolverMap.get(bulkId));
    }

    public BulkIdResolverAbstract createNewBulkIdResolver(String operationBulkId, UriInfos operationUriInfo, String resourceString) {
        ScimObjectNode resource = HttpMethod.PATCH.equals((Object)operationUriInfo.getHttpMethod()) ? (ScimObjectNode)JsonHelper.readJsonDocument((String)resourceString, PatchOpRequest.class) : (ScimObjectNode)JsonHelper.readJsonDocument((String)resourceString, ScimObjectNode.class);
        BulkIdResolverAbstract bulkIdResolverAbstract = resource instanceof PatchOpRequest ? new BulkIdResolverPatch(operationBulkId, operationUriInfo, (PatchOpRequest)resource) : new BulkIdResolverResource(operationBulkId, operationUriInfo, (ObjectNode)resource);
        bulkIdResolverAbstract.findAllBulkIdReferences();
        this.checkForSelfReference(bulkIdResolverAbstract);
        this.checkForCircularReferences(bulkIdResolverAbstract);
        this.bulkIdResourceResolverMap.put(operationBulkId, bulkIdResolverAbstract);
        if (bulkIdResolverAbstract.hasAnyBulkIdReferences()) {
            this.resolvedBulkIds.forEach(bulkIdResolverAbstract::replaceBulkIdNode);
        }
        return bulkIdResolverAbstract;
    }

    private void checkForSelfReference(BulkIdResolverAbstract bulkIdResourceResolver) {
        boolean hasSelfReference = bulkIdResourceResolver.hasSelfReference();
        if (hasSelfReference) {
            String errorMessage = String.format("the bulkId '%s' is a self-reference. Self-references will not be resolved", bulkIdResourceResolver.getOperationBulkId());
            throw new BadRequestException(errorMessage, null, "invalidValue");
        }
    }

    private void checkForCircularReferences(BulkIdResolverAbstract bulkIdResourceResolver) {
        this.circularReferenceDetector.checkForCircles(bulkIdResourceResolver);
    }

    public boolean isOpenBulkIdReferences() {
        return this.bulkIdResourceResolverMap.values().stream().anyMatch(BulkIdResolverAbstract::hasAnyBulkIdReferences);
    }

    public boolean isDuplicateBulkId(String bulkId) {
        return this.resolvedBulkIds.containsKey(bulkId);
    }
}

