/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkid;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.request.PatchOpRequest;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceArrayWrapper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferencePatchNodeWrapper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceResourceWrapper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceWrapper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdResolverAbstract;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdResolverResource;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import de.captaingoldfish.scim.sdk.server.utils.UriInfos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkIdResolverPatch
extends BulkIdResolverAbstract<PatchOpRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkIdResolverPatch.class);

    public BulkIdResolverPatch(String operationBulkId, UriInfos uriInfos, PatchOpRequest resource) {
        super(operationBulkId, uriInfos, resource);
    }

    @Override
    protected List<BulkIdReferenceWrapper> getComplexBulkIdNodes() {
        ArrayList<BulkIdReferenceWrapper> bulkIdReferenceWrapperList = new ArrayList<BulkIdReferenceWrapper>();
        for (PatchRequestOperation operation : ((PatchOpRequest)this.resource).getOperations()) {
            List<BulkIdReferenceWrapper> referenceWrapperList;
            boolean isAddOrReplaceOperation = PatchOp.ADD.equals((Object)operation.getOp()) || PatchOp.REPLACE.equals((Object)operation.getOp());
            if (!isAddOrReplaceOperation) continue;
            if (operation.getPath().isPresent()) {
                referenceWrapperList = this.getBulkIdComplexNodesWithPath(operation, this.uriInfos.getResourceType());
                bulkIdReferenceWrapperList.addAll(referenceWrapperList);
                continue;
            }
            referenceWrapperList = this.getBulkIdComplexNodesFromResource(operation);
            bulkIdReferenceWrapperList.addAll(referenceWrapperList);
        }
        return bulkIdReferenceWrapperList;
    }

    private List<BulkIdReferenceWrapper> getBulkIdComplexNodesWithPath(PatchRequestOperation operation, ResourceType resourceType) {
        boolean isValueAttributeBulkCandidate;
        AttributePathRoot pathRoot = RequestUtils.parsePatchPath(resourceType, (String)operation.getPath().get());
        SchemaAttribute schemaAttribute = pathRoot.getSchemaAttribute();
        boolean isValueAttribute = "value".equals(schemaAttribute.getName());
        boolean isComplexAttributeBulkCandidate = schemaAttribute.isComplexBulkCandidate();
        boolean bl = isValueAttributeBulkCandidate = isValueAttribute && schemaAttribute.getParent() != null && schemaAttribute.getParent().isComplexBulkCandidate();
        if (isComplexAttributeBulkCandidate || isValueAttributeBulkCandidate) {
            return this.resolveComplexAttributePathReference(operation);
        }
        return Collections.emptyList();
    }

    private List<BulkIdReferenceWrapper> resolveComplexAttributePathReference(PatchRequestOperation operation) {
        ArrayList<BulkIdReferenceWrapper> bulkIdReferenceWrappers = new ArrayList<BulkIdReferenceWrapper>();
        List values = operation.getValues();
        for (int i = 0; i < values.size(); ++i) {
            String operationValue = (String)values.get(i);
            boolean containsBulkIdReference = StringUtils.contains((CharSequence)operationValue, (CharSequence)String.format("%s:", "bulkId"));
            if (!containsBulkIdReference) continue;
            BulkIdReferencePatchNodeWrapper wrapper = new BulkIdReferencePatchNodeWrapper(operation, operationValue, i);
            this.checkForBulkIdReferenceValidity(String.format("%s:%s", "bulkId", wrapper.getBulkId()));
            bulkIdReferenceWrappers.add(wrapper);
        }
        return bulkIdReferenceWrappers;
    }

    private List<BulkIdReferenceWrapper> getBulkIdComplexNodesFromResource(PatchRequestOperation operation) {
        ArrayNode valueNode = operation.getValueNode().orElse(null);
        if (valueNode == null || valueNode.size() != 1) {
            if (valueNode != null && valueNode.size() > 1) {
                log.debug("Found error in patch request during bulkId reference resolving. Too many value nodes are present in patch-request without a path-attribute. The value node must be represented by the resource itself. @see RFC7644#3.5.2.1 - 3.5.2.3.");
            }
            return Collections.emptyList();
        }
        BulkIdResolverResource bulkIdResolverResource = new BulkIdResolverResource(null, this.uriInfos, (ObjectNode)valueNode.get(0));
        bulkIdResolverResource.findAllBulkIdReferences();
        return bulkIdResolverResource.getComplexBulkIdNodes();
    }

    @Override
    protected List<BulkIdReferenceWrapper> getDirectBulkIdNodes() {
        ArrayList<BulkIdReferenceWrapper> bulkIdReferenceWrapperList = new ArrayList<BulkIdReferenceWrapper>();
        for (PatchRequestOperation operation : ((PatchOpRequest)this.resource).getOperations()) {
            List<BulkIdReferenceWrapper> referenceWrapperList;
            boolean isAddOrReplaceOperation = PatchOp.ADD.equals((Object)operation.getOp()) || PatchOp.REPLACE.equals((Object)operation.getOp());
            if (!isAddOrReplaceOperation) continue;
            if (operation.getPath().isPresent()) {
                referenceWrapperList = this.getSimpleBulkIdNodeFromPathRefNode(operation, this.uriInfos.getResourceType());
                bulkIdReferenceWrapperList.addAll(referenceWrapperList);
                continue;
            }
            referenceWrapperList = this.getBulkIdSimpleNodesFromResource(operation);
            bulkIdReferenceWrapperList.addAll(referenceWrapperList);
        }
        return bulkIdReferenceWrapperList;
    }

    private List<BulkIdReferenceWrapper> getBulkIdSimpleNodesFromResource(PatchRequestOperation operation) {
        ArrayNode valueNode = operation.getValueNode().orElse(null);
        if (valueNode == null || valueNode.size() != 1) {
            if (valueNode != null && valueNode.size() > 1) {
                log.debug("Found error in patch request during bulkId reference resolving. Too many value nodes are present in patch-request without a path-attribute. The value node must be represented by the resource itself. @see RFC7644#3.5.2.1 - 3.5.2.3.");
            }
            return Collections.emptyList();
        }
        BulkIdResolverResource bulkIdResolverResource = new BulkIdResolverResource(null, this.uriInfos, (ObjectNode)valueNode.get(0));
        bulkIdResolverResource.findAllBulkIdReferences();
        return bulkIdResolverResource.getDirectBulkIdNodes();
    }

    private List<BulkIdReferenceWrapper> getSimpleBulkIdNodeFromPathRefNode(PatchRequestOperation operation, ResourceType resourceType) {
        ArrayNode valueNodeArray = operation.getValueNode().orElse(null);
        if (valueNodeArray == null) {
            return Collections.emptyList();
        }
        AttributePathRoot pathRoot = RequestUtils.parsePatchPath(resourceType, (String)operation.getPath().get());
        SchemaAttribute schemaAttribute = pathRoot.getSchemaAttribute();
        boolean isBulkIdCandidate = schemaAttribute.isSimpleValueBulkCandidate();
        if (!isBulkIdCandidate && Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            return this.getBulkIdReferencesFromComplexTypes(operation, schemaAttribute);
        }
        if (!isBulkIdCandidate) {
            return Collections.emptyList();
        }
        return this.getBulkIdReferencesOnSimpleTypes(operation);
    }

    private List<BulkIdReferenceWrapper> getBulkIdReferencesFromComplexTypes(PatchRequestOperation operation, SchemaAttribute schemaAttribute) {
        ArrayList<BulkIdReferenceWrapper> bulkIdReferenceWrappers = new ArrayList<BulkIdReferenceWrapper>();
        ArrayNode valueNodeArray = operation.getValueNode().orElse(null);
        List bulkIdAttributes = schemaAttribute.getSubAttributes().stream().filter(SchemaAttribute::isSimpleValueBulkCandidate).collect(Collectors.toList());
        if (bulkIdAttributes.isEmpty()) {
            return Collections.emptyList();
        }
        for (JsonNode complexNode : valueNodeArray) {
            if (!this.containsBulkIdReference(complexNode)) continue;
            for (SchemaAttribute subAttribute : bulkIdAttributes) {
                JsonNode node = complexNode.get(subAttribute.getName());
                if (node == null) continue;
                if (node.isArray()) {
                    for (int i = 0; i < node.size(); ++i) {
                        JsonNode arrayIndexNode = node.get(i);
                        if (!this.containsBulkIdReference(arrayIndexNode)) continue;
                        bulkIdReferenceWrappers.add(new BulkIdReferenceArrayWrapper((ArrayNode)node, i));
                    }
                    continue;
                }
                if (!this.containsBulkIdReference(node)) continue;
                bulkIdReferenceWrappers.add(new BulkIdReferenceResourceWrapper(complexNode, node, subAttribute));
            }
        }
        return bulkIdReferenceWrappers;
    }

    private List<BulkIdReferenceWrapper> getBulkIdReferencesOnSimpleTypes(PatchRequestOperation operation) {
        ArrayList<BulkIdReferenceWrapper> bulkIdReferenceWrappers = new ArrayList<BulkIdReferenceWrapper>();
        ArrayNode valueNodeArray = operation.getValueNode().orElse(null);
        for (int i = 0; i < valueNodeArray.size(); ++i) {
            JsonNode valueNode = valueNodeArray.get(i);
            if (!valueNode.isTextual() || !this.containsBulkIdReference(valueNode)) continue;
            String bulkIdReference = valueNode.textValue();
            this.checkForBulkIdReferenceValidity(bulkIdReference);
            bulkIdReferenceWrappers.add(new BulkIdReferenceArrayWrapper(valueNodeArray, i));
        }
        return bulkIdReferenceWrappers;
    }
}

