/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkid;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceArrayWrapper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceResourceWrapper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdReferenceWrapper;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdResolverAbstract;
import de.captaingoldfish.scim.sdk.server.utils.UriInfos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

class BulkIdResolverResource
extends BulkIdResolverAbstract<ObjectNode> {
    public BulkIdResolverResource(String operationBulkId, UriInfos uriInfos, ObjectNode resource) {
        super(operationBulkId, uriInfos, resource);
    }

    @Override
    protected List<BulkIdReferenceWrapper> getComplexBulkIdNodes() {
        List<BulkIdReferenceWrapper> valueNodes;
        Schema mainSchema = this.uriInfos.getResourceType().getMainSchema();
        List<Schema> schemaExtensions = this.uriInfos.getResourceType().getAllSchemaExtensions();
        Function<SchemaAttribute, SchemaAttribute> toValueAttribute = schemaAttribute -> schemaAttribute.getSubAttributes().stream().filter(a -> a.getName().equals("value")).findAny().get();
        List mainSchemaBulkIdNodes = mainSchema.getComplexBulkIdCandidates().stream().map(toValueAttribute).collect(Collectors.toList());
        List extensionBulkIdNodes = schemaExtensions.stream().flatMap(jsonNodes -> jsonNodes.getComplexBulkIdCandidates().stream().map(toValueAttribute)).collect(Collectors.toList());
        if (mainSchemaBulkIdNodes.isEmpty() && extensionBulkIdNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BulkIdReferenceWrapper> bulkIdNodes = new ArrayList<BulkIdReferenceWrapper>();
        for (SchemaAttribute bulkIdCandidate : mainSchemaBulkIdNodes) {
            valueNodes = this.getComplexBulkIdNodes(bulkIdCandidate, false);
            bulkIdNodes.addAll(valueNodes);
        }
        for (SchemaAttribute bulkIdCandidate : extensionBulkIdNodes) {
            valueNodes = this.getComplexBulkIdNodes(bulkIdCandidate, true);
            bulkIdNodes.addAll(valueNodes);
        }
        return bulkIdNodes;
    }

    private List<BulkIdReferenceWrapper> getComplexBulkIdNodes(SchemaAttribute valueNodeDefinition, boolean fromExtension) {
        JsonNode parentNode;
        List parentHierarchy = valueNodeDefinition.getParentHierarchy();
        JsonNode jsonNode = parentNode = fromExtension ? ((ObjectNode)this.resource).get(valueNodeDefinition.getSchema().getNonNullId()) : this.resource;
        if (parentNode == null) {
            return Collections.emptyList();
        }
        SchemaAttribute parentSchemaAttribute = (SchemaAttribute)parentHierarchy.get(0);
        if ((parentNode = parentNode.get(parentSchemaAttribute.getName())) == null) {
            return Collections.emptyList();
        }
        if (parentNode.isArray()) {
            ArrayList<BulkIdReferenceWrapper> retrievedAttributes = new ArrayList<BulkIdReferenceWrapper>();
            for (JsonNode jsonNode2 : parentNode) {
                JsonNode childNode = jsonNode2.get(valueNodeDefinition.getName());
                boolean isBulkIdReference = this.isBulkIdReferenceAfterRfc7644(childNode);
                if (!isBulkIdReference) continue;
                retrievedAttributes.add(new BulkIdReferenceResourceWrapper(jsonNode2, childNode, valueNodeDefinition));
            }
            return retrievedAttributes;
        }
        JsonNode childNode = parentNode.get(valueNodeDefinition.getName());
        boolean isBulkIdReference = this.isBulkIdReferenceAfterRfc7644(childNode);
        if (isBulkIdReference) {
            return Collections.singletonList(new BulkIdReferenceResourceWrapper(parentNode, childNode, valueNodeDefinition));
        }
        return Collections.emptyList();
    }

    @Override
    protected List<BulkIdReferenceWrapper> getDirectBulkIdNodes() {
        Schema mainSchema = this.uriInfos.getResourceType().getMainSchema();
        List<Schema> schemaExtensions = this.uriInfos.getResourceType().getAllSchemaExtensions();
        List mainSchemaBulkIdNodes = mainSchema.getSimpleBulkIdCandidates();
        List extensionBulkIdNodes = schemaExtensions.stream().flatMap(jsonNodes -> jsonNodes.getSimpleBulkIdCandidates().stream()).collect(Collectors.toList());
        ArrayList<BulkIdReferenceWrapper> bulkIdNodes = new ArrayList<BulkIdReferenceWrapper>();
        for (SchemaAttribute schemaAttribute : mainSchemaBulkIdNodes) {
            List<BulkIdReferenceWrapper> bulkIdWrapper = this.getSimpleBulkIdWrapperNodes(this.resource, schemaAttribute);
            bulkIdNodes.addAll(bulkIdWrapper);
        }
        for (SchemaAttribute schemaAttribute : extensionBulkIdNodes) {
            JsonNode extension = ((ObjectNode)this.resource).get(schemaAttribute.getSchema().getNonNullId());
            if (extension == null) continue;
            List<BulkIdReferenceWrapper> bulkIdWrapper = this.getSimpleBulkIdWrapperNodes(extension, schemaAttribute);
            bulkIdNodes.addAll(bulkIdWrapper);
        }
        return bulkIdNodes;
    }

    private List<BulkIdReferenceWrapper> getSimpleBulkIdWrapperNodes(JsonNode resource, SchemaAttribute schemaAttribute) {
        ArrayList<BulkIdReferenceWrapper> bulkIdWrapperNodes = new ArrayList<BulkIdReferenceWrapper>();
        if (schemaAttribute.getParent() == null) {
            List<BulkIdReferenceWrapper> simpleBulkIdReferences = this.getSimpleBulkIdReferences(resource, schemaAttribute);
            bulkIdWrapperNodes.addAll(simpleBulkIdReferences);
        } else {
            JsonNode parentAttribute = resource.get(schemaAttribute.getParent().getName());
            if (parentAttribute == null) {
                return Collections.emptyList();
            }
            if (parentAttribute.isArray()) {
                for (JsonNode childObjectNode : parentAttribute) {
                    List<BulkIdReferenceWrapper> bulkIdReferenceList = this.getSimpleBulkIdReferences(childObjectNode, schemaAttribute);
                    bulkIdWrapperNodes.addAll(bulkIdReferenceList);
                }
            } else {
                List<BulkIdReferenceWrapper> simpleBulkIdReferences = this.getSimpleBulkIdReferences(parentAttribute, schemaAttribute);
                bulkIdWrapperNodes.addAll(simpleBulkIdReferences);
            }
        }
        return bulkIdWrapperNodes;
    }

    private List<BulkIdReferenceWrapper> getSimpleBulkIdReferences(JsonNode resource, SchemaAttribute schemaAttribute) {
        ArrayList<BulkIdReferenceWrapper> bulkIdWrapperNodes = new ArrayList<BulkIdReferenceWrapper>();
        if (resource == null) {
            return Collections.emptyList();
        }
        JsonNode attribute = resource.get(schemaAttribute.getName());
        if (attribute == null) {
            return Collections.emptyList();
        }
        if (attribute.isArray()) {
            for (int i = 0; i < attribute.size(); ++i) {
                JsonNode node = attribute.get(i);
                if (!this.isBulkIdReferenceAfterCustomFeature(node)) continue;
                bulkIdWrapperNodes.add(new BulkIdReferenceArrayWrapper((ArrayNode)attribute, i));
            }
        } else {
            boolean isBulkIdReference = this.isBulkIdReferenceAfterCustomFeature(attribute);
            if (isBulkIdReference) {
                bulkIdWrapperNodes.add(new BulkIdReferenceResourceWrapper(resource, attribute, schemaAttribute));
            }
        }
        return bulkIdWrapperNodes;
    }

    private boolean isBulkIdReferenceAfterRfc7644(JsonNode jsonNode) {
        boolean isBulkIdReference;
        boolean bl = isBulkIdReference = jsonNode != null && jsonNode.isTextual() && jsonNode.textValue().startsWith(String.format("%s:", "bulkId"));
        if (isBulkIdReference) {
            this.checkForBulkIdReferenceValidity(jsonNode.textValue());
        }
        return isBulkIdReference;
    }

    private boolean isBulkIdReferenceAfterCustomFeature(JsonNode jsonNode) {
        boolean isBulkIdReference;
        boolean bl = isBulkIdReference = jsonNode != null && jsonNode.isTextual() && jsonNode.textValue().startsWith(String.format("%s:", "bulkId"));
        if (isBulkIdReference) {
            this.checkForBulkIdReferenceValidity(jsonNode.textValue());
        }
        return jsonNode.textValue().startsWith(String.format("%s:", "bulkId"));
    }
}

