/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.bulkid;

import de.captaingoldfish.scim.sdk.common.exceptions.ConflictException;
import de.captaingoldfish.scim.sdk.server.endpoints.bulkid.BulkIdResolverAbstract;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class CircularReferenceDetector {
    private final Map<String, Set<String>> circularReferenceMap = new HashMap<String, Set<String>>();

    CircularReferenceDetector() {
    }

    public void checkForCircles(BulkIdResolverAbstract bulkIdResourceResolver) {
        this.circularReferenceMap.put(bulkIdResourceResolver.getOperationBulkId(), bulkIdResourceResolver.getReferencedBulkIds());
        this.checkForCircles();
    }

    private void checkForCircles() {
        for (String bulkId : this.circularReferenceMap.keySet()) {
            Set<String> referencedBulkIds = this.circularReferenceMap.get(bulkId);
            this.checkForCircles(bulkId, bulkId, referencedBulkIds);
        }
    }

    private void checkForCircles(String circleStart, String lastAccessedBulkId, Set<String> referencedBulkIds) {
        for (String referencedBulkId : referencedBulkIds) {
            if (referencedBulkId.equals(circleStart)) {
                String errorMessage = String.format("the bulkIds '%s' and '%s' form a direct or indirect circular reference that cannot be resolved.", circleStart, lastAccessedBulkId);
                throw new ConflictException(errorMessage);
            }
            Set nextReferencedBulkIds = Optional.ofNullable(this.circularReferenceMap.get(referencedBulkId)).map(HashSet::new).orElse(null);
            if (nextReferencedBulkIds == null) continue;
            this.checkForCircles(circleStart, referencedBulkId, nextReferencedBulkIds);
        }
    }
}

