/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.handler;

import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.exceptions.NotImplementedException;
import de.captaingoldfish.scim.sdk.common.exceptions.ResourceNotFoundException;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.response.PartialListResponse;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypeHandler
extends ResourceHandler<ResourceType> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceTypeHandler.class);
    private static final Function<String, String> ERROR_MESSAGE_SUPPLIER = operation -> "the '" + operation + "'-operation is not supported for ResourceTypes";
    private ResourceTypeFactory resourceTypeFactory;

    @Override
    public ResourceType createResource(ResourceType resource, Context context) {
        throw new NotImplementedException(ERROR_MESSAGE_SUPPLIER.apply("create"));
    }

    @Override
    public ResourceType getResource(String id, List<SchemaAttribute> attributes, List<SchemaAttribute> excludedAttributes, Context context) {
        return this.resourceTypeFactory.getResourceTypeByName(id).orElseThrow(() -> new ResourceNotFoundException("a ResourceType with the name '" + id + "' does not exist", null, null));
    }

    @Override
    public PartialListResponse listResources(long startIndex, int count, FilterNode filter, SchemaAttribute sortBy, SortOrder sortOrder, List<SchemaAttribute> attributes, List<SchemaAttribute> excludedAttributes, Context context) {
        ArrayList<ResourceType> resourceTypeList = new ArrayList<ResourceType>(this.resourceTypeFactory.getAllResourceTypes());
        return PartialListResponse.builder().resources(resourceTypeList).totalResults(resourceTypeList.size()).build();
    }

    @Override
    public ResourceType updateResource(ResourceType resourceToUpdate, Context context) {
        throw new NotImplementedException(ERROR_MESSAGE_SUPPLIER.apply("update"));
    }

    @Override
    public void deleteResource(String id, Context context) {
        throw new NotImplementedException(ERROR_MESSAGE_SUPPLIER.apply("delete"));
    }

    @Generated
    public ResourceTypeHandler(ResourceTypeFactory resourceTypeFactory) {
        this.resourceTypeFactory = resourceTypeFactory;
    }
}

