/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.endpoints.handler;

import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.exceptions.NotImplementedException;
import de.captaingoldfish.scim.sdk.common.exceptions.ResourceNotFoundException;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.response.PartialListResponse;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public class SchemaHandler
extends ResourceHandler<Schema> {
    private static final Function<String, String> ERROR_MESSAGE_SUPPLIER = operation -> "the '" + operation + "'-operation is not supported for Schemas";
    private final ResourceTypeFactory resourceTypeFactory;

    @Override
    public Schema createResource(Schema resource, Context context) {
        throw new NotImplementedException(ERROR_MESSAGE_SUPPLIER.apply("create"));
    }

    @Override
    public Schema getResource(String id, List<SchemaAttribute> attributes, List<SchemaAttribute> excludedAttributes, Context context) {
        Schema schema = this.resourceTypeFactory.getAllResourceTypes().stream().map(ResourceType::getAllSchemas).flatMap(Collection::stream).distinct().filter(s -> id.equals(s.getId().orElse(null))).findAny().orElse(null);
        if (schema == null) {
            throw new ResourceNotFoundException("a schema with the uri identifier '" + id + "' does not exist", null, null);
        }
        return schema;
    }

    @Override
    public PartialListResponse<Schema> listResources(long startIndex, int count, FilterNode filter, SchemaAttribute sortBy, SortOrder sortOrder, List<SchemaAttribute> attributes, List<SchemaAttribute> excludedAttributes, Context context) {
        String excludedSchema = "urn:ietf:params:scim:schemas:core:2.0:Schema";
        List allSchemas = this.resourceTypeFactory.getAllResourceTypes().stream().map(ResourceType::getAllSchemas).flatMap(Collection::stream).filter(schema -> !schema.getNonNullId().equals("urn:ietf:params:scim:schemas:core:2.0:Schema")).distinct().collect(Collectors.toList());
        return PartialListResponse.builder().resources(allSchemas).totalResults(allSchemas.size()).build();
    }

    @Override
    public Schema updateResource(Schema schema, Context context) {
        throw new NotImplementedException(ERROR_MESSAGE_SUPPLIER.apply("update"));
    }

    @Override
    public void deleteResource(String id, Context context) {
        throw new NotImplementedException(ERROR_MESSAGE_SUPPLIER.apply("delete"));
    }

    @Generated
    public SchemaHandler(ResourceTypeFactory resourceTypeFactory) {
        this.resourceTypeFactory = resourceTypeFactory;
    }
}

