/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.filter;

import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.filter.FilterNode;
import de.captaingoldfish.scim.sdk.server.filter.antlr.FilterAttributeName;
import de.captaingoldfish.scim.sdk.server.filter.antlr.ScimFilterParser;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.util.Optional;
import lombok.Generated;

public class AttributePathRoot
extends FilterNode {
    private final FilterNode child;
    private final FilterAttributeName filterAttributeName;
    private final SchemaAttribute schemaAttribute;
    private final SchemaAttribute subAttribute;
    private String originalExpressionString;

    protected AttributePathRoot() {
        this.child = null;
        this.filterAttributeName = null;
        this.schemaAttribute = null;
        this.subAttribute = null;
    }

    public AttributePathRoot(FilterNode child, ResourceType resourceType, ScimFilterParser.ValuePathContext ctx) {
        this.child = child;
        this.filterAttributeName = new FilterAttributeName((ScimFilterParser.ValuePathContext)null, ctx.attributePath());
        this.schemaAttribute = RequestUtils.getSchemaAttributeForFilter(resourceType, this.filterAttributeName);
        this.setSubAttributeName(ctx.subattribute == null ? null : ctx.subattribute.getText());
        if (this.getSubAttributeName() == null) {
            this.subAttribute = null;
        } else {
            String subAttributeNameRef = String.format("%s.%s", this.filterAttributeName, this.getSubAttributeName());
            this.subAttribute = RequestUtils.getSchemaAttributeByAttributeName(resourceType, subAttributeNameRef);
        }
    }

    public AttributePathRoot(SchemaAttribute schemaAttribute) {
        String parentAttributeName = Optional.ofNullable(schemaAttribute.getParent()).map(SchemaAttribute::getName).orElseGet(() -> ((SchemaAttribute)schemaAttribute).getName());
        String childAttributeName = Optional.ofNullable(schemaAttribute.getParent()).map(t -> schemaAttribute.getName()).orElse(null);
        this.child = null;
        this.filterAttributeName = new FilterAttributeName(schemaAttribute.getSchema().getNonNullId(), parentAttributeName, childAttributeName);
        this.schemaAttribute = Optional.ofNullable(schemaAttribute.getParent()).orElse(schemaAttribute);
        this.setSubAttributeName(childAttributeName);
        this.subAttribute = schemaAttribute;
    }

    public boolean isWithFilter() {
        return this.child != null;
    }

    public boolean isWithSubAttributeRef() {
        return this.subAttribute != null;
    }

    public SchemaAttribute getDirectlyReferencedAttribute() {
        if (this.subAttribute == null) {
            return this.schemaAttribute;
        }
        return this.subAttribute;
    }

    public String getResourceUri() {
        return this.filterAttributeName.getResourceUri();
    }

    public String getShortName() {
        return this.filterAttributeName.getShortName();
    }

    public String getFullName() {
        return this.filterAttributeName.getFullName();
    }

    public String getParentAttributeName() {
        return this.filterAttributeName.getParentAttributeName();
    }

    public String getComplexSubAttributeName() {
        return this.filterAttributeName.getComplexSubAttributeName();
    }

    public String getAttributeName() {
        return this.filterAttributeName.getAttributeName();
    }

    public String toString() {
        return this.originalExpressionString == null ? (this.child == null ? this.filterAttributeName.toString() : this.child.toString()) : this.originalExpressionString;
    }

    @Generated
    public FilterNode getChild() {
        return this.child;
    }

    @Generated
    public SchemaAttribute getSchemaAttribute() {
        return this.schemaAttribute;
    }

    @Generated
    public SchemaAttribute getSubAttribute() {
        return this.subAttribute;
    }

    @Generated
    public void setOriginalExpressionString(String originalExpressionString) {
        this.originalExpressionString = originalExpressionString;
    }
}

