/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.exceptions.ResourceNotFoundException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.features.EndpointType;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.RequestValidatorHandler;
import de.captaingoldfish.scim.sdk.server.patch.PatchOperationHandler;
import de.captaingoldfish.scim.sdk.server.patch.PatchTargetHandler;
import de.captaingoldfish.scim.sdk.server.patch.operations.MultivaluedComplexAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.MultivaluedComplexMultivaluedSubAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.MultivaluedComplexSimpleSubAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.MultivaluedSimpleAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.PatchOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.RemoveComplexAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.RemoveExtensionRefOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.SimpleAttributeOperation;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.validation.RequestResourceValidator;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPatchOperationHandler<T extends ResourceNode>
implements PatchOperationHandler<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPatchOperationHandler.class);
    private final Class<T> type;
    private final PatchConfig patchConfig;
    private final ResourceType resourceType;
    private final Context context;
    private T patchedResource;
    private T oldResource;

    public DefaultPatchOperationHandler(Class<T> type, PatchConfig patchConfig, ResourceType resourceType, Context context) {
        this.type = type;
        this.patchConfig = patchConfig;
        this.resourceType = resourceType;
        this.context = context;
    }

    @Override
    public Supplier<T> getOldResourceSupplier(String id, List<SchemaAttribute> attributes, List<SchemaAttribute> excludedAttributes, Context context) {
        return () -> {
            if (this.patchedResource == null) {
                this.patchedResource = this.resourceType.getResourceHandlerImpl().getResourceForUpdate(id, attributes, excludedAttributes, context, EndpointType.PATCH);
                this.oldResource = (ResourceNode)JsonHelper.readJsonDocument((String)this.patchedResource.toString(), this.type);
            }
            return this.oldResource;
        };
    }

    private boolean handlePatchOperation(String id, PatchOperation patchOperation) {
        PatchTargetHandler patchTargetHandler = new PatchTargetHandler(this.patchConfig, this.resourceType, patchOperation);
        T patchedResourceNode = this.getPatchedResource(id);
        List<String> values = patchOperation.getValueStringList().stream().map(object -> String.valueOf(object)).collect(Collectors.toList());
        if (log.isTraceEnabled()) {
            log.trace("handling '{}'-operation of type '{}' with values '{}'", new Object[]{patchOperation.getPatchOp(), patchOperation.getClass().getSimpleName(), values});
        }
        return patchTargetHandler.handleOperationValues((ResourceNode)patchedResourceNode, values);
    }

    @Override
    public boolean handleOperation(String id, RemoveExtensionRefOperation patchOperation) {
        return this.handlePatchOperation(id, patchOperation);
    }

    @Override
    public boolean handleOperation(String id, SimpleAttributeOperation patchOperation) {
        return this.handlePatchOperation(id, patchOperation);
    }

    @Override
    public boolean handleOperation(String id, MultivaluedSimpleAttributeOperation patchOperation) {
        return this.handlePatchOperation(id, patchOperation);
    }

    @Override
    public boolean handleOperation(String id, RemoveComplexAttributeOperation patchOperation) {
        return this.handlePatchOperation(id, patchOperation);
    }

    @Override
    public boolean handleOperation(String id, MultivaluedComplexAttributeOperation patchOperation) {
        return this.handlePatchOperation(id, patchOperation);
    }

    @Override
    public boolean handleOperation(String id, MultivaluedComplexMultivaluedSubAttributeOperation patchOperation) {
        return this.handlePatchOperation(id, patchOperation);
    }

    @Override
    public boolean handleOperation(String id, MultivaluedComplexSimpleSubAttributeOperation patchOperation) {
        return this.handlePatchOperation(id, patchOperation);
    }

    @Override
    public T getPatchedResource(String id) {
        if (this.patchedResource == null) {
            this.patchedResource = this.resourceType.getResourceHandlerImpl().getResource(id, Collections.emptyList(), Collections.emptyList(), this.context);
            if (this.patchedResource == null) {
                throw new ResourceNotFoundException("the '" + this.resourceType.getName() + "' resource with id '" + id + "' does not exist", null, null);
            }
            this.oldResource = (ResourceNode)JsonHelper.readJsonDocument((String)this.patchedResource.toString(), this.type);
        }
        return this.patchedResource;
    }

    @Override
    public T getUpdatedResource(String resourceId, T patchedResource, boolean wasResourceChanged, List<SchemaAttribute> attributes, List<SchemaAttribute> excludedAttributes, Context context) {
        if (wasResourceChanged) {
            ServiceProvider serviceProvider = this.resourceType.getResourceHandlerImpl().getServiceProvider();
            RequestResourceValidator requestResourceValidator = new RequestResourceValidator(serviceProvider, this.resourceType, HttpMethod.PATCH);
            ResourceNode validatedResource = (ResourceNode)requestResourceValidator.validateDocument((JsonNode)patchedResource);
            validatedResource.setId(resourceId);
            Supplier<ResourceNode> oldResourceSupplier = this.getOldResourceSupplier(resourceId, Collections.emptyList(), Collections.emptyList(), context);
            Meta meta = validatedResource.getMeta().orElseGet(() -> {
                Meta newMeta = new Meta();
                validatedResource.setMeta(newMeta);
                return newMeta;
            });
            String location = context.getResourceReferenceUrl(resourceId);
            meta.setLocation(location);
            meta.setResourceType(this.resourceType.getName());
            if (!meta.getCreated().isPresent()) {
                meta.setCreated(meta.getLastModified().orElseGet(Instant::now));
            }
            if (!meta.getLastModified().isPresent()) {
                meta.setLastModified((Instant)meta.getCreated().orElse(null));
            }
            new RequestValidatorHandler(this.resourceType.getResourceHandlerImpl(), requestResourceValidator, context).validateUpdate(oldResourceSupplier, validatedResource);
            validatedResource.setId(resourceId);
            return this.resourceType.getResourceHandlerImpl().updateResource(patchedResource, context);
        }
        return patchedResource;
    }
}

