/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidFilterException;
import de.captaingoldfish.scim.sdk.common.request.PatchOpRequest;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.ServiceProvider;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.endpoints.Context;
import de.captaingoldfish.scim.sdk.server.endpoints.ResourceHandler;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.RequestContextException;
import de.captaingoldfish.scim.sdk.server.endpoints.validation.ValidationContext;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.patch.PatchOperationHandler;
import de.captaingoldfish.scim.sdk.server.patch.operations.MultivaluedComplexAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.MultivaluedComplexMultivaluedSubAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.MultivaluedComplexSimpleSubAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.MultivaluedSimpleAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.RemoveComplexAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.RemoveExtensionRefOperation;
import de.captaingoldfish.scim.sdk.server.patch.operations.SimpleAttributeOperation;
import de.captaingoldfish.scim.sdk.server.patch.workarounds.PatchWorkaround;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.RequestAttributeValidator;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import de.captaingoldfish.scim.sdk.server.utils.ScimAttributeHelper;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchRequestHandler<T extends ResourceNode>
implements ScimAttributeHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PatchRequestHandler.class);
    private final PatchValidations patchValidations = new PatchValidations();
    private final String resourceId;
    private final ServiceProvider serviceProvider;
    private final PatchConfig patchConfig;
    private final ResourceType resourceType;
    private final List<Supplier<PatchWorkaround>> patchWorkarounds;
    private final Schema mainSchema;
    private final List<Schema> extensionSchemas;
    private final ValidationContext validationContext;
    private final Context requestContext;
    private final ScimObjectNode requestedAttributes = new ScimObjectNode();
    private boolean resourceChanged = false;
    private PatchOperationHandler<T> patchOperationHandler;

    public PatchRequestHandler(String resourceId, ResourceHandler resourceHandler, List<Supplier<PatchWorkaround>> patchWorkarounds, Context context) {
        this.resourceId = resourceId;
        this.serviceProvider = resourceHandler.getServiceProvider();
        this.patchConfig = resourceHandler.getServiceProvider().getPatchConfig();
        this.resourceType = resourceHandler.getResourceType();
        this.patchWorkarounds = patchWorkarounds;
        this.mainSchema = this.resourceType.getMainSchema();
        this.extensionSchemas = this.resourceType.getAllSchemaExtensions();
        this.patchOperationHandler = resourceHandler.getPatchOpResourceHandler(resourceId, context);
        this.validationContext = new ValidationContext(this.resourceType);
        this.requestContext = context;
    }

    public PatchRequestHandler(String resourceId, ServiceProvider serviceProviderConfig, ResourceType resourceType, PatchOperationHandler<T> patchOperationHandler) {
        this(resourceId, serviceProviderConfig, resourceType, patchOperationHandler, null);
    }

    public PatchRequestHandler(String resourceId, ServiceProvider serviceProviderConfig, ResourceType resourceType, PatchOperationHandler<T> patchOperationHandler, Context context) {
        this.resourceId = resourceId;
        this.serviceProvider = serviceProviderConfig;
        this.patchConfig = serviceProviderConfig.getPatchConfig();
        this.resourceType = resourceType;
        this.patchWorkarounds = Collections.emptyList();
        this.mainSchema = resourceType.getMainSchema();
        this.extensionSchemas = resourceType.getAllSchemaExtensions();
        this.patchOperationHandler = patchOperationHandler;
        this.validationContext = new ValidationContext(resourceType);
        this.requestContext = context;
    }

    public Supplier<T> getOldResourceSupplier(String id, List<SchemaAttribute> attributes, List<SchemaAttribute> excludedAttributes) {
        return this.patchOperationHandler.getOldResourceSupplier(id, attributes, excludedAttributes, this.requestContext);
    }

    public ResourceNode getUpdatedResource(T validatedPatchedResource, List<SchemaAttribute> attributes, List<SchemaAttribute> excludedAttributes) {
        return this.patchOperationHandler.getUpdatedResource(this.resourceId, validatedPatchedResource, this.resourceChanged, attributes, excludedAttributes, this.requestContext);
    }

    public T handlePatchRequest(PatchOpRequest patchOpRequest) {
        for (PatchRequestOperation operation : patchOpRequest.getOperations()) {
            this.handleSinglePatchOperation(operation);
        }
        if (this.validationContext.hasErrors()) {
            this.validationContext.logErrors();
            throw new RequestContextException(this.validationContext);
        }
        T resource = this.patchOperationHandler.getPatchedResource(this.resourceId);
        if (this.resourceChanged) {
            Optional metaOptional = resource.getMeta();
            if (metaOptional.isPresent()) {
                ((Meta)metaOptional.get()).setLastModified(LocalDateTime.now().truncatedTo(ChronoUnit.MILLIS));
            } else {
                Meta meta = Meta.builder().lastModified(LocalDateTime.now().truncatedTo(ChronoUnit.MILLIS)).build();
                resource.setMeta(meta);
            }
        }
        return resource;
    }

    private void handleSinglePatchOperation(PatchRequestOperation patchRequestOperation) {
        boolean isPathPresent = patchRequestOperation.getPath().isPresent();
        try {
            if (isPathPresent) {
                PatchPathHandler patchPathHandler;
                PatchRequestOperation fixedOperation = this.applyWorkaroundsToPatchOperation(patchRequestOperation);
                this.patchValidations.validateRemoveOperation(true, fixedOperation);
                String path = fixedOperation.getPath().orElse(null);
                Optional<Schema> extensionSchema = this.resourceType.getExtensionById(path);
                this.resourceChanged = extensionSchema.isPresent() ? this.handlePatchOnExtension(extensionSchema.get(), fixedOperation) || this.resourceChanged : (patchPathHandler = new PatchPathHandler()).handlePathOperation(fixedOperation) || this.resourceChanged;
            } else {
                this.patchValidations.validateRemoveOperation(false, patchRequestOperation);
                PatchResourceHandler patchResourceHandler = new PatchResourceHandler();
                this.resourceChanged = patchResourceHandler.handleMainResource(this.mainSchema, patchRequestOperation) || this.resourceChanged;
            }
        }
        catch (AttributeValidationException ex) {
            this.validationContext.addExceptionMessages(ex);
        }
        catch (IgnoreSingleAttributeException | IgnoreWholeOperationException ex) {
            log.trace(ex.getMessage(), (Throwable)ex);
        }
    }

    private PatchRequestOperation applyWorkaroundsToPatchOperation(PatchRequestOperation patchRequestOperation) {
        PatchRequestOperation fixedOperation = patchRequestOperation;
        for (Supplier<PatchWorkaround> patchWorkaroundSupplier : this.patchWorkarounds) {
            PatchWorkaround patchWorkaround = patchWorkaroundSupplier.get();
            if (!patchWorkaround.shouldBeHandled(this.patchConfig, this.resourceType, fixedOperation)) continue;
            fixedOperation = patchWorkaround.fixPatchRequestOperaton(this.resourceType, fixedOperation);
            if (patchWorkaround.executeOtherHandlers()) continue;
            break;
        }
        return fixedOperation;
    }

    private AttributePathRoot getAttributePath(PatchRequestOperation fixedOperation) {
        try {
            return RequestUtils.parsePatchPath(this.resourceType, fixedOperation.getPath().orElse(null));
        }
        catch (InvalidFilterException ex) {
            if (this.patchConfig.isIgnoreUnknownAttribute()) {
                log.debug("Ignoring invalid path '{}'", (Object)fixedOperation.getPath());
                throw new IgnoreWholeOperationException();
            }
            throw new BadRequestException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void addAttributeToRequestedAttributes(SchemaAttribute schemaAttribute) {
        if (schemaAttribute == null) {
            return;
        }
        if (schemaAttribute.getParent() == null) {
            if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
                this.requestedAttributes.set(schemaAttribute.getName(), (JsonNode)new ObjectNode(JsonNodeFactory.instance));
            } else {
                this.requestedAttributes.set(schemaAttribute.getName(), (JsonNode)new TextNode(""));
            }
        } else {
            String parentName = schemaAttribute.getParent().getName();
            ObjectNode complexNode = (ObjectNode)Optional.ofNullable(this.requestedAttributes.get(parentName)).orElseGet(() -> {
                ScimObjectNode objectNode = new ScimObjectNode();
                this.requestedAttributes.set(parentName, (JsonNode)objectNode);
                return objectNode;
            });
            JsonNode attribute = complexNode.get(schemaAttribute.getName());
            if (attribute == null) {
                complexNode.set(schemaAttribute.getName(), (JsonNode)new TextNode(""));
            }
        }
    }

    private boolean handlePatchOnExtension(Schema schema, PatchRequestOperation fixedOperation) {
        if (PatchOp.REMOVE.equals((Object)fixedOperation.getOp())) {
            return this.patchOperationHandler.handleOperation(this.resourceId, new RemoveExtensionRefOperation(schema, fixedOperation.getOp()));
        }
        if (fixedOperation.getValues().size() > 1) {
            throw new BadRequestException(String.format("Patch request contains too many values. Expected a single value representing an extension but got several. '%s'", fixedOperation.getValues()));
        }
        String value = (String)fixedOperation.getValues().get(0);
        ObjectNode extension = (ObjectNode)JsonHelper.readJsonDocument((String)value);
        if (extension == null) {
            String errorMessage = String.format("Received invalid data on patch values. Expected an extension resource but got: '%s'", value);
            throw new BadRequestException(errorMessage);
        }
        PatchResourceHandler patchResourceHandler = new PatchResourceHandler();
        boolean changeMade = patchResourceHandler.handleExtensionResource(schema, (JsonNode)extension, fixedOperation.getOp());
        String path = schema.getNonNullId();
        this.requestedAttributes.set(path, (JsonNode)extension);
        return changeMade;
    }

    @Generated
    public PatchValidations getPatchValidations() {
        return this.patchValidations;
    }

    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Generated
    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    @Generated
    public PatchConfig getPatchConfig() {
        return this.patchConfig;
    }

    @Generated
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Generated
    public List<Supplier<PatchWorkaround>> getPatchWorkarounds() {
        return this.patchWorkarounds;
    }

    @Generated
    public Schema getMainSchema() {
        return this.mainSchema;
    }

    @Generated
    public List<Schema> getExtensionSchemas() {
        return this.extensionSchemas;
    }

    @Generated
    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    @Generated
    public Context getRequestContext() {
        return this.requestContext;
    }

    @Generated
    public ScimObjectNode getRequestedAttributes() {
        return this.requestedAttributes;
    }

    @Generated
    public boolean isResourceChanged() {
        return this.resourceChanged;
    }

    @Generated
    public PatchOperationHandler<T> getPatchOperationHandler() {
        return this.patchOperationHandler;
    }

    private class PatchValidations {
        private PatchValidations() {
        }

        private void validateRemoveOperation(boolean isPathPresent, PatchRequestOperation patchRequestOperation) {
            boolean isRemoveOperation = PatchOp.REMOVE.equals((Object)patchRequestOperation.getOp());
            if (!isRemoveOperation) {
                return;
            }
            if (!isPathPresent) {
                throw new BadRequestException("Missing target for remove operation", "noTarget");
            }
            JsonNode valueNode = patchRequestOperation.getValueNode().orElse(null);
            if (valueNode != null && !valueNode.isNull()) {
                throw new BadRequestException(String.format("Values must not be set for remove operation but was: %s", valueNode), "invalidValue");
            }
        }

        private JsonNode validateCurrentAttribute(SchemaAttribute schemaAttribute, Map.Entry<String, JsonNode> resourceField) {
            if (schemaAttribute.isReadOnly()) {
                throw new IgnoreSingleAttributeException();
            }
            JsonNode attributeValue = resourceField.getValue();
            if (attributeValue == null || attributeValue.isNull() || attributeValue.isArray() && attributeValue.isEmpty()) {
                return attributeValue;
            }
            JsonNode validatedNode = RequestAttributeValidator.validateAttribute(PatchRequestHandler.this.serviceProvider, schemaAttribute, attributeValue, HttpMethod.PATCH).orElse((JsonNode)NullNode.getInstance());
            if (schemaAttribute.isMultivaluedComplexAttribute()) {
                ArrayNode arrayNode;
                if (validatedNode.isArray()) {
                    arrayNode = (ArrayNode)validatedNode;
                } else {
                    arrayNode = new ArrayNode(JsonNodeFactory.instance);
                    arrayNode.add(validatedNode);
                }
                for (JsonNode complexNode : arrayNode) {
                    for (SchemaAttribute subAttribute : schemaAttribute.getSubAttributes()) {
                        RequestAttributeValidator.validateAttribute(PatchRequestHandler.this.serviceProvider, subAttribute, complexNode.get(subAttribute.getName()), HttpMethod.PATCH);
                    }
                }
            }
            return validatedNode;
        }

        private void validateMutability(SchemaAttribute schemaAttribute) {
            if (Mutability.READ_ONLY.equals((Object)schemaAttribute.getMutability())) {
                throw new IgnoreSingleAttributeException();
            }
            if (schemaAttribute.getParent() != null && Mutability.READ_ONLY.equals((Object)schemaAttribute.getParent().getMutability())) {
                throw new IgnoreSingleAttributeException();
            }
        }
    }

    private class PatchPathHandler
    extends AbstractPatchOperationHandler {
        private PatchPathHandler() {
        }

        private boolean handlePathOperation(PatchRequestOperation patchOperation) {
            AttributePathRoot attributePath = PatchRequestHandler.this.getAttributePath(patchOperation);
            SchemaAttribute schemaAttribute = attributePath.getDirectlyReferencedAttribute();
            PatchOp patchOp = patchOperation.getOp();
            JsonNode valueNode = patchOperation.getValue().orElse(null);
            if (attributePath.isWithFilter()) {
                valueNode = PatchRequestHandler.this.patchValidations.validateCurrentAttribute(schemaAttribute, new AbstractMap.SimpleEntry<String, JsonNode>(schemaAttribute.getName(), valueNode));
                PatchRequestHandler.this.addAttributeToRequestedAttributes(schemaAttribute);
                if (attributePath.isWithSubAttributeRef() || schemaAttribute.isChildOfComplexAttribute()) {
                    if (schemaAttribute.isMultiValued()) {
                        return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new MultivaluedComplexMultivaluedSubAttributeOperation(attributePath, schemaAttribute, patchOp, valueNode));
                    }
                    return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new MultivaluedComplexSimpleSubAttributeOperation(attributePath, schemaAttribute, patchOp, valueNode));
                }
                if (schemaAttribute.isComplexAttribute()) {
                    return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new MultivaluedComplexAttributeOperation(attributePath, patchOp, valueNode));
                }
                return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new MultivaluedSimpleAttributeOperation(attributePath, patchOp, (ArrayNode)valueNode));
            }
            if (schemaAttribute.isChildOfMultivaluedComplexAttribute()) {
                valueNode = PatchRequestHandler.this.patchValidations.validateCurrentAttribute(schemaAttribute, new AbstractMap.SimpleEntry<String, JsonNode>(schemaAttribute.getName(), valueNode));
                return this.handleMultivaluedComplexSubAttribute(schemaAttribute, patchOp, valueNode);
            }
            return this.handleSingleResourceField(schemaAttribute, patchOp, new AbstractMap.SimpleEntry<String, JsonNode>(schemaAttribute.getName(), valueNode));
        }
    }

    private class PatchResourceHandler
    extends AbstractPatchOperationHandler {
        private PatchResourceHandler() {
        }

        private boolean handleMainResource(Schema schema, PatchRequestOperation patchRequestOperation) {
            ObjectNode resourceNode;
            this.validateRequest(patchRequestOperation);
            List values = patchRequestOperation.getValues();
            try {
                JsonNode jsonNode = JsonHelper.readJsonDocument((String)((String)values.get(0)));
                if (!jsonNode.isObject()) {
                    throw new IllegalStateException();
                }
                resourceNode = (ObjectNode)jsonNode;
            }
            catch (Exception ex) {
                throw new BadRequestException("The resourceNode is not a valid JSON-object", (Throwable)ex);
            }
            resourceNode.remove("schemas");
            PatchOp patchOp = patchRequestOperation.getOp();
            AtomicReference<Boolean> wasChanged = new AtomicReference<Boolean>(false);
            resourceNode.fields().forEachRemaining(field -> {
                if (((String)field.getKey()).equals("meta")) {
                    return;
                }
                Optional<Pair> matchingExtension = PatchRequestHandler.this.extensionSchemas.stream().filter(s -> ((String)field.getKey()).startsWith(s.getNonNullId())).map(s -> Pair.of((Object)s, (Object)s.getNonNullId().equals(field.getKey()))).findAny();
                boolean isMainResourceAttribute = !matchingExtension.isPresent();
                try {
                    boolean wasValueChanged;
                    if (isMainResourceAttribute) {
                        SchemaAttribute schemaAttribute = schema.getSchemaAttribute((String)field.getKey());
                        wasValueChanged = this.handleSingleResourceField(schemaAttribute, patchOp, (Map.Entry<String, JsonNode>)field) || (Boolean)wasChanged.get() != false;
                        PatchRequestHandler.this.addAttributeToRequestedAttributes(schemaAttribute);
                    } else {
                        Schema extensionSchema = (Schema)matchingExtension.get().getKey();
                        boolean isDirectExtensionReference = (Boolean)matchingExtension.get().getValue();
                        if (isDirectExtensionReference) {
                            JsonNode extensionNode = resourceNode.get(extensionSchema.getNonNullId());
                            wasValueChanged = this.handleExtensionResource(extensionSchema, extensionNode, patchOp);
                        } else {
                            SchemaAttribute extensionAttribute = extensionSchema.getSchemaAttribute((String)field.getKey());
                            wasValueChanged = this.handleSingleResourceField(extensionAttribute, patchOp, (Map.Entry<String, JsonNode>)field);
                        }
                    }
                    wasChanged.compareAndSet(false, wasValueChanged);
                }
                catch (IgnoreSingleAttributeException ex) {
                    log.debug("Ignoring attribute '{}' with value '{}'", field.getKey(), field.getValue());
                    log.trace(ex.getMessage(), (Throwable)ex);
                }
            });
            return wasChanged.get();
        }

        private boolean handleExtensionResource(Schema extensionSchema, JsonNode jsonNode, PatchOp patchOp) {
            if (jsonNode.isNull() || jsonNode.isEmpty()) {
                return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new RemoveExtensionRefOperation(extensionSchema, PatchOp.REMOVE));
            }
            ObjectNode extensionNode = (ObjectNode)jsonNode;
            ObjectNode requestedExtensionAttributes = new ObjectNode(JsonNodeFactory.instance);
            AtomicReference<Boolean> wasChanged = new AtomicReference<Boolean>(false);
            extensionNode.fields().forEachRemaining(extensionField -> {
                SchemaAttribute extensionAttribute = extensionSchema.getSchemaAttribute((String)extensionField.getKey());
                boolean wasValueChanged = this.handleSingleResourceField(extensionAttribute, patchOp, (Map.Entry<String, JsonNode>)extensionField) || (Boolean)wasChanged.get() != false;
                wasChanged.compareAndSet(false, wasValueChanged);
                if (extensionAttribute != null) {
                    requestedExtensionAttributes.set(extensionAttribute.getName(), (JsonNode)NullNode.getInstance());
                }
            });
            PatchRequestHandler.this.requestedAttributes.set(extensionSchema.getNonNullId(), (JsonNode)requestedExtensionAttributes);
            return wasChanged.get();
        }

        private void validateRequest(PatchRequestOperation patchRequestOperation) {
            List values = patchRequestOperation.getValues();
            if (values.size() != 1) {
                throw new BadRequestException("Patch operation without a path must contain only a single value that represents the resource itself", "invalidValue");
            }
        }
    }

    private static class IgnoreWholeOperationException
    extends RuntimeException {
        private IgnoreWholeOperationException() {
        }
    }

    private static class IgnoreSingleAttributeException
    extends RuntimeException {
        private IgnoreSingleAttributeException() {
        }
    }

    private abstract class AbstractPatchOperationHandler {
        private AbstractPatchOperationHandler() {
        }

        protected boolean handleSingleResourceField(SchemaAttribute schemaAttribute, PatchOp patchOp, Map.Entry<String, JsonNode> resourceField) {
            String fieldName = resourceField.getKey();
            if (schemaAttribute == null) {
                if (PatchRequestHandler.this.patchConfig.isIgnoreUnknownAttribute()) {
                    log.debug("Ignoring unknown attribute '{}'", (Object)fieldName);
                    return false;
                }
                throw new BadRequestException(String.format("Attribute '%s' is unknown to resource type '%s'", fieldName, PatchRequestHandler.this.resourceType.getName()), "invalidPath");
            }
            JsonNode attributeValue = resourceField.getValue();
            if (schemaAttribute.isMultivaluedComplexAttribute()) {
                attributeValue = PatchRequestHandler.this.patchValidations.validateCurrentAttribute(schemaAttribute, resourceField);
                return this.handleMultivaluedComplexAttribute(schemaAttribute, patchOp, attributeValue);
            }
            if (schemaAttribute.isMultiValued()) {
                attributeValue = PatchRequestHandler.this.patchValidations.validateCurrentAttribute(schemaAttribute, resourceField);
                return this.handleSimpleMultivaluedAttribute(schemaAttribute, patchOp, attributeValue);
            }
            if (schemaAttribute.isComplexAttribute()) {
                return this.handleComplexAttribute(schemaAttribute, patchOp, attributeValue);
            }
            if (schemaAttribute.isChildOfMultivaluedComplexAttribute()) {
                ScimObjectNode objectNode = new ScimObjectNode(schemaAttribute.getParent());
                objectNode.set(schemaAttribute.getName(), attributeValue);
                return this.handleMultivaluedComplexAttribute(schemaAttribute.getParent(), patchOp, (JsonNode)objectNode);
            }
            attributeValue = PatchRequestHandler.this.patchValidations.validateCurrentAttribute(schemaAttribute, resourceField);
            return this.handleSimpleAttribute(schemaAttribute, patchOp, attributeValue);
        }

        protected boolean handleMultivaluedComplexSubAttribute(SchemaAttribute multiComplexAttribute, PatchOp patchOp, JsonNode attributeValue) {
            AttributePathRoot attributePath = new AttributePathRoot(multiComplexAttribute);
            if (attributeValue == null || attributeValue.isNull()) {
                MultivaluedComplexMultivaluedSubAttributeOperation multiComplexOperation = new MultivaluedComplexMultivaluedSubAttributeOperation(attributePath, attributePath.getSubAttribute(), PatchOp.REMOVE);
                return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, multiComplexOperation);
            }
            SchemaAttribute schemaAttribute = attributePath.getDirectlyReferencedAttribute();
            if (schemaAttribute.isMultiValued()) {
                ArrayNode arrayNode;
                if (attributeValue instanceof ArrayNode) {
                    arrayNode = (ArrayNode)attributeValue;
                } else {
                    arrayNode = new ScimArrayNode(multiComplexAttribute);
                    arrayNode.add(attributeValue);
                }
                arrayNode = (ArrayNode)PatchRequestHandler.this.patchValidations.validateCurrentAttribute(multiComplexAttribute, new AbstractMap.SimpleEntry<String, ArrayNode>(schemaAttribute.getName(), arrayNode));
                PatchRequestHandler.this.addAttributeToRequestedAttributes(schemaAttribute);
                MultivaluedComplexMultivaluedSubAttributeOperation multiComplexOperation = new MultivaluedComplexMultivaluedSubAttributeOperation(attributePath, schemaAttribute, patchOp, (JsonNode)arrayNode);
                return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, multiComplexOperation);
            }
            JsonNode value = PatchRequestHandler.this.patchValidations.validateCurrentAttribute(multiComplexAttribute, new AbstractMap.SimpleEntry<String, JsonNode>(schemaAttribute.getName(), attributeValue));
            PatchRequestHandler.this.addAttributeToRequestedAttributes(schemaAttribute);
            MultivaluedComplexSimpleSubAttributeOperation multiComplexOperation = new MultivaluedComplexSimpleSubAttributeOperation(attributePath, schemaAttribute, patchOp, value);
            return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, multiComplexOperation);
        }

        private boolean handleMultivaluedComplexAttribute(SchemaAttribute multiComplexAttribute, PatchOp patchOp, JsonNode attributeValue) {
            ArrayNode arrayNode;
            AttributePathRoot attributePath = new AttributePathRoot(multiComplexAttribute);
            PatchRequestHandler.this.patchValidations.validateMutability(attributePath.getDirectlyReferencedAttribute());
            if (attributeValue == null || attributeValue.isNull()) {
                MultivaluedComplexAttributeOperation multiComplexOperation = new MultivaluedComplexAttributeOperation(attributePath, PatchOp.REMOVE);
                return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, multiComplexOperation);
            }
            if (attributeValue instanceof ArrayNode) {
                arrayNode = (ArrayNode)attributeValue;
            } else {
                arrayNode = new ScimArrayNode(multiComplexAttribute);
                arrayNode.add(attributeValue);
            }
            arrayNode = (ArrayNode)PatchRequestHandler.this.patchValidations.validateCurrentAttribute(multiComplexAttribute, new AbstractMap.SimpleEntry<String, ArrayNode>(multiComplexAttribute.getName(), arrayNode));
            PatchRequestHandler.this.addAttributeToRequestedAttributes(multiComplexAttribute);
            MultivaluedComplexAttributeOperation multiComplexOperation = new MultivaluedComplexAttributeOperation(attributePath, patchOp, (JsonNode)arrayNode);
            return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, multiComplexOperation);
        }

        private boolean handleSimpleMultivaluedAttribute(SchemaAttribute schemaAttribute, PatchOp patchOp, JsonNode attributeValue) {
            PatchRequestHandler.this.patchValidations.validateMutability(schemaAttribute);
            AttributePathRoot attributePath = new AttributePathRoot(schemaAttribute);
            if (attributeValue == null || attributeValue.isNull()) {
                return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new MultivaluedSimpleAttributeOperation(attributePath, PatchOp.REMOVE));
            }
            PatchRequestHandler.this.addAttributeToRequestedAttributes(schemaAttribute);
            return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new MultivaluedSimpleAttributeOperation(attributePath, patchOp, (ArrayNode)attributeValue));
        }

        private boolean handleComplexAttribute(SchemaAttribute complexAttribute, PatchOp patchOp, JsonNode jsonNode) {
            JsonNode attributeValue;
            block4: {
                block5: {
                    block6: {
                        attributeValue = jsonNode;
                        if (PatchOp.REMOVE.equals((Object)patchOp) || attributeValue == null || attributeValue.isNull()) {
                            PatchRequestHandler.this.patchValidations.validateMutability(complexAttribute);
                            AttributePathRoot attributePath = new AttributePathRoot(complexAttribute);
                            return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new RemoveComplexAttributeOperation(attributePath, PatchOp.REMOVE));
                        }
                        if (attributeValue.isObject()) break block4;
                        if (!attributeValue.isArray() || attributeValue.size() != 1) break block5;
                        if (!attributeValue.get(0).isObject()) break block6;
                        attributeValue = attributeValue.get(0);
                        break block4;
                    }
                    if (attributeValue.get(0).isTextual() && (attributeValue = JsonHelper.readJsonDocument((String)attributeValue.get(0).textValue())) != null && attributeValue.isObject()) break block4;
                }
                throw new BadRequestException(String.format("Value for attribute '%s' must be an object but was '%s'", complexAttribute.getFullResourceName(), attributeValue));
            }
            ObjectNode complexNode = (ObjectNode)attributeValue;
            AtomicReference<Boolean> wasChanged = new AtomicReference<Boolean>(false);
            Schema schema = complexAttribute.getSchema();
            complexNode.fields().forEachRemaining(complexField -> {
                try {
                    String attributeName = String.format("%s.%s", complexAttribute.getFullResourceName(), complexField.getKey());
                    SchemaAttribute subAttribute = schema.getSchemaAttribute(attributeName);
                    if (subAttribute == null) {
                        if (PatchRequestHandler.this.patchConfig.isIgnoreUnknownAttribute()) {
                            log.debug("Ignoring unknown attribute '{}'", (Object)attributeName);
                            throw new IgnoreSingleAttributeException();
                        }
                        throw new BadRequestException(String.format("Attribute '%s' is unknown to resource type '%s'", attributeName, PatchRequestHandler.this.resourceType.getName()), "invalidPath");
                    }
                    boolean wasValueChanged = this.handleSingleResourceField(subAttribute, patchOp, (Map.Entry<String, JsonNode>)complexField) || (Boolean)wasChanged.get() != false;
                    wasChanged.compareAndSet(false, wasValueChanged);
                }
                catch (IgnoreSingleAttributeException ex) {
                    log.debug("Ignoring attribute '{}' with value '{}'", complexField.getKey(), complexField.getValue());
                    log.trace(ex.getMessage(), (Throwable)ex);
                }
            });
            return wasChanged.get();
        }

        private boolean handleSimpleAttribute(SchemaAttribute schemaAttribute, PatchOp patchOp, JsonNode attributeValue) {
            PatchRequestHandler.this.patchValidations.validateMutability(schemaAttribute);
            AttributePathRoot attributePath = new AttributePathRoot(schemaAttribute);
            if (attributeValue == null || attributeValue.isNull()) {
                return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new SimpleAttributeOperation(attributePath, PatchOp.REMOVE));
            }
            PatchRequestHandler.this.addAttributeToRequestedAttributes(schemaAttribute);
            return PatchRequestHandler.this.patchOperationHandler.handleOperation(PatchRequestHandler.this.resourceId, new SimpleAttributeOperation(attributePath, patchOp, attributeValue));
        }
    }
}

