/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Comparator;
import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.IOException;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.filter.AttributeExpressionLeaf;
import de.captaingoldfish.scim.sdk.server.filter.AttributePathRoot;
import de.captaingoldfish.scim.sdk.server.filter.resources.PatchFilterResolver;
import de.captaingoldfish.scim.sdk.server.patch.AbstractPatch;
import de.captaingoldfish.scim.sdk.server.patch.PatchExtensionAttributePath;
import de.captaingoldfish.scim.sdk.server.patch.operations.PatchOperation;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import de.captaingoldfish.scim.sdk.server.utils.ScimAttributeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchTargetHandler
extends AbstractPatch
implements ScimAttributeHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PatchTargetHandler.class);
    private final PatchConfig patchConfig;
    private final AttributePathRoot path;
    private final PatchOp patchOp;
    private SchemaAttribute schemaAttribute;

    public PatchTargetHandler(PatchConfig patchConfig, ResourceType resourceType, PatchOperation patchOperation) {
        super(resourceType);
        this.patchConfig = patchConfig;
        this.path = patchOperation.getAttributePath();
        this.patchOp = patchOperation.getPatchOp();
        if (!(this.path instanceof PatchExtensionAttributePath)) {
            this.schemaAttribute = this.getSchemaAttribute();
        }
    }

    public boolean handleOperationValues(ResourceNode resource, List<String> values) {
        if (this.path instanceof PatchExtensionAttributePath) {
            return this.handleExtensionOperation(resource, values);
        }
        return this.handlePathAttributeOperation(resource, values);
    }

    private void evaluatePatchPathOperation(SchemaAttribute schemaAttribute, JsonNode attribute) {
        if (!PatchOp.REMOVE.equals((Object)this.patchOp) && Mutability.IMMUTABLE.equals((Object)schemaAttribute.getMutability()) && attribute != null) {
            String errorMessage = String.format("The attribute '%s' is 'IMMUTABLE' and is not unassigned. Current value is: %s", schemaAttribute.getScimNodeName(), attribute.asText());
            throw new BadRequestException(errorMessage, null, "mutability");
        }
    }

    private boolean handleExtensionOperation(ResourceNode resource, List<String> values) {
        boolean changeMade;
        boolean addOrReplaceValue = !PatchOp.REMOVE.equals((Object)this.patchOp);
        ObjectNode currentNode = (ObjectNode)resource.get(this.path.getFullName());
        if (addOrReplaceValue) {
            ObjectNode extensionNode = (ObjectNode)JsonHelper.readJsonDocument((String)values.get(0));
            boolean bl = changeMade = !extensionNode.equals((Object)currentNode);
            if (extensionNode.isEmpty()) {
                resource.remove(this.path.getFullName());
            } else {
                resource.set(this.path.getFullName(), (JsonNode)extensionNode);
            }
        } else {
            changeMade = currentNode != null && !currentNode.isEmpty();
            resource.remove(this.path.getFullName());
        }
        return changeMade;
    }

    private boolean handlePathAttributeOperation(ResourceNode resource, List<String> values) {
        JsonNode firstAttribute;
        String[] fullAttributeNames = this.getAttributeNames();
        String firstAttributeName = fullAttributeNames[0];
        SchemaAttribute schemaAttribute = this.getSchemaAttribute(firstAttributeName);
        boolean isExtension = this.resourceType.getSchemaExtensions().stream().anyMatch(ext -> ext.getSchema().equals(schemaAttribute.getResourceUri()));
        ResourceNode currentParent = resource;
        if (isExtension) {
            this.addExtensionToSchemas(resource, this.patchOp, schemaAttribute);
            currentParent = (ObjectNode)currentParent.get(schemaAttribute.getResourceUri());
            if (currentParent == null) {
                currentParent = new ScimObjectNode();
                resource.set(schemaAttribute.getResourceUri(), (JsonNode)currentParent);
            }
        }
        if ((firstAttribute = this.getAttributeFromObject((JsonNode)currentParent, firstAttributeName)) == null && !Type.COMPLEX.equals((Object)schemaAttribute.getType()) || firstAttribute != null && !firstAttribute.isArray() && !firstAttribute.isObject()) {
            boolean changeWasMade = this.handleSimpleNode(schemaAttribute, (ObjectNode)currentParent, values);
            this.removeExtensionIfEmpty(resource, schemaAttribute, isExtension, (ObjectNode)currentParent);
            return changeWasMade;
        }
        if (firstAttribute != null && firstAttribute.isArray()) {
            return this.handlePatchOperationOnMultiValued(resource, values, fullAttributeNames, schemaAttribute, isExtension, (ObjectNode)currentParent, firstAttribute);
        }
        if (schemaAttribute.isComplexAttribute()) {
            return this.handlePatchOperationOnComplex(resource, values, fullAttributeNames, schemaAttribute, isExtension, (ObjectNode)currentParent, firstAttribute);
        }
        return false;
    }

    private boolean handlePatchOperationOnComplex(ResourceNode resource, List<String> values, String[] fullAttributeNames, SchemaAttribute schemaAttribute, boolean isExtension, ObjectNode currentParent, JsonNode firstAttribute) {
        if (PatchOp.REMOVE.equals((Object)this.patchOp) && fullAttributeNames.length == 1 && this.path.getSubAttributeName() == null) {
            this.evaluatePatchPathOperation(schemaAttribute, firstAttribute);
            if (firstAttribute == null) {
                if (this.patchConfig.isDoNotFailOnNoTarget()) {
                    return false;
                }
                throw new BadRequestException(String.format("No target found for path-filter '%s'", schemaAttribute.getFullResourceName()), "noTarget");
            }
            currentParent.remove(schemaAttribute.getName());
            this.removeExtensionIfEmpty(resource, schemaAttribute, isExtension, currentParent);
            return true;
        }
        boolean changeMade = this.handleComplexAttribute(schemaAttribute, currentParent, fullAttributeNames, values);
        this.removeExtensionIfEmpty(resource, schemaAttribute, isExtension, currentParent);
        return changeMade;
    }

    private boolean handlePatchOperationOnMultiValued(ResourceNode resource, List<String> values, String[] fullAttributeNames, SchemaAttribute schemaAttribute, boolean isExtension, ObjectNode currentParent, JsonNode firstAttribute) {
        if (PatchOp.REMOVE.equals((Object)this.patchOp) && fullAttributeNames.length == 1 && this.path.getSubAttributeName() == null) {
            this.evaluatePatchPathOperation(schemaAttribute, firstAttribute.size() == 0 ? null : firstAttribute);
            int sizeBefore = currentParent.size();
            boolean effectiveChangeMade = false;
            if (this.path.getChild() == null) {
                JsonNode removedNode = currentParent.remove(schemaAttribute.getName());
                if (sizeBefore <= currentParent.size() || removedNode.size() == 0) {
                    if (this.patchConfig.isDoNotFailOnNoTarget()) {
                        return false;
                    }
                    throw new BadRequestException(String.format("No target found for path-filter '%s'", schemaAttribute.getFullResourceName()), "noTarget");
                }
                effectiveChangeMade = true;
                this.removeExtensionIfEmpty(resource, schemaAttribute, isExtension, currentParent);
                return effectiveChangeMade;
            }
            if (schemaAttribute.getParent() == null && !Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
                JsonNode jsonNode = currentParent.get(schemaAttribute.getName());
                if (jsonNode != null && jsonNode.isArray()) {
                    int i;
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
                    for (i = 0; i < arrayNode.size(); ++i) {
                        PatchFilterResolver patchFilterResolver = new PatchFilterResolver();
                        JsonNode simpleNode = arrayNode.get(i);
                        boolean doesEntryMatch = patchFilterResolver.isSimpleNodeMatchingFilter(simpleNode, this.path.getChild());
                        if (!doesEntryMatch) continue;
                        indexesToRemove.add(i);
                    }
                    for (i = indexesToRemove.size() - 1; i >= 0; --i) {
                        arrayNode.remove(((Integer)indexesToRemove.get(i)).intValue());
                        effectiveChangeMade = true;
                    }
                    if (arrayNode.isEmpty()) {
                        currentParent.remove(schemaAttribute.getName());
                    }
                }
                if (!effectiveChangeMade && !this.patchConfig.isDoNotFailOnNoTarget()) {
                    throw new BadRequestException(String.format("No target found for path-filter '%s'", this.path), "noTarget");
                }
                return effectiveChangeMade;
            }
        }
        boolean changeWasMade = this.handleMultiValuedAttribute(schemaAttribute, (ArrayNode)firstAttribute, fullAttributeNames, values);
        if (firstAttribute.size() == 0) {
            resource.remove(schemaAttribute.getName());
            this.removeExtensionIfEmpty(resource, schemaAttribute, isExtension, currentParent);
        }
        return changeWasMade;
    }

    private void removeExtensionIfEmpty(ResourceNode resource, SchemaAttribute schemaAttribute, boolean isExtension, ObjectNode currentParent) {
        if (isExtension && currentParent.size() == 0) {
            resource.remove(schemaAttribute.getResourceUri());
            resource.removeSchema(schemaAttribute.getResourceUri());
        }
    }

    private void addExtensionToSchemas(ResourceNode resource, PatchOp patchOp, SchemaAttribute schemaAttribute) {
        if (patchOp.equals((Object)PatchOp.REMOVE)) {
            return;
        }
        resource.addSchema(schemaAttribute.getResourceUri());
    }

    protected boolean handleSimpleNode(SchemaAttribute schemaAttribute, ObjectNode objectNode, List<String> values) {
        JsonNode oldNode = objectNode.get(schemaAttribute.getName());
        if (!PatchOp.REMOVE.equals((Object)this.patchOp) && values.get(0).equals(Optional.ofNullable(oldNode).map(JsonNode::textValue).orElse(null))) {
            return false;
        }
        this.evaluatePatchPathOperation(schemaAttribute, oldNode);
        if (PatchOp.REMOVE.equals((Object)this.patchOp)) {
            boolean isSimpleNodeInMultivaluedComplex;
            boolean isSimpleNode = schemaAttribute.getParent() == null;
            boolean bl = isSimpleNodeInMultivaluedComplex = schemaAttribute.getParent() != null && schemaAttribute.getParent().isMultiValued();
            if (oldNode == null && isSimpleNode || oldNode == null && !isSimpleNodeInMultivaluedComplex) {
                if (this.patchConfig.isDoNotFailOnNoTarget()) {
                    return false;
                }
                throw new BadRequestException(String.format("No target found for path-filter '%s'", schemaAttribute.getFullResourceName()), "noTarget");
            }
            objectNode.remove(schemaAttribute.getName());
            return true;
        }
        JsonNode newNode = this.parseToJsonNode(schemaAttribute, values.get(0));
        if (!newNode.equals((Object)oldNode)) {
            objectNode.set(schemaAttribute.getName(), newNode);
            return true;
        }
        return false;
    }

    private boolean handleComplexAttribute(SchemaAttribute schemaAttribute, ObjectNode resource, String[] fullAttributeNames, List<String> values) {
        if (fullAttributeNames.length > 1) {
            ObjectNode complexNode = (ObjectNode)resource.get(schemaAttribute.getName());
            this.evaluatePatchPathOperation(schemaAttribute, (JsonNode)complexNode);
            return this.handleComplexSubAttributePathReference(schemaAttribute, resource, fullAttributeNames[1], values);
        }
        return this.handleDirectComplexPathReference(schemaAttribute, resource, values);
    }

    private boolean handleDirectComplexPathReference(SchemaAttribute schemaAttribute, ObjectNode resource, List<String> values) {
        boolean hasFilterExpression;
        ObjectNode complexNode = (ObjectNode)resource.get(schemaAttribute.getName());
        this.evaluatePatchPathOperation(schemaAttribute, (JsonNode)complexNode);
        JsonNode newNode = JsonHelper.readJsonDocument((String)values.get(0));
        PatchFilterResolver filterResolver = new PatchFilterResolver();
        boolean bl = hasFilterExpression = this.path.getChild() != null;
        if (complexNode != null && hasFilterExpression && !filterResolver.isNodeMatchingFilter(complexNode, this.path, this.patchOp).isPresent()) {
            if (this.patchConfig.isDoNotFailOnNoTarget()) {
                return false;
            }
            throw new BadRequestException(String.format("No target found for path-filter '%s'", this.path), "noTarget");
        }
        boolean changeWasMade = false;
        if (PatchOp.ADD.equals((Object)this.patchOp)) {
            JsonNode oldNode = resource.get(schemaAttribute.getName());
            newNode = this.mergeObjectNodes((ObjectNode)newNode, oldNode);
            resource.set(schemaAttribute.getName(), newNode);
            changeWasMade = !newNode.equals((Object)oldNode);
        } else if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
            resource.set(schemaAttribute.getName(), newNode);
            changeWasMade = true;
        }
        return changeWasMade;
    }

    private boolean handleComplexSubAttributePathReference(SchemaAttribute schemaAttribute, ObjectNode resource, String fullAttributeName, List<String> values) {
        Optional<ObjectNode> matchingNode;
        SchemaAttribute subAttribute = this.getSchemaAttribute(fullAttributeName);
        ObjectNode complexNode = (ObjectNode)resource.get(schemaAttribute.getName());
        if (complexNode == null) {
            complexNode = new ScimObjectNode(schemaAttribute);
            resource.set(schemaAttribute.getName(), (JsonNode)complexNode);
        }
        if (!(matchingNode = new PatchFilterResolver().isNodeMatchingFilter(complexNode, this.path, this.patchOp)).isPresent()) {
            if (this.patchConfig.isDoNotFailOnNoTarget()) {
                return false;
            }
            throw new BadRequestException(String.format("No target found for path-filter '%s'", this.path), "noTarget");
        }
        if (this.handleInnerComplexAttribute(subAttribute, complexNode, values)) {
            if (complexNode.size() == 0) {
                resource.remove(schemaAttribute.getName());
            }
            return true;
        }
        if (complexNode.size() == 0) {
            resource.remove(schemaAttribute.getName());
            return false;
        }
        return false;
    }

    private boolean handleInnerComplexAttribute(SchemaAttribute subAttribute, ObjectNode complexNode, List<String> values) {
        if (subAttribute.isMultiValued()) {
            ScimArrayNode arrayNode;
            JsonNode jsonNode = complexNode.get(subAttribute.getName());
            if (jsonNode == null || jsonNode.isNull() || !jsonNode.isArray()) {
                arrayNode = new ScimArrayNode(subAttribute);
                complexNode.set(subAttribute.getName(), (JsonNode)arrayNode);
                if (jsonNode != null && !jsonNode.isNull()) {
                    arrayNode.add(jsonNode);
                }
            } else {
                arrayNode = (ArrayNode)jsonNode;
            }
            if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
                arrayNode.removeAll();
            }
            if (PatchOp.REMOVE.equals((Object)this.patchOp)) {
                boolean effectiveChange = complexNode.get(subAttribute.getName()).size() != 0;
                complexNode.remove(subAttribute.getName());
                boolean isParentMultivalued = subAttribute.getParent().isMultiValued();
                if (!effectiveChange && !isParentMultivalued) {
                    if (this.patchConfig.isDoNotFailOnNoTarget()) {
                        return false;
                    }
                    throw new BadRequestException(String.format("No target found for path-filter '%s'", this.path), "noTarget");
                }
                return effectiveChange || !isParentMultivalued;
            }
            for (String value : values) {
                JsonNode jsonValue = this.parseToJsonNode(subAttribute, value);
                arrayNode.add(jsonValue);
            }
            return true;
        }
        return this.handleSimpleNode(subAttribute, complexNode, values);
    }

    private JsonNode mergeObjectNodes(ObjectNode newNode, JsonNode oldNode) {
        if (oldNode == null) {
            return newNode;
        }
        oldNode.fields().forEachRemaining(stringJsonNodeEntry -> {
            String key = (String)stringJsonNodeEntry.getKey();
            JsonNode value = (JsonNode)stringJsonNodeEntry.getValue();
            JsonNode newSubNode = newNode.get(key);
            if (newSubNode == null) {
                newNode.set(key, value);
            } else if (newSubNode.isArray()) {
                newSubNode.forEach(arg_0 -> ((ArrayNode)((ArrayNode)value)).add(arg_0));
                newNode.set(key, value);
            }
        });
        return newNode;
    }

    private boolean handleMultiValuedAttribute(SchemaAttribute schemaAttribute, ArrayNode multiValued, String[] fullAttributeNames, List<String> values) {
        if (Type.COMPLEX.equals((Object)schemaAttribute.getType())) {
            if (fullAttributeNames.length > 1) {
                return this.handleMultiComplexSubAttributePath(multiValued, fullAttributeNames[1], values);
            }
            this.evaluatePatchPathOperation(schemaAttribute, (JsonNode)(multiValued.size() == 0 ? null : multiValued));
            return this.handleDirectMultiValuedComplexPathReference(multiValued, values);
        }
        if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
            multiValued.removeAll();
        }
        for (String value : values) {
            multiValued.add(this.parseToJsonNode(schemaAttribute, value));
        }
        return true;
    }

    private boolean handleDirectMultiValuedComplexPathReference(ArrayNode multiValued, List<String> values) {
        List<IndexNode> matchingComplexNodes = this.resolveFilter(multiValued, this.path);
        if (PatchOp.REMOVE.equals((Object)this.patchOp)) {
            boolean changeWasMade = false;
            for (int i = matchingComplexNodes.size() - 1; i >= 0; --i) {
                multiValued.remove(matchingComplexNodes.get(i).getIndex());
                changeWasMade = true;
            }
            return changeWasMade;
        }
        if (matchingComplexNodes.isEmpty() && this.path.getChild() != null) {
            if (this.patchConfig.isDoNotFailOnNoTarget()) {
                return false;
            }
            throw new BadRequestException(String.format("Cannot '%s' value on path '%s' for no matching object was found", this.patchOp, this.path), null, "noTarget");
        }
        List valueNodes = values.stream().map(val -> {
            try {
                return JsonHelper.readJsonDocument((String)val, ObjectNode.class);
            }
            catch (IOException ex) {
                throw new BadRequestException("The value must be a whole complex type json structure but was: '" + val + "'", (Throwable)ex, "invalidValue");
            }
        }).collect(Collectors.toList());
        ArrayList<ObjectNode> originalNodes = new ArrayList<ObjectNode>();
        if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
            for (int i = matchingComplexNodes.size() - 1; i >= 0; --i) {
                IndexNode indexNode = matchingComplexNodes.get(i);
                if (this.path.isWithFilter()) {
                    indexNode.createCopy();
                }
                originalNodes.add((ObjectNode)multiValued.get(indexNode.getIndex()));
                multiValued.remove(indexNode.getIndex());
            }
        }
        boolean isResourceChanged = false;
        for (ObjectNode complexNode : valueNodes) {
            JsonNode primary = complexNode.get("primary");
            this.checkForPrimary(multiValued, primary != null && primary.booleanValue());
            if (this.path.isWithFilter() && !matchingComplexNodes.isEmpty()) {
                for (IndexNode matchingComplexIndexNode : matchingComplexNodes) {
                    ObjectNode matchingNode = matchingComplexIndexNode.getObjectNode();
                    ObjectNode originalNode = JsonHelper.readJsonDocument((String)matchingNode.toString(), ObjectNode.class);
                    complexNode.fields().forEachRemaining(entry -> {
                        if (PatchOp.REPLACE.equals((Object)this.patchOp)) {
                            matchingNode.set((String)entry.getKey(), (JsonNode)entry.getValue());
                        } else {
                            JsonNode originalValue = matchingNode.get((String)entry.getKey());
                            if (originalValue == null || originalValue.isNull() || !originalValue.isArray()) {
                                matchingNode.set((String)entry.getKey(), (JsonNode)entry.getValue());
                            } else {
                                ArrayNode originalArray = (ArrayNode)originalValue;
                                ArrayNode newValue = (ArrayNode)entry.getValue();
                                originalArray.addAll(newValue);
                            }
                        }
                    });
                    isResourceChanged = isResourceChanged || !originalNode.equals((Object)matchingNode);
                }
                if (!PatchOp.REPLACE.equals((Object)this.patchOp)) continue;
                for (IndexNode matchingComplexNode : matchingComplexNodes) {
                    isResourceChanged = isResourceChanged || matchingComplexNode.isResultUnchanged();
                    multiValued.add((JsonNode)matchingComplexNode.getObjectNode());
                }
                continue;
            }
            if (this.path.isWithFilter() && !matchingComplexNodes.isEmpty()) continue;
            multiValued.add((JsonNode)complexNode);
            isResourceChanged = isResourceChanged || !JsonHelper.containsEqualObject(originalNodes, (JsonNode)complexNode);
        }
        return isResourceChanged;
    }

    private void checkForPrimary(ArrayNode multiValued, boolean primary) {
        if (!primary) {
            return;
        }
        multiValued.forEach(jsonNode -> ((ObjectNode)jsonNode).remove("primary"));
    }

    private boolean handleMultiComplexSubAttributePath(ArrayNode multiValued, String fullAttributeName, List<String> values) {
        SchemaAttribute subAttribute = RequestUtils.getSchemaAttributeByAttributeName(this.resourceType, fullAttributeName);
        List<IndexNode> matchingComplexNodes = this.resolveFilter(multiValued, this.path);
        AtomicBoolean changeWasMade = new AtomicBoolean(false);
        if ("primary".equals(subAttribute.getName())) {
            this.checkForPrimary(multiValued, Boolean.parseBoolean(values.get(0)));
        }
        if (this.path.getChild() != null && matchingComplexNodes.isEmpty()) {
            if (this.patchConfig.isMsAzureFilterWorkaroundActive() && !PatchOp.REMOVE.equals((Object)this.patchOp) && this.path.getChild() instanceof AttributeExpressionLeaf) {
                ScimObjectNode value = new ScimObjectNode();
                value.set(subAttribute.getName(), (JsonNode)new ScimTextNode(null, values.get(0)));
                AttributeExpressionLeaf attributeExpressionLeaf = (AttributeExpressionLeaf)this.path.getChild();
                if (attributeExpressionLeaf.getComparator() == Comparator.EQ) {
                    value.set(attributeExpressionLeaf.getSchemaAttribute().getName(), (JsonNode)new ScimTextNode(null, attributeExpressionLeaf.getValue()));
                    multiValued.add((JsonNode)value);
                    return true;
                }
            }
            if (this.patchConfig.isDoNotFailOnNoTarget()) {
                return false;
            }
            throw new BadRequestException(String.format("No target found for path-filter '%s'", this.path), "noTarget");
        }
        if (this.path.getChild() == null && matchingComplexNodes.isEmpty() && PatchOp.REMOVE.equals((Object)this.patchOp)) {
            return false;
        }
        for (int i = matchingComplexNodes.size() - 1; i >= 0; --i) {
            ObjectNode complexNode = matchingComplexNodes.get(i).getObjectNode();
            changeWasMade.weakCompareAndSet(false, this.handleInnerComplexAttribute(subAttribute, complexNode, values));
            if (complexNode.size() != 0) continue;
            multiValued.remove(matchingComplexNodes.get(i).getIndex());
        }
        return changeWasMade.get();
    }

    private List<IndexNode> resolveFilter(ArrayNode multiValuedComplex, AttributePathRoot path) {
        PatchFilterResolver patchFilterResolver = new PatchFilterResolver();
        ArrayList<IndexNode> matchingComplexNodes = new ArrayList<IndexNode>();
        for (int i = 0; i < multiValuedComplex.size(); ++i) {
            JsonNode complex = multiValuedComplex.get(i);
            Optional<ObjectNode> filteredNode = patchFilterResolver.isNodeMatchingFilter((ObjectNode)complex, path, this.patchOp);
            if (!filteredNode.isPresent()) continue;
            matchingComplexNodes.add(new IndexNode(i, filteredNode.get()));
        }
        if (path.getChild() != null && matchingComplexNodes.size() == 0) {
            return new ArrayList<IndexNode>();
        }
        return matchingComplexNodes;
    }

    private String[] getAttributeNames() {
        String attributeName = this.path.getShortName() + (StringUtils.isBlank((CharSequence)this.path.getSubAttributeName()) ? "" : "." + this.path.getSubAttributeName());
        String[] attributeNames = attributeName.split("\\.");
        String resourceUri = this.path.getResourceUri() == null ? "" : this.path.getResourceUri() + ":";
        attributeNames[0] = resourceUri + attributeNames[0];
        for (int i = 1; i < attributeNames.length; ++i) {
            attributeNames[i] = attributeNames[i - 1] + "." + attributeNames[i];
        }
        return attributeNames;
    }

    private SchemaAttribute getSchemaAttribute() {
        if (this.schemaAttribute == null) {
            this.schemaAttribute = this.getSchemaAttribute(this.path.getFullName());
        }
        return this.schemaAttribute;
    }

    @Generated
    protected AttributePathRoot getPath() {
        return this.path;
    }

    private static class IndexNode {
        private int index;
        private ObjectNode objectNode;
        private ObjectNode copyNode;

        public IndexNode(int index, ObjectNode objectNode) {
            this.index = index;
            this.objectNode = objectNode;
        }

        public void createCopy() {
            this.copyNode = JsonHelper.readJsonDocument((String)this.objectNode.toString(), ObjectNode.class);
        }

        public boolean isResultUnchanged() {
            return this.objectNode.equals((Object)this.copyNode);
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public ObjectNode getObjectNode() {
            return this.objectNode;
        }

        @Generated
        public ObjectNode getCopyNode() {
            return this.copyNode;
        }
    }
}

