/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.patch.workarounds.msazure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.request.PatchRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.patch.workarounds.PatchWorkaround;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MsAzurePatchRemoveRebuilder
extends PatchWorkaround {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MsAzurePatchRemoveRebuilder.class);

    @Override
    public boolean shouldBeHandled(PatchConfig patchConfig, ResourceType resourceType, PatchRequestOperation operation) {
        return PatchOp.REMOVE.equals((Object)operation.getOp()) && operation.getPath().isPresent() && !operation.getValues().isEmpty();
    }

    @Override
    public boolean executeOtherHandlers() {
        return true;
    }

    @Override
    public PatchRequestOperation fixPatchRequestOperaton(ResourceType resourceType, PatchRequestOperation operation) {
        String path = (String)operation.getPath().get();
        List values = operation.getValues();
        StringBuilder newPath = new StringBuilder(path).append('[');
        for (int i = 0; i < values.size(); ++i) {
            String value;
            if (i > 0) {
                newPath.append(" or ");
            }
            if (!JsonHelper.isValidJson((String)(value = (String)values.get(i)))) {
                log.trace("[MS Azure workaround] attribute in 'value' operand is not valid json: {}", (Object)value);
                return operation;
            }
            JsonNode jsonNode = JsonHelper.readJsonDocument((String)value);
            boolean isNodeAnObject = Optional.ofNullable(jsonNode).map(JsonNode::isObject).orElse(false);
            if (!isNodeAnObject) {
                log.trace("[MS Azure workaround] attribute in 'value' operand is not an object: {}", (Object)value);
                return operation;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.size() != 1) {
                log.trace("[MS Azure workaround] workaround not executed for 'value' operand object has more than one attributes: {}", (Object)objectNode.toPrettyString());
                return operation;
            }
            String fieldName = (String)objectNode.fieldNames().next();
            JsonNode valueNode = objectNode.get(fieldName);
            if (valueNode.isObject() || valueNode.isArray()) {
                log.trace("[MS Azure workaround] workaround not executed for attribute in value 'operand' is not a simple type: {}", (Object)valueNode.toPrettyString());
                return operation;
            }
            newPath.append(fieldName).append(" eq \"").append(valueNode.textValue()).append("\"");
        }
        values.clear();
        return PatchRequestOperation.builder().op(operation.getOp()).path(newPath.append(']').toString()).build();
    }

    @Generated
    public MsAzurePatchRemoveRebuilder() {
    }
}

