/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.exceptions.DocumentValidationException;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidSchemaException;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import de.captaingoldfish.scim.sdk.server.schemas.validation.MetaSchemaValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public final class SchemaFactory {
    private final Map<String, Schema> metaSchemas = new HashMap<String, Schema>();
    private final Map<String, Schema> resourceSchemas = new HashMap<String, Schema>();
    private ResourceTypeFactory resourceTypeFactory;

    protected SchemaFactory(ResourceTypeFactory resourceTypeFactory) {
        this.resourceTypeFactory = resourceTypeFactory;
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/meta/schema.schema.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/meta/resource-type-feature-ext.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/meta/resource-type.schema.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/meta/service-provider.schema.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/meta/meta.schema.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/request/bulk-request.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/response/bulk-response.json"));
        this.registerMetaSchema(JsonHelper.loadJsonDocument((String)"/de/captaingoldfish/scim/sdk/common/request/patch-request.json"));
    }

    protected void registerMetaSchema(JsonNode jsonSchema) {
        Schema schema = new Schema(jsonSchema);
        this.metaSchemas.put(schema.getNonNullId(), schema);
    }

    public Schema registerResourceSchema(JsonNode jsonSchema) {
        Schema metaSchema = this.getMetaSchema("urn:ietf:params:scim:schemas:core:2.0:Schema");
        try {
            MetaSchemaValidator.getInstance().validateDocument(metaSchema, jsonSchema);
            Schema schema = new Schema(jsonSchema);
            if (this.metaSchemas.get(schema.getNonNullId()) == null) {
                this.resourceSchemas.put(schema.getNonNullId(), schema);
            } else {
                this.metaSchemas.put(schema.getNonNullId(), schema);
            }
            return schema;
        }
        catch (DocumentValidationException ex) {
            throw new InvalidSchemaException(ex.getMessage(), (Throwable)ex, null, null);
        }
    }

    public Schema getMetaSchema(String id) {
        return this.metaSchemas.get(id);
    }

    public Schema getResourceSchema(String id) {
        Schema schema = this.resourceSchemas.get(id);
        if (schema != null) {
            return schema;
        }
        return this.metaSchemas.get(id);
    }

    public Set<Schema> getAllResourceSchemas() {
        return new HashSet<Schema>(this.resourceSchemas.values());
    }

    @Generated
    protected Map<String, Schema> getMetaSchemas() {
        return this.metaSchemas;
    }

    @Generated
    protected Map<String, Schema> getResourceSchemas() {
        return this.resourceSchemas;
    }

    @Generated
    protected ResourceTypeFactory getResourceTypeFactory() {
        return this.resourceTypeFactory;
    }
}

