/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.custom;

import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.server.schemas.custom.ETagFeature;
import de.captaingoldfish.scim.sdk.server.schemas.custom.EndpointControlFeature;
import de.captaingoldfish.scim.sdk.server.schemas.custom.ResourceTypeAuthorization;
import java.util.Optional;
import lombok.Generated;

public class ResourceTypeFeatures
extends ScimObjectNode {
    public ResourceTypeFeatures(boolean autoFiltering, boolean autoSorting, boolean singletonEndpoint, EndpointControlFeature endpointControlFeature, ResourceTypeAuthorization authorization, ETagFeature eTagFeature, boolean returnResourcesOnBulk) {
        super(null);
        this.setAutoFiltering(autoFiltering);
        this.setAutoSorting(autoSorting);
        this.setSingletonEndpoint(singletonEndpoint);
        this.setEndpointControlFeature(endpointControlFeature);
        this.setAuthorization(authorization);
        this.setETagFeature(eTagFeature);
        this.setDenyReturnResourcesOnBulk(returnResourcesOnBulk);
    }

    public ETagFeature getETagFeature() {
        Optional optionalETagFeature = this.getObjectAttribute("etag", ETagFeature.class);
        if (optionalETagFeature.isPresent()) {
            return (ETagFeature)((Object)optionalETagFeature.get());
        }
        ETagFeature eTagFeature = ETagFeature.builder().build();
        this.setETagFeature(eTagFeature);
        return eTagFeature;
    }

    public void setETagFeature(ETagFeature eTagFeature) {
        this.setAttribute("etag", (ObjectNode)eTagFeature);
    }

    public boolean isSingletonEndpoint() {
        return this.getBooleanAttribute("singletonEndpoint").orElse(false);
    }

    public void setSingletonEndpoint(Boolean singletonEndpoint) {
        this.setAttribute("singletonEndpoint", singletonEndpoint);
    }

    public boolean isAutoFiltering() {
        return this.getBooleanAttribute("autoFiltering").orElse(false);
    }

    public void setAutoFiltering(Boolean autoFiltering) {
        this.setAttribute("autoFiltering", autoFiltering);
    }

    public boolean isAutoSorting() {
        return this.getBooleanAttribute("autoSorting").orElse(false);
    }

    public void setAutoSorting(Boolean autoSorting) {
        this.setAttribute("autoSorting", autoSorting);
    }

    public boolean isResourceTypeDisabled() {
        return this.getBooleanAttribute("disabled").orElse(false) != false || this.getEndpointControlFeature().isResourceTypeDisabled();
    }

    public void setResourceTypeDisabled(Boolean disabled) {
        this.setAttribute("disabled", disabled);
    }

    public EndpointControlFeature getEndpointControlFeature() {
        Optional endpointControl = this.getObjectAttribute("endpointControl", EndpointControlFeature.class);
        if (endpointControl.isPresent()) {
            return (EndpointControlFeature)((Object)endpointControl.get());
        }
        EndpointControlFeature endpointControlFeature = EndpointControlFeature.builder().build();
        this.setEndpointControlFeature(endpointControlFeature);
        return endpointControlFeature;
    }

    public void setEndpointControlFeature(EndpointControlFeature endpointControlFeature) {
        this.setAttribute("endpointControl", (ObjectNode)endpointControlFeature);
    }

    public ResourceTypeAuthorization getAuthorization() {
        Optional authorization = this.getObjectAttribute("authorization", ResourceTypeAuthorization.class);
        if (authorization.isPresent()) {
            return (ResourceTypeAuthorization)((Object)authorization.get());
        }
        ResourceTypeAuthorization resourceTypeAuthorization = ResourceTypeAuthorization.builder().build();
        this.setAuthorization(resourceTypeAuthorization);
        return resourceTypeAuthorization;
    }

    public void setAuthorization(ResourceTypeAuthorization resourceTypeAuthorization) {
        this.setAttribute("authorization", (ObjectNode)resourceTypeAuthorization);
    }

    public boolean isDenyReturnResourcesOnBulk() {
        return this.getBooleanAttribute("denyReturnResourcesOnBulk").orElse(false);
    }

    public void setDenyReturnResourcesOnBulk(boolean returnResourcesOnBulk) {
        this.setAttribute("denyReturnResourcesOnBulk", returnResourcesOnBulk);
    }

    @Generated
    public static ResourceTypeFeaturesBuilder builder() {
        return new ResourceTypeFeaturesBuilder();
    }

    @Generated
    public ResourceTypeFeatures() {
    }

    @Generated
    public static class ResourceTypeFeaturesBuilder {
        @Generated
        private boolean autoFiltering;
        @Generated
        private boolean autoSorting;
        @Generated
        private boolean singletonEndpoint;
        @Generated
        private EndpointControlFeature endpointControlFeature;
        @Generated
        private ResourceTypeAuthorization authorization;
        @Generated
        private ETagFeature eTagFeature;
        @Generated
        private boolean returnResourcesOnBulk;

        @Generated
        ResourceTypeFeaturesBuilder() {
        }

        @Generated
        public ResourceTypeFeaturesBuilder autoFiltering(boolean autoFiltering) {
            this.autoFiltering = autoFiltering;
            return this;
        }

        @Generated
        public ResourceTypeFeaturesBuilder autoSorting(boolean autoSorting) {
            this.autoSorting = autoSorting;
            return this;
        }

        @Generated
        public ResourceTypeFeaturesBuilder singletonEndpoint(boolean singletonEndpoint) {
            this.singletonEndpoint = singletonEndpoint;
            return this;
        }

        @Generated
        public ResourceTypeFeaturesBuilder endpointControlFeature(EndpointControlFeature endpointControlFeature) {
            this.endpointControlFeature = endpointControlFeature;
            return this;
        }

        @Generated
        public ResourceTypeFeaturesBuilder authorization(ResourceTypeAuthorization authorization) {
            this.authorization = authorization;
            return this;
        }

        @Generated
        public ResourceTypeFeaturesBuilder eTagFeature(ETagFeature eTagFeature) {
            this.eTagFeature = eTagFeature;
            return this;
        }

        @Generated
        public ResourceTypeFeaturesBuilder returnResourcesOnBulk(boolean returnResourcesOnBulk) {
            this.returnResourcesOnBulk = returnResourcesOnBulk;
            return this;
        }

        @Generated
        public ResourceTypeFeatures build() {
            return new ResourceTypeFeatures(this.autoFiltering, this.autoSorting, this.singletonEndpoint, this.endpointControlFeature, this.authorization, this.eTagFeature, this.returnResourcesOnBulk);
        }

        @Generated
        public String toString() {
            return "ResourceTypeFeatures.ResourceTypeFeaturesBuilder(autoFiltering=" + this.autoFiltering + ", autoSorting=" + this.autoSorting + ", singletonEndpoint=" + this.singletonEndpoint + ", endpointControlFeature=" + (Object)((Object)this.endpointControlFeature) + ", authorization=" + (Object)((Object)this.authorization) + ", eTagFeature=" + (Object)((Object)this.eTagFeature) + ", returnResourcesOnBulk=" + this.returnResourcesOnBulk + ")";
        }
    }
}

