/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ContextValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ValidationSelector;
import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexAttributeValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplexAttributeValidator.class);

    static JsonNode parseNodeTypeAndValidate(SchemaAttribute schemaAttribute, JsonNode attribute, ContextValidator contextValidator) {
        log.trace("Validating complex attribute '{}'", (Object)schemaAttribute.getScimNodeName());
        ObjectNode effectiveAttribute = ComplexAttributeValidator.getEffectiveAttributeNode(schemaAttribute, attribute);
        ScimObjectNode scimObjectNode = new ScimObjectNode(schemaAttribute);
        ArrayList<AttributeValidationException> errorValidations = new ArrayList<AttributeValidationException>();
        boolean allNodesAreNullNodes = true;
        for (SchemaAttribute subAttribute : schemaAttribute.getSubAttributes()) {
            Optional<JsonNode> validatedNode;
            JsonNode subNode = effectiveAttribute.get(subAttribute.getName());
            if (subNode != null && !NullNode.getInstance().equals((Object)subNode)) {
                allNodesAreNullNodes = false;
            } else {
                effectiveAttribute.remove(subAttribute.getName());
            }
            try {
                validatedNode = ValidationSelector.validateNode(subAttribute, subNode, contextValidator);
            }
            catch (AttributeValidationException ex) {
                errorValidations.add(ex);
                continue;
            }
            if (!validatedNode.isPresent()) continue;
            scimObjectNode.set(subAttribute.getName(), validatedNode.get());
        }
        if (scimObjectNode.isEmpty()) {
            log.trace("Evaluated complex node '{}' to an empty object.", (Object)schemaAttribute.getFullResourceName());
        }
        if (allNodesAreNullNodes && !effectiveAttribute.isEmpty()) {
            allNodesAreNullNodes = false;
        }
        if (!errorValidations.isEmpty() && !allNodesAreNullNodes) {
            throw (AttributeValidationException)errorValidations.get(0);
        }
        return scimObjectNode.isEmpty() ? null : scimObjectNode;
    }

    private static ObjectNode getEffectiveAttributeNode(SchemaAttribute schemaAttribute, JsonNode originalAttribute) {
        JsonNode attribute = originalAttribute;
        if (attribute.isObject()) {
            return (ObjectNode)attribute;
        }
        if (attribute.isArray() && attribute.size() == 1) {
            if (attribute.get(0).isObject()) {
                return (ObjectNode)attribute.get(0);
            }
            if (attribute.get(0) instanceof TextNode && (attribute = JsonHelper.readJsonDocument((String)attribute.get(0).textValue())).isObject()) {
                return (ObjectNode)attribute;
            }
        }
        String errorMessage = String.format("Attribute '%s' must be of type object but is '%s'", schemaAttribute.getFullResourceName(), attribute);
        throw new AttributeValidationException(schemaAttribute, errorMessage);
    }
}

