/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.TimeUtils;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class CustomAttributeValidator {
    public static void validateSimpleNode(SchemaAttribute schemaAttribute, JsonNode attribute) {
        if (schemaAttribute == null || attribute == null) {
            return;
        }
        if (attribute.isTextual()) {
            CustomAttributeValidator.validateTextNode(schemaAttribute, (TextNode)attribute);
        } else if (attribute.isDouble()) {
            CustomAttributeValidator.validateNumberNode(schemaAttribute, (DoubleNode)attribute);
        } else if (attribute.isLong()) {
            CustomAttributeValidator.validateNumberNode(schemaAttribute, (LongNode)attribute);
        } else if (attribute.isNumber()) {
            CustomAttributeValidator.validateNumberNode(schemaAttribute, (IntNode)attribute);
        }
    }

    protected static void validateTextNode(SchemaAttribute schemaAttribute, TextNode valueNode) {
        if (Type.STRING.equals((Object)schemaAttribute.getType()) || Type.REFERENCE.equals((Object)schemaAttribute.getType())) {
            CustomAttributeValidator.validateStringTypes(schemaAttribute, valueNode);
        } else if (Type.DATE_TIME.equals((Object)schemaAttribute.getType())) {
            CustomAttributeValidator.validateDateTimeTypes(schemaAttribute, valueNode);
        }
    }

    private static void validateDateTimeTypes(SchemaAttribute schemaAttribute, TextNode valueNode) {
        String value = valueNode.textValue();
        schemaAttribute.getNotBefore().ifPresent(notBefore -> {
            Instant val = TimeUtils.parseDateTime((String)value);
            if (val.isBefore((Instant)notBefore)) {
                String errorMessage = String.format("The '%s'-attribute '%s' with value '%s' must not be before '%s'", schemaAttribute.getType(), schemaAttribute.getScimNodeName(), val, notBefore);
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
        schemaAttribute.getNotAfter().ifPresent(notAfter -> {
            Instant val = TimeUtils.parseDateTime((String)value);
            if (val.isAfter((Instant)notAfter)) {
                String errorMessage = String.format("The '%s'-attribute '%s' with value '%s' must not be after '%s'", schemaAttribute.getType(), schemaAttribute.getScimNodeName(), val, notAfter);
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
    }

    private static void validateStringTypes(SchemaAttribute schemaAttribute, TextNode valueNode) {
        String value = valueNode.textValue();
        schemaAttribute.getMinLength().ifPresent(minLength -> {
            if (minLength > (long)StringUtils.length((CharSequence)value)) {
                String errorMessage = String.format("The '%s'-attribute '%s' with value '%s' must have a minimum length of '%s' characters but is '%s' characters long", schemaAttribute.getType(), schemaAttribute.getScimNodeName(), value, minLength, value.length());
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
        schemaAttribute.getMaxLength().ifPresent(maxLength -> {
            if (maxLength < (long)StringUtils.length((CharSequence)value)) {
                String errorMessage = String.format("The '%s'-attribute '%s' with value '%s' must not be longer than '%s' characters but is '%s' characters long", schemaAttribute.getType(), schemaAttribute.getScimNodeName(), value, maxLength, value.length());
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
        schemaAttribute.getPattern().ifPresent(pattern -> {
            if (!pattern.matcher(value).matches()) {
                String errorMessage = String.format("The '%s'-attribute '%s' with value '%s' must match the regular expression of '%s'", schemaAttribute.getType(), schemaAttribute.getScimNodeName(), value, pattern);
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
    }

    protected static void validateNumberNode(SchemaAttribute schemaAttribute, IntNode valueNode) {
        CustomAttributeValidator.validateNumberNode(schemaAttribute, new DoubleNode(valueNode.doubleValue()));
    }

    protected static void validateNumberNode(SchemaAttribute schemaAttribute, LongNode valueNode) {
        CustomAttributeValidator.validateNumberNode(schemaAttribute, new DoubleNode(valueNode.doubleValue()));
    }

    protected static void validateNumberNode(SchemaAttribute schemaAttribute, DoubleNode valueNode) {
        boolean isInteger = schemaAttribute.getType().equals((Object)Type.INTEGER);
        Function<Double, String> toNumberType = value -> isInteger ? String.valueOf(value.longValue()) : String.valueOf(value);
        double value2 = valueNode.doubleValue();
        schemaAttribute.getMinimum().ifPresent(minimum -> {
            if (minimum > value2) {
                String errorMessage = String.format("The '%s'-attribute '%s' with value '%s' must have at least a value of '%s'", schemaAttribute.getType(), schemaAttribute.getScimNodeName(), toNumberType.apply(value2), toNumberType.apply((Double)minimum));
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
        schemaAttribute.getMaximum().ifPresent(maximum -> {
            if (maximum < value2) {
                String errorMessage = String.format("The '%s'-attribute '%s' with value '%s' must not be greater than '%s'", schemaAttribute.getType(), schemaAttribute.getScimNodeName(), toNumberType.apply(value2), toNumberType.apply((Double)maximum));
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
        schemaAttribute.getMultipleOf().ifPresent(multipleOf -> {
            if (BigDecimal.valueOf(value2).remainder(BigDecimal.valueOf(multipleOf)).doubleValue() != 0.0) {
                String errorMessage = String.format("The '%s'-attribute '%s' with value '%s' must be a multiple of '%s'", schemaAttribute.getType(), schemaAttribute.getScimNodeName(), toNumberType.apply(value2), multipleOf);
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
    }

    public static void validateArrayNode(SchemaAttribute schemaAttribute, ArrayNode arrayNode) {
        if (schemaAttribute == null || arrayNode == null) {
            return;
        }
        schemaAttribute.getMinItems().ifPresent(minItems -> {
            if (minItems > arrayNode.size()) {
                String errorMessage = String.format("The 'ARRAY'-attribute '%s' with value '%s' must have at least '%s' items but only '%s' items are present", schemaAttribute.getScimNodeName(), arrayNode, minItems, arrayNode.size());
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
        schemaAttribute.getMaxItems().ifPresent(maxItems -> {
            if (maxItems < arrayNode.size()) {
                String errorMessage = String.format("The 'ARRAY'-attribute '%s' with value '%s' must not have more than '%s' items. Items found '%s'", schemaAttribute.getScimNodeName(), arrayNode, maxItems, arrayNode.size());
                throw new AttributeValidationException(schemaAttribute, errorMessage);
            }
        });
    }

    @Generated
    private CustomAttributeValidator() {
    }
}

