/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import de.captaingoldfish.scim.sdk.common.constants.enums.Uniqueness;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.exceptions.AttributeValidationException;
import de.captaingoldfish.scim.sdk.server.schemas.validation.CustomAttributeValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.SimpleAttributeValidator;
import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleMultivaluedAttributeValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleMultivaluedAttributeValidator.class);

    SimpleMultivaluedAttributeValidator() {
    }

    public static ArrayNode parseNodeTypeAndValidate(SchemaAttribute schemaAttribute, JsonNode attribute) {
        log.trace("Validating simple multivalued attribute '{}'", (Object)schemaAttribute.getScimNodeName());
        ArrayNode arrayNode = SimpleMultivaluedAttributeValidator.toArrayNode(attribute).orElseThrow(() -> {
            String errorMessage = String.format("Attribute '%s' is expected to be an array but is '%s'", schemaAttribute.getFullResourceName(), attribute);
            return new AttributeValidationException(schemaAttribute, errorMessage);
        });
        ScimArrayNode scimArrayNode = new ScimArrayNode(schemaAttribute);
        if (arrayNode.size() > 0) {
            ArrayList<String> uniqueValueList = new ArrayList<String>();
            for (JsonNode jsonNode : arrayNode) {
                if (!Uniqueness.NONE.equals((Object)schemaAttribute.getUniqueness())) {
                    if (uniqueValueList.contains(jsonNode.textValue())) {
                        String errorMessage = String.format("Array with uniqueness '%s' contains duplicate values '%s'", schemaAttribute.getUniqueness().getValue(), arrayNode);
                        throw new AttributeValidationException(schemaAttribute, errorMessage);
                    }
                    uniqueValueList.add(jsonNode.textValue());
                }
                try {
                    JsonNode parsedSimpleNode = SimpleAttributeValidator.parseNodeTypeAndValidate(schemaAttribute, jsonNode);
                    scimArrayNode.add(parsedSimpleNode);
                    CustomAttributeValidator.validateSimpleNode(schemaAttribute, parsedSimpleNode);
                }
                catch (AttributeValidationException ex) {
                    String errorMessage = String.format("Found unsupported value in multivalued attribute '%s'", arrayNode);
                    throw new AttributeValidationException(schemaAttribute, errorMessage, ex);
                }
            }
        }
        return scimArrayNode.isEmpty() ? null : scimArrayNode;
    }

    private static Optional<ArrayNode> toArrayNode(JsonNode attribute) {
        if (SimpleAttributeValidator.isSimpleNode(attribute)) {
            ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
            arrayNode.add(attribute);
            return Optional.of(arrayNode);
        }
        if (attribute.isArray()) {
            return Optional.of((ArrayNode)attribute);
        }
        return Optional.empty();
    }
}

