/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.schemas.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimArrayNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimBooleanNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimDoubleNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimLongNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ComplexAttributeValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.ContextValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.CustomAttributeValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.MultivaluedComplexAttributeValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.SimpleAttributeValidator;
import de.captaingoldfish.scim.sdk.server.schemas.validation.SimpleMultivaluedAttributeValidator;
import java.util.Optional;

class ValidationSelector {
    ValidationSelector() {
    }

    public static Optional<JsonNode> validateNode(SchemaAttribute schemaAttribute, JsonNode attribute, ContextValidator contextValidator) {
        JsonNode effectiveAttribute = contextValidator.handleDefaultValue(schemaAttribute, attribute);
        boolean isContextValidation = contextValidator.validateContext(schemaAttribute, effectiveAttribute);
        if (!isContextValidation || effectiveAttribute == null) {
            return Optional.empty();
        }
        boolean isAnyNode = Type.ANY.equals((Object)schemaAttribute.getType());
        if (isAnyNode) {
            return Optional.of(ValidationSelector.handleAnyAttribute(schemaAttribute, effectiveAttribute));
        }
        boolean isComplexType = Type.COMPLEX.equals((Object)schemaAttribute.getType());
        if (schemaAttribute.isMultiValued()) {
            if (isComplexType) {
                ArrayNode validatedAttribute = MultivaluedComplexAttributeValidator.parseNodeTypeAndValidate(schemaAttribute, effectiveAttribute, contextValidator);
                CustomAttributeValidator.validateArrayNode(schemaAttribute, validatedAttribute);
                return Optional.ofNullable(validatedAttribute);
            }
            ArrayNode validatedAttribute = SimpleMultivaluedAttributeValidator.parseNodeTypeAndValidate(schemaAttribute, effectiveAttribute);
            CustomAttributeValidator.validateArrayNode(schemaAttribute, validatedAttribute);
            return Optional.ofNullable(validatedAttribute);
        }
        if (isComplexType) {
            JsonNode validatedAttribute = ComplexAttributeValidator.parseNodeTypeAndValidate(schemaAttribute, effectiveAttribute, contextValidator);
            return Optional.ofNullable(validatedAttribute);
        }
        JsonNode validatedAttribute = SimpleAttributeValidator.parseNodeTypeAndValidate(schemaAttribute, effectiveAttribute);
        CustomAttributeValidator.validateSimpleNode(schemaAttribute, validatedAttribute);
        return Optional.of(validatedAttribute);
    }

    private static JsonNode handleAnyAttribute(SchemaAttribute schemaAttribute, JsonNode attribute) {
        if (schemaAttribute.isMultiValued() && !attribute.isArray()) {
            ScimArrayNode scimArrayNode = new ScimArrayNode(schemaAttribute);
            scimArrayNode.add(attribute);
            return scimArrayNode;
        }
        if (attribute.isArray() || attribute.isObject()) {
            return attribute;
        }
        return ValidationSelector.getSimpleAnyAttribute(schemaAttribute, attribute);
    }

    private static JsonNode getSimpleAnyAttribute(SchemaAttribute schemaAttribute, JsonNode attribute) {
        if (attribute.isTextual()) {
            return new ScimTextNode(schemaAttribute, attribute.textValue());
        }
        if (attribute.isBoolean()) {
            return new ScimBooleanNode(schemaAttribute, attribute.booleanValue());
        }
        if (attribute.isDouble() || attribute.isFloat()) {
            return new ScimDoubleNode(schemaAttribute, attribute.doubleValue());
        }
        if (attribute.isNumber() || attribute.isLong()) {
            return new ScimLongNode(schemaAttribute, attribute.longValue());
        }
        return NullNode.getInstance();
    }
}

