/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.sort;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.TimeUtils;
import java.util.Comparator;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ResourceNodeComparator
implements Comparator<ResourceNode> {
    private SchemaAttribute schemaAttribute;
    private SortOrder sortOrder;

    @Override
    public int compare(ResourceNode resource1, ResourceNode resource2) {
        boolean ascending = SortOrder.ASCENDING.equals((Object)this.sortOrder);
        Optional attribute1Optional = resource1.getSortingAttribute(this.schemaAttribute);
        Optional attribute2Optional = resource2.getSortingAttribute(this.schemaAttribute);
        if (!attribute1Optional.isPresent() && !attribute2Optional.isPresent()) {
            return 0;
        }
        if (!attribute1Optional.isPresent()) {
            return 1;
        }
        if (!attribute2Optional.isPresent()) {
            return -1;
        }
        JsonNode attribute1 = (JsonNode)attribute1Optional.get();
        JsonNode attribute2 = (JsonNode)attribute2Optional.get();
        switch (this.schemaAttribute.getType()) {
            case DATE_TIME: {
                long dateTime1 = TimeUtils.parseDateTime((String)attribute1.textValue()).toEpochMilli();
                long dateTime2 = TimeUtils.parseDateTime((String)attribute2.textValue()).toEpochMilli();
                int compare = NumberUtils.compare((long)dateTime1, (long)dateTime2);
                return ascending ? compare : -compare;
            }
            case INTEGER: {
                int compare = NumberUtils.compare((long)attribute1.longValue(), (long)attribute2.longValue());
                return ascending ? compare : -compare;
            }
            case DECIMAL: {
                double x = attribute1.doubleValue();
                double y = attribute2.doubleValue();
                if (x == y) {
                    return 0;
                }
                int compare = x < y ? -1 : 1;
                return ascending ? compare : -compare;
            }
        }
        if (this.schemaAttribute.isCaseExact()) {
            int compare = StringUtils.compare((String)attribute1.asText(), (String)attribute2.asText());
            return ascending ? compare : -compare;
        }
        int compare = StringUtils.compareIgnoreCase((String)attribute1.asText(), (String)attribute2.asText());
        return ascending ? compare : -compare;
    }

    @Generated
    public ResourceNodeComparator(SchemaAttribute schemaAttribute, SortOrder sortOrder) {
        this.schemaAttribute = schemaAttribute;
        this.sortOrder = sortOrder;
    }
}

