/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.utils;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimBooleanNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimDoubleNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimIntNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimLongNode;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimTextNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.Optional;

public interface ScimAttributeHelper {
    default public Object getValueOfJsonNode(SchemaAttribute schemaAttribute, JsonNode jsonNode) {
        Object object;
        switch (schemaAttribute.getType()) {
            case COMPLEX: 
            case ANY: {
                object = jsonNode;
                break;
            }
            case INTEGER: {
                object = Optional.ofNullable(jsonNode.numberValue()).map(Number::longValue).orElse(null);
                break;
            }
            case DECIMAL: {
                object = Optional.ofNullable(jsonNode.numberValue()).map(Number::doubleValue).orElse(null);
                break;
            }
            case BOOLEAN: {
                object = jsonNode.isBoolean() ? Boolean.valueOf(jsonNode.booleanValue()) : null;
                break;
            }
            default: {
                object = jsonNode.textValue();
            }
        }
        return object;
    }

    default public JsonNode parseToJsonNode(SchemaAttribute schemaAttribute, String value) {
        switch (schemaAttribute.getType()) {
            case COMPLEX: {
                return JsonHelper.readJsonDocument((String)value);
            }
            case STRING: 
            case DATE_TIME: 
            case REFERENCE: 
            case BINARY: {
                return new ScimTextNode(schemaAttribute, value);
            }
            case BOOLEAN: {
                return new ScimBooleanNode(schemaAttribute, Boolean.parseBoolean(value));
            }
            case INTEGER: {
                Long longVal = Long.parseLong(value);
                if (longVal == (long)longVal.intValue()) {
                    return new ScimIntNode(schemaAttribute, longVal.intValue());
                }
                return new ScimLongNode(schemaAttribute, longVal.longValue());
            }
        }
        return new ScimDoubleNode(schemaAttribute, Double.parseDouble(value));
    }
}

