/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.server.utils;

import de.captaingoldfish.scim.sdk.common.constants.enums.HttpMethod;
import de.captaingoldfish.scim.sdk.common.exceptions.BadRequestException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.utils.EncodingUtils;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceType;
import de.captaingoldfish.scim.sdk.server.schemas.ResourceTypeFactory;
import de.captaingoldfish.scim.sdk.server.utils.RequestUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriInfos {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UriInfos.class);
    private final String resourceEndpoint;
    private final boolean searchRequest;
    private final String baseUri;
    private final Map<String, String> queryParameters;
    private final ResourceType resourceType;
    private final HttpMethod httpMethod;
    private String resourceId;
    private Map<String, String> httpHeaders;

    private UriInfos(String resourceEndpoint, String resourceId, boolean searchRequest, String baseUri, String queryParameters, ResourceType resourceType, HttpMethod httpMethod, Map<String, String> httpHeaders, boolean lenientContentTypeChecking) {
        this.resourceEndpoint = resourceEndpoint;
        this.resourceId = resourceId;
        this.searchRequest = searchRequest;
        this.baseUri = baseUri;
        this.queryParameters = queryParameters == null ? new HashMap() : RequestUtils.getQueryParameters(queryParameters);
        this.resourceType = resourceType;
        this.httpMethod = Objects.requireNonNull(httpMethod);
        this.validateUriInfos(resourceType);
        this.httpHeaders = this.validateHttpHeaders(httpHeaders, lenientContentTypeChecking);
    }

    public static UriInfos getRequestUrlInfos(ResourceTypeFactory resourceTypeFactory, String requestUrl, HttpMethod httpMethod, Map<String, String> httpHeaders, boolean lenientContentTypeChecking) {
        URL url = UriInfos.toUrl(requestUrl);
        String[] pathParts = url.getPath().split("/");
        ResourceType resourceType = UriInfos.getResourceType(resourceTypeFactory, pathParts);
        if (UriInfos.isBulkRequest(httpMethod, resourceType)) {
            return UriInfos.builder().baseUri(StringUtils.substringBeforeLast((String)requestUrl, (String)"/Bulk")).resourceEndpoint("/Bulk").httpMethod(httpMethod).httpHeaders(httpHeaders).lenientContentTypeChecking(lenientContentTypeChecking).build();
        }
        boolean endsOfSearch = "/.search".endsWith(pathParts[pathParts.length - 1]);
        boolean endsOfResource = resourceType.getEndpoint().endsWith(pathParts[pathParts.length - 1]);
        String resourceId = endsOfSearch ? null : (endsOfResource ? null : pathParts[pathParts.length - 1]);
        String decodedResourceId = EncodingUtils.urlDecode(resourceId);
        boolean searchRequest = endsOfSearch && HttpMethod.POST.equals((Object)httpMethod) || HttpMethod.GET.equals((Object)httpMethod) && resourceId == null;
        String baseUri = StringUtils.substringBeforeLast((String)requestUrl, (String)resourceType.getEndpoint());
        UriInfos uriInfos = UriInfos.builder().baseUri(baseUri).searchRequest(searchRequest).resourceEndpoint(resourceType.getEndpoint()).resourceId(decodedResourceId).queryParameters(url.getQuery()).resourceType(resourceType).httpMethod(httpMethod).httpHeaders(httpHeaders).lenientContentTypeChecking(lenientContentTypeChecking).build();
        return uriInfos;
    }

    private static boolean isBulkRequest(HttpMethod httpMethod, ResourceType resourceType) {
        if (resourceType == null) {
            if (HttpMethod.POST.equals((Object)httpMethod)) {
                return true;
            }
            throw new BadRequestException("Bulk endpoint can only be reached with a HTTP-POST request", null, null);
        }
        return false;
    }

    private static ResourceType getResourceType(ResourceTypeFactory resourceTypeFactory, String[] urlParts) {
        if ("/Bulk".endsWith(urlParts[urlParts.length - 1])) {
            return null;
        }
        String nextToLastPathPart = "/" + urlParts[urlParts.length - 2];
        String lastPathPart = "/" + urlParts[urlParts.length - 1];
        ResourceType resourceType = Optional.ofNullable(resourceTypeFactory.getResourceType(nextToLastPathPart)).orElse(resourceTypeFactory.getResourceType(lastPathPart));
        if (resourceType != null) {
            return resourceType;
        }
        throw new BadRequestException(String.format("the request url '%s' does not point to a registered resource type. Registered resource types are: [%s]", String.join((CharSequence)"/", urlParts), resourceTypeFactory.getAllResourceTypes().stream().map(ResourceType::getEndpoint).collect(Collectors.joining(","))), null, "invalidParameters");
    }

    private static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new InternalServerException(e.getMessage(), (Throwable)e, null);
        }
    }

    private Map<String, String> validateHttpHeaders(Map<String, String> httpHeaders, boolean lenientContentTypeChecking) {
        boolean shouldCheckContentType;
        if (httpHeaders == null) {
            throw new InternalServerException("missing http headers. This is not a client error!", null, null);
        }
        if (httpHeaders.get("/Bulk") != null && httpHeaders.size() <= 2) {
            httpHeaders.remove("/Bulk");
            return httpHeaders;
        }
        String contentType = httpHeaders.keySet().stream().filter(header -> StringUtils.equalsIgnoreCase((CharSequence)header, (CharSequence)"Content-Type")).findAny().map(httpHeaders::get).orElse(null);
        boolean bl = shouldCheckContentType = HttpMethod.POST.equals((Object)this.httpMethod) || HttpMethod.PUT.equals((Object)this.httpMethod) || HttpMethod.PATCH.equals((Object)this.httpMethod);
        if (shouldCheckContentType) {
            if (contentType == null) {
                throw new BadRequestException(String.format("Invalid content type. Was '%s' but should be %s", contentType, "application/scim+json"), null, null);
            }
            boolean hasScimContentType = StringUtils.startsWith((CharSequence)contentType, (CharSequence)"application/scim+json");
            boolean hasApplicationJsonContentType = StringUtils.startsWith((CharSequence)contentType, (CharSequence)"application/json");
            if (!hasScimContentType) {
                if (lenientContentTypeChecking && hasApplicationJsonContentType) {
                    log.debug("Accepting Content-Type: 'application/json' as specified by to 'lenientContentTypeChecking' setting.");
                } else {
                    throw new BadRequestException(String.format("Invalid content type. Was '%s' but should be %s", contentType, "application/scim+json"), null, null);
                }
            }
        }
        return httpHeaders;
    }

    private void validateUriInfos(ResourceType resourceType) {
        switch (this.httpMethod) {
            case POST: {
                if (!StringUtils.isNotBlank((CharSequence)this.getResourceId())) break;
                throw new BadRequestException("ID values in the path are not allowed on '" + this.httpMethod + "' requests", null, "invalidParameters");
            }
            case PUT: 
            case PATCH: 
            case DELETE: {
                if (resourceType.getFeatures().isSingletonEndpoint() || !StringUtils.isBlank((CharSequence)this.getResourceId())) break;
                throw new BadRequestException("missing ID value in request path for method '" + this.httpMethod + "'", null, "invalidParameters");
            }
        }
    }

    public String toString() {
        return this.baseUri + this.resourceEndpoint + (StringUtils.isBlank((CharSequence)this.resourceId) ? "" : "/" + this.resourceId);
    }

    @Generated
    public static UriInfosBuilder builder() {
        return new UriInfosBuilder();
    }

    @Generated
    public String getResourceEndpoint() {
        return this.resourceEndpoint;
    }

    @Generated
    public boolean isSearchRequest() {
        return this.searchRequest;
    }

    @Generated
    public String getBaseUri() {
        return this.baseUri;
    }

    @Generated
    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Generated
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Generated
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Generated
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Generated
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Generated
    public static class UriInfosBuilder {
        @Generated
        private String resourceEndpoint;
        @Generated
        private String resourceId;
        @Generated
        private boolean searchRequest;
        @Generated
        private String baseUri;
        @Generated
        private String queryParameters;
        @Generated
        private ResourceType resourceType;
        @Generated
        private HttpMethod httpMethod;
        @Generated
        private Map<String, String> httpHeaders;
        @Generated
        private boolean lenientContentTypeChecking;

        @Generated
        UriInfosBuilder() {
        }

        @Generated
        public UriInfosBuilder resourceEndpoint(String resourceEndpoint) {
            this.resourceEndpoint = resourceEndpoint;
            return this;
        }

        @Generated
        public UriInfosBuilder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Generated
        public UriInfosBuilder searchRequest(boolean searchRequest) {
            this.searchRequest = searchRequest;
            return this;
        }

        @Generated
        public UriInfosBuilder baseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        @Generated
        public UriInfosBuilder queryParameters(String queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        @Generated
        public UriInfosBuilder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Generated
        public UriInfosBuilder httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Generated
        public UriInfosBuilder httpHeaders(Map<String, String> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        @Generated
        public UriInfosBuilder lenientContentTypeChecking(boolean lenientContentTypeChecking) {
            this.lenientContentTypeChecking = lenientContentTypeChecking;
            return this;
        }

        @Generated
        public UriInfos build() {
            return new UriInfos(this.resourceEndpoint, this.resourceId, this.searchRequest, this.baseUri, this.queryParameters, this.resourceType, this.httpMethod, this.httpHeaders, this.lenientContentTypeChecking);
        }

        @Generated
        public String toString() {
            return "UriInfos.UriInfosBuilder(resourceEndpoint=" + this.resourceEndpoint + ", resourceId=" + this.resourceId + ", searchRequest=" + this.searchRequest + ", baseUri=" + this.baseUri + ", queryParameters=" + this.queryParameters + ", resourceType=" + (Object)((Object)this.resourceType) + ", httpMethod=" + this.httpMethod + ", httpHeaders=" + this.httpHeaders + ", lenientContentTypeChecking=" + this.lenientContentTypeChecking + ")";
        }
    }
}

