/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

import de.carne.filescanner.engine.FileScanner;
import de.carne.filescanner.engine.FileScannerResult;
import de.carne.filescanner.engine.FileScannerResultBuilder;
import de.carne.filescanner.engine.FileScannerResultContextValueSpec;
import de.carne.filescanner.engine.FileScannerResultContextValueSpecs;
import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.EncodedInputSpec;
import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.filescanner.engine.input.FileScannerInputRange;
import de.carne.filescanner.engine.input.InputDecodeCache;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.util.Check;
import de.carne.util.Strings;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public class FileScannerResultDecodeContext
extends FileScannerResultInputContext {
    private static final Log LOG = new Log();
    private final FileScanner fileScanner;
    private final LinkedList<Scope> decodeStack = new LinkedList();
    private final List<FileScannerResultBuilder> pendingInputResults = new LinkedList<FileScannerResultBuilder>();

    FileScannerResultDecodeContext(FileScanner fileScanner, FileScannerResultBuilder parent, FileScannerInputRange inputRange, long position) {
        super(inputRange, position);
        this.fileScanner = fileScanner;
        this.decodeStack.push(new Scope(parent));
    }

    public FileScannerResult decodeComposite(CompositeSpec formatSpec) throws IOException {
        return this.decodeComposite(formatSpec, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileScannerResult decodeComposite(CompositeSpec formatSpec, long decodePosition, int decodeLevel) throws IOException {
        FileScannerResult decodeResult;
        long currentPosition = this.position();
        LOG.debug("Decode relocated at {0}:{1}...", new Object[]{HexFormat.formatLong(decodePosition), decodeLevel});
        this.setPosition(decodePosition);
        try {
            decodeResult = this.decodeComposite(formatSpec, decodeLevel, decodePosition != currentPosition || decodeLevel != 0);
        }
        finally {
            this.setPosition(currentPosition);
        }
        return decodeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FileScannerResult decodeComposite(CompositeSpec formatSpec, int decodeLevel, boolean relocated) throws IOException {
        LOG.debug("Decoding composite spec {0}...", new Object[]{formatSpec});
        boolean isRootSpec = this.decodeStack.size() == 1;
        boolean isResultSpec = formatSpec.isResult();
        if (isRootSpec && !isResultSpec) {
            throw new IllegalArgumentException("Root format spec must be a result spec");
        }
        this.byteOrder(formatSpec.byteOrder());
        FileScannerResultBuilder decodeResult = Objects.requireNonNull(this.decodeStack.peek()).builder();
        if (isResultSpec && !(formatSpec instanceof EncodedInputSpec)) {
            long position = this.position();
            FileScannerResultBuilder formatSpecResult = FileScannerResultBuilder.formatResult(this.getDecodeParent(decodeResult, decodeLevel), formatSpec, relocated, this.inputRange(), position);
            this.decodeStack.push(new Scope(formatSpecResult));
            if (isRootSpec) {
                this.bindResultValue(formatSpec, FileScannerResultContextValueSpecs.FORMAT_POSITION, position);
            }
            this.bindContextValue(FileScannerResultContextValueSpecs.RESULT_POSITION, position);
            try {
                this.runV(() -> {
                    formatSpec.decodeComposite(this);
                    formatSpecResult.resolveExportHandlers(formatSpec.exportHandlers());
                    if (!isRootSpec) {
                        formatSpecResult.updateAndCommit(this.position(), false);
                    }
                });
                if (!isRootSpec) return decodeResult;
                this.commit(formatSpecResult);
                return decodeResult;
            }
            finally {
                decodeResult = this.decodeStack.pop().builder();
            }
        } else {
            formatSpec.decodeComposite(this);
        }
        return decodeResult;
    }

    private FileScannerResultBuilder getDecodeParent(FileScannerResultBuilder builder, int decodeLevel) {
        FileScannerResultBuilder decodeParent = builder;
        for (int remaining = decodeLevel; remaining > 0; --remaining) {
            decodeParent = decodeParent.parent();
        }
        return decodeParent;
    }

    public FileScannerResult decodeEncodedInputs(EncodedInputSpec encodedInputSpec) throws IOException {
        LOG.debug("Decoding encoded input spec {0}...", new Object[]{encodedInputSpec});
        long decodeStart = this.position();
        FileScannerResultBuilder decodeResult = FileScannerResultBuilder.encodedInputResult(Objects.requireNonNull(this.decodeStack.peek()).builder(), encodedInputSpec, this.inputRange(), decodeStart, decodeStart);
        InputDecodeCache.DecodeResult decoded = this.fileScanner.decodeInputs(encodedInputSpec.decodedInputMapper().get(), encodedInputSpec.inputDecoderTable().get(), this.inputRange(), decodeStart);
        long commitPosition = decodeStart + decoded.encodedSize();
        this.setPosition(commitPosition);
        for (FileScannerInput decodedInput : decoded.decodedInputs()) {
            if (decodedInput.size() <= 0L) continue;
            FileScannerResultBuilder decodedInputResult = Objects.requireNonNull(FileScannerResultBuilder.inputResult(decodeResult, decodedInput).updateAndCommit(-1L, false));
            this.pendingInputResults.add(decodedInputResult);
        }
        decodeResult.updateAndCommit(commitPosition, false);
        return decodeResult;
    }

    public <T> T bindContextValue(AttributeSpec<T> valueSpec, @NonNull T value) {
        LOG.debug("Binding context attribute {0} = ''{1}''", new Object[]{valueSpec, Strings.encode((CharSequence)Objects.toString(value))});
        Objects.requireNonNull(this.decodeStack.peek()).contextValues().put(valueSpec, value);
        return value;
    }

    public <T> T bindResultValue(CompositeSpec scope, AttributeSpec<T> valueSpec, @NonNull T value) {
        LOG.debug("Binding result attribute {0}:{1} = ''{2}''", new Object[]{scope, valueSpec, Strings.encode((CharSequence)Objects.toString(value))});
        Objects.requireNonNull(this.decodeStack.peek()).builder().bindResultValue(scope, valueSpec, value);
        return value;
    }

    public <T> T bindDecodedValue(FileScannerResultContextValueSpec<T> valueSpec, @NonNull T value) {
        LOG.debug("Binding decoded value {0} = ''{1}''", new Object[]{valueSpec, Strings.encode((CharSequence)Objects.toString(value))});
        Objects.requireNonNull(this.decodeStack.peek()).builder().bindDecodedValue(valueSpec, value);
        return value;
    }

    @Override
    public <T> T getValue(FileScannerResultContextValueSpec<T> valueSpec) {
        LOG.debug("Resolving context value {0}", new Object[]{valueSpec});
        Scope result = Objects.requireNonNull(this.decodeStack.peek());
        Object contextValue = result.contextValues().get(valueSpec);
        Object value = contextValue != null ? Check.isInstanceOf((Object)contextValue, valueSpec.type()) : result.builder().getValue(valueSpec, false);
        LOG.debug("Resolved context value {0} = ''{1}''", new Object[]{valueSpec, Strings.encode((CharSequence)Objects.toString(value))});
        return (T)value;
    }

    public void commit() {
        this.commit(Objects.requireNonNull(this.decodeStack.peek()).builder());
    }

    private void commit(FileScannerResultBuilder result) {
        FileScannerResultBuilder commitResult = result.updateAndCommit(this.position(), true);
        if (commitResult != null) {
            this.fileScanner.onScanResultCommit(commitResult);
            this.fileScanner.queueInputResults(this.pendingInputResults);
            this.pendingInputResults.clear();
        }
    }

    private static final class Scope {
        private final FileScannerResultBuilder builder;
        private final Map<Object, Object> contextValues = new HashMap<Object, Object>();

        Scope(FileScannerResultBuilder builder) {
            this.builder = builder;
        }

        public FileScannerResultBuilder builder() {
            return this.builder;
        }

        public Map<Object, Object> contextValues() {
            return this.contextValues;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

