/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

import de.carne.filescanner.engine.DecodeFailureException;
import de.carne.filescanner.engine.FileScannerResultContext;
import de.carne.filescanner.engine.InsufficientDataException;
import de.carne.filescanner.engine.InvalidPositionException;
import de.carne.filescanner.engine.StreamValue;
import de.carne.filescanner.engine.StreamValueDecoder;
import de.carne.filescanner.engine.ValueDecoder;
import de.carne.filescanner.engine.ValueStreamerStatus;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.input.FileScannerInputRange;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.util.Check;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class FileScannerResultInputContext
extends FileScannerResultContext {
    private final FileScannerInputRange inputRange;
    private long initialPosition;
    private long position;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;

    protected FileScannerResultInputContext(FileScannerInputRange inputRange, long position) {
        this.inputRange = inputRange;
        this.initialPosition = position;
        this.position = position;
    }

    protected FileScannerInputRange inputRange() {
        return this.inputRange;
    }

    public long position() {
        return this.position;
    }

    public long remaining() {
        return this.inputRange.end() - this.position;
    }

    public long decoded() {
        return this.position - this.initialPosition;
    }

    protected void setPosition(long position) throws IOException {
        if (position < this.inputRange.start() || this.inputRange.end() < position) {
            throw new InvalidPositionException(this.inputRange, position);
        }
        this.position = position;
    }

    protected ByteOrder byteOrder(ByteOrder order) {
        ByteOrder previousByteOrder = this.byteOrder;
        this.byteOrder = order;
        return previousByteOrder;
    }

    public boolean matchFormat(FormatSpec spec) throws IOException {
        int matchSize = spec.matchSize();
        boolean match = true;
        if (matchSize > 0) {
            ByteBuffer buffer = this.inputRange.read(this.position, matchSize);
            buffer.order(this.byteOrder);
            match = spec.matches(buffer);
        }
        return match;
    }

    public boolean matchComposite(CompositeSpec spec) throws IOException {
        this.byteOrder = spec.byteOrder();
        return this.matchFormat(spec);
    }

    public void skip(long size) throws IOException {
        if (size < 0L) {
            throw new InsufficientDataException(this.inputRange, this.position, size, this.inputRange.end() - this.position);
        }
        this.setPosition(this.position + size);
    }

    public <T> T readValue(int size, ValueDecoder<T> decoder) throws IOException {
        ByteBuffer buffer = this.readComplete(size);
        buffer.order(this.byteOrder);
        T value = decoder.decode(buffer);
        this.position += (long)size;
        return value;
    }

    public <T> T readValue(int chunkSize, StreamValueDecoder<T> decoder) throws IOException {
        ValueStreamerStatus status;
        Check.assertTrue((chunkSize > 0 ? 1 : 0) != 0);
        ByteBuffer buffer = ByteBuffer.allocate(Math.max(2 * chunkSize, 64)).order(this.byteOrder).limit(0);
        do {
            if (buffer.remaining() < chunkSize) {
                buffer.clear();
                this.inputRange.read(buffer, this.position);
                buffer.flip();
            }
            int decodeStart = buffer.position();
            status = decoder.stream(buffer);
            int decodeEnd = buffer.position();
            if (decodeStart < decodeEnd && status != ValueStreamerStatus.FAILED) {
                this.position += (long)(decodeEnd - decodeStart);
                continue;
            }
            if (status != ValueStreamerStatus.FAILED && (status != ValueStreamerStatus.STREAMING || decodeStart != decodeEnd) && decodeStart <= decodeEnd) continue;
            throw new DecodeFailureException(this.inputRange, this.position + (long)decodeStart);
        } while (status == ValueStreamerStatus.STREAMING);
        return decoder.decode();
    }

    public StreamValue streamValue(long size, boolean skip) throws IOException {
        if (skip) {
            this.skip(size);
        }
        return new StreamValue(this.inputRange, this.position - size, this.position);
    }

    private ByteBuffer readComplete(int size) throws IOException {
        ByteBuffer buffer = this.inputRange.read(this.position, size);
        if (buffer.remaining() < size) {
            throw new InsufficientDataException(this.inputRange, this.position, size, buffer.remaining());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.inputRange);
        buffer.append('[');
        HexFormat.formatLong(buffer, this.position);
        buffer.append(']');
        return buffer.toString();
    }
}

