/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine;

import de.carne.filescanner.engine.FileScannerResult;
import de.carne.filescanner.engine.FileScannerResultBuilder;
import de.carne.filescanner.engine.FileScannerResultContextValueSpec;
import de.carne.filescanner.engine.FileScannerResultContextValueSpecs;
import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.EncodedInputSpec;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.TransferSource;
import de.carne.util.Check;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class FileScannerResultRenderContext
extends FileScannerResultInputContext {
    private static final Log LOG = new Log();
    private final Map<FileScannerResultContextValueSpec<?>, Object> contextValues = new HashMap();
    private final FileScannerResultBuilder result;

    FileScannerResultRenderContext(FileScannerResultBuilder result, long offset) throws IOException {
        super(result.input().range(result.start(), result.end()), result.start() + offset);
        this.result = result;
    }

    public FileScannerResult result() {
        return this.result;
    }

    public void render(RenderOutput out, CompositeSpec formatSpec) throws IOException {
        if (!this.inContext(this.getClass()) || !formatSpec.isResult()) {
            LOG.debug("Rendering format spec ''{0}''...", new Object[]{formatSpec});
            this.runV(() -> {
                ByteOrder previousByteOrder = this.byteOrder(formatSpec.byteOrder());
                try {
                    this.bindContextValue(FileScannerResultContextValueSpecs.RESULT_POSITION, this.position());
                    formatSpec.renderComposite(out, this);
                }
                finally {
                    this.byteOrder(previousByteOrder);
                }
            });
        }
    }

    public void render(RenderOutput out, EncodedInputSpec encodedInputSpec) throws IOException {
        LOG.debug("Rendering encoded input spec ''{0}''...", new Object[]{encodedInputSpec});
        this.runV(() -> encodedInputSpec.inputDecoderTable().get().render(out));
    }

    public <T> void bindContextValue(AttributeSpec<T> attribute, @NonNull T value) {
        this.contextValues.put(attribute, value);
    }

    @Override
    public <T> T getValue(FileScannerResultContextValueSpec<T> valueSpec) {
        Object value = this.contextValues.get(valueSpec);
        if (value == null) {
            value = this.result.getValue(valueSpec, true);
        }
        return (T)Check.isInstanceOf((Object)value, valueSpec.type());
    }

    public TransferSource export(FileScannerResultExportHandler exportHandler) throws IOException {
        LOG.debug("Executing export handler ''{0}''...", new Object[]{exportHandler});
        return this.runT(() -> exportHandler.export(this));
    }
}

