/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultDecodeContext;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.filescanner.engine.util.PrettyFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public class ArraySpec
extends CompositeSpec {
    private final Supplier<? extends Number> size;
    private final List<AttributeSpec<?>> elements = new ArrayList();
    private int cachedFixedSize = -1;
    private int cachedMatchSize = -1;

    public ArraySpec(Supplier<? extends Number> size) {
        this.size = size;
    }

    public ArraySpec(int size) {
        this(FinalSupplier.of(size));
    }

    public <T extends AttributeSpec<?>> T add(T element) {
        this.elements.add(element);
        this.cachedFixedSize = -1;
        this.cachedMatchSize = -1;
        return element;
    }

    @Override
    public boolean isFixedSize() {
        return this.cachedFixedSize >= 0 ? this.cachedFixedSize != 0 : this.isFixedSize0();
    }

    private synchronized boolean isFixedSize0() {
        this.cachedFixedSize = 0;
        if (this.size instanceof FinalSupplier) {
            this.cachedFixedSize = 1;
            for (AttributeSpec<?> element : this.elements) {
                if (element.isFixedSize()) continue;
                this.cachedFixedSize = 0;
                break;
            }
        }
        return this.cachedFixedSize != 0;
    }

    @Override
    public int matchSize() {
        return this.cachedMatchSize >= 0 ? this.cachedMatchSize : this.matchSize0();
    }

    private synchronized int matchSize0() {
        this.cachedMatchSize = 0;
        if (this.size instanceof FinalSupplier) {
            int matchElementCount = this.size.get().intValue();
            for (AttributeSpec<?> element : this.elements) {
                this.cachedMatchSize += element.matchSize();
                if (element.isFixedSize()) continue;
                matchElementCount = Math.min(matchElementCount, 1);
                break;
            }
            this.cachedMatchSize *= matchElementCount;
        }
        return this.cachedMatchSize;
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        boolean match = true;
        if (this.size instanceof FinalSupplier) {
            int totalMatchSize = 0;
            while (match && totalMatchSize < this.cachedMatchSize) {
                AttributeSpec<?> element;
                Iterator<AttributeSpec<?>> iterator = this.elements.iterator();
                while (iterator.hasNext() && (match = (element = iterator.next()).matches(buffer)) && element.isFixedSize()) {
                    totalMatchSize += element.matchSize();
                }
            }
        }
        return match;
    }

    @Override
    public void decodeComposite(FileScannerResultDecodeContext context) throws IOException {
        int elementCount = this.size.get().intValue();
        for (int elementIndex = 0; elementIndex < elementCount; ++elementIndex) {
            for (AttributeSpec<?> element : this.elements) {
                element.decode(context);
            }
        }
    }

    @Override
    public void renderComposite(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        if (this.hasRenderer()) {
            super.renderComposite(out, context);
        } else {
            int elementCount = this.size.get().intValue();
            for (int elementIndex = 0; elementIndex < elementCount; ++elementIndex) {
                String arrayLabel = this.formatArrayLabel(elementIndex);
                for (AttributeSpec<?> element : this.elements) {
                    out.setStyle(RenderStyle.LABEL);
                    out.write(arrayLabel);
                    element.render(out, context);
                }
            }
        }
    }

    private String formatArrayLabel(int elementIndex) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[').append(PrettyFormat.formatIntNumber(elementIndex)).append("]: ");
        return buffer.toString();
    }
}

