/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultContextValueSpec;
import de.carne.filescanner.engine.FileScannerResultDecodeContext;
import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.UnexpectedDataException;
import de.carne.filescanner.engine.format.AttributeBindMode;
import de.carne.filescanner.engine.format.AttributeFormatter;
import de.carne.filescanner.engine.format.AttributeLinkResolver;
import de.carne.filescanner.engine.format.AttributeRenderer;
import de.carne.filescanner.engine.format.AttributeValidator;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.util.Strings;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AttributeSpec<T>
extends FileScannerResultContextValueSpec<T>
implements FormatSpec {
    private final BiPredicate<T, T> typeEquals;
    private AttributeFormatter<T> format = Object::toString;
    private final List<AttributeValidator<T>> validators = new ArrayList<AttributeValidator<T>>();
    private final List<AttributeRenderer<T>> renderers = new ArrayList<AttributeRenderer<T>>();
    private @Nullable AttributeLinkResolver<T> link = null;
    private AttributeBindMode bindMode = AttributeBindMode.NONE;
    private @Nullable CompositeSpec bindScope = null;

    protected AttributeSpec(Class<T> type, BiPredicate<T, T> typeEquals, Supplier<String> name) {
        super(type, name);
        this.typeEquals = typeEquals;
    }

    protected AttributeSpec(Class<T> type, BiPredicate<T, T> typeEquals, String name) {
        this(type, typeEquals, FinalSupplier.of(name));
    }

    public AttributeSpec<T> format(AttributeFormatter<T> formatter) {
        this.format = formatter;
        return this;
    }

    public AttributeSpec<T> format(String formatter) {
        AttributeFormatter<Object> attributeFormatter = this.type().isArray() ? value -> {
            StringBuilder buffer = new StringBuilder();
            int length = Array.getLength(value);
            buffer.append("{ ");
            for (int index = 0; index < length; ++index) {
                if (index > 0) {
                    buffer.append(", ");
                }
                buffer.append(String.format(formatter, Array.get(value, index)));
            }
            buffer.append(length > 0 ? " }" : "}");
            return buffer.toString();
        } : value -> String.format(formatter, value);
        return this.format(attributeFormatter);
    }

    public AttributeSpec<T> validate(AttributeValidator<T> validator) {
        this.validators.add(validator);
        return this;
    }

    public AttributeSpec<T> validate(@NonNull T value) {
        return this.validate((T)((AttributeValidator<Object>)value2 -> this.typeEquals.test(value, value2)));
    }

    public AttributeSpec<T> validate(Set<T> values) {
        if (this.type().isArray()) {
            this.validate((T)((AttributeValidator<Object>)value -> values.stream().anyMatch(value2 -> this.typeEquals.test(value, value2))));
        } else {
            this.validate((T)((AttributeValidator<Object>)values::contains));
        }
        return this;
    }

    public AttributeSpec<T> renderer(AttributeRenderer<T> renderer) {
        this.renderers.add(renderer);
        return this;
    }

    public AttributeSpec<T> link(AttributeLinkResolver<T> linkResolver) {
        this.link = linkResolver;
        return this;
    }

    public AttributeSpec<T> bind() {
        this.bindMode = AttributeBindMode.CONTEXT;
        this.bindScope = null;
        return this;
    }

    public AttributeSpec<T> bind(CompositeSpec scope) {
        if (!scope.isResult()) {
            throw new IllegalArgumentException("Scope format spec must be a result spec");
        }
        this.bindMode = AttributeBindMode.RESULT;
        this.bindScope = scope;
        return this;
    }

    protected abstract @NonNull T decodeValue(FileScannerResultInputContext var1) throws IOException;

    protected @NonNull T redecodeValue(FileScannerResultRenderContext context) throws IOException {
        return this.decodeValue(context);
    }

    protected boolean validateValue(T value) {
        return this.validators.stream().allMatch(validator -> validator.validate(value));
    }

    @Override
    public void decode(FileScannerResultDecodeContext context) throws IOException {
        long decodeStart = context.position();
        T value = this.decodeValue(context);
        if (!this.validateValue(value)) {
            throw new UnexpectedDataException("Unexpected " + this, decodeStart, value);
        }
        switch (this.bindMode) {
            case NONE: {
                break;
            }
            case CONTEXT: {
                context.bindContextValue(this, value);
                break;
            }
            case RESULT: {
                context.bindResultValue(Objects.requireNonNull(this.bindScope), this, value);
            }
        }
    }

    @Override
    public void render(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        long linkPosition;
        T value = this.redecodeValue(context);
        switch (this.bindMode) {
            case NONE: {
                break;
            }
            case CONTEXT: {
                context.bindContextValue(this, value);
                break;
            }
        }
        String name = this.name();
        if (Strings.notEmpty((String)name)) {
            out.setStyle(RenderStyle.NORMAL).write(name);
            out.setStyle(RenderStyle.OPERATOR).write(" = ");
        }
        out.setStyle(RenderStyle.VALUE);
        String formattedValue = this.format.format(value);
        long l = linkPosition = this.link != null ? this.link.resolve(value) : -1L;
        if (linkPosition >= 0L) {
            out.write(formattedValue, linkPosition);
        } else {
            out.write(formattedValue);
        }
        for (AttributeRenderer<T> renderer : this.renderers) {
            renderer.render(out, value);
        }
        out.writeln();
    }
}

