/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.format.FlagRenderer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.Nullable;

public class DWordFlagRenderer
extends FlagRenderer<Integer> {
    private static final long serialVersionUID = -2295541110505555035L;
    private static final int MSB = Integer.MIN_VALUE;

    @Override
    public @Nullable String put(int flag, String symbol) {
        return this.put(Integer.valueOf(flag), symbol);
    }

    @Override
    protected Iterator<Integer> flags() {
        return new Iterator<Integer>(){
            private int nextFlag = Integer.MIN_VALUE;

            @Override
            public boolean hasNext() {
                return this.nextFlag != 0;
            }

            @Override
            public Integer next() {
                if (this.nextFlag == 0) {
                    throw new NoSuchElementException();
                }
                int flag = this.nextFlag;
                this.nextFlag = DWordFlagRenderer.shift(this.nextFlag);
                return flag;
            }
        };
    }

    @Override
    protected boolean testFlag(Integer value, Integer flag) {
        int flagValue = flag;
        return (value & flagValue) != 0;
    }

    @Override
    protected Integer combineFlags(Integer flag1, Integer flag2) {
        return flag1 | flag2;
    }

    @Override
    protected String formatFlag(Integer value, Integer flag) {
        StringBuilder buffer = new StringBuilder();
        int valueValue = value;
        int flagValue = flag;
        int mask = Integer.MIN_VALUE;
        while (mask != 0) {
            if ((flagValue & mask) != mask) {
                buffer.append('.');
            } else if ((flagValue & valueValue) != 0) {
                buffer.append('1');
            } else {
                buffer.append('0');
            }
            mask = DWordFlagRenderer.shift(mask);
        }
        return buffer.toString();
    }

    static int shift(int flag) {
        return flag >>> 1;
    }
}

