/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.format.AttributeRenderer;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;

public abstract class FlagRenderer<T>
extends LinkedHashMap<T, String>
implements AttributeRenderer<T> {
    private static final long serialVersionUID = -5863180152604163026L;

    @Override
    public void render(RenderOutput out, T value) throws IOException {
        Iterator<T> flags = this.flags();
        Iterator symbolEntries = this.entrySet().iterator();
        Object currentSymbolFlag = null;
        Object nextSymbolFlag = symbolEntries.hasNext() ? symbolEntries.next().getKey() : null;
        Object unknownFlags = null;
        while (flags.hasNext()) {
            T flag = flags.next();
            if (currentSymbolFlag != null && !this.testFlag(currentSymbolFlag, flag)) {
                this.renderFlag(out, value, currentSymbolFlag);
                currentSymbolFlag = null;
            }
            if (currentSymbolFlag != null) continue;
            if (nextSymbolFlag != null && this.testFlag(nextSymbolFlag, flag)) {
                if (unknownFlags != null && this.testFlag(value, unknownFlags)) {
                    this.renderFlag(out, value, unknownFlags);
                    unknownFlags = null;
                }
                currentSymbolFlag = nextSymbolFlag;
                nextSymbolFlag = symbolEntries.hasNext() ? symbolEntries.next().getKey() : null;
                continue;
            }
            if (!this.testFlag(value, flag)) continue;
            unknownFlags = (unknownFlags != null ? this.combineFlags(unknownFlags, flag) : flag);
        }
        if (currentSymbolFlag != null) {
            this.renderFlag(out, value, currentSymbolFlag);
        } else if (unknownFlags != null && this.testFlag(value, unknownFlags)) {
            this.renderFlag(out, value, unknownFlags);
        }
    }

    private void renderFlag(RenderOutput out, T value, T flag) throws IOException {
        out.writeln();
        out.setStyle(RenderStyle.VALUE).write(this.formatFlag(value, flag));
        out.setStyle(RenderStyle.COMMENT).write(" // ").write(this.getOrDefault(flag, "?"));
    }

    protected abstract Iterator<T> flags();

    protected abstract boolean testFlag(T var1, T var2);

    protected abstract T combineFlags(T var1, T var2);

    protected abstract String formatFlag(T var1, T var2);
}

