/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.filescanner.engine.util.HexFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;

public class QWordArraySpec
extends AttributeSpec<long[]> {
    private Supplier<? extends Number> size = FinalSupplier.of(0);

    public QWordArraySpec(Supplier<String> name) {
        super(long[].class, Arrays::equals, name);
        this.format(HexFormat.LONG_ARRAY_FORMATTER);
    }

    public QWordArraySpec(String name) {
        this(FinalSupplier.of(name));
    }

    public QWordArraySpec length(Supplier<? extends Number> lengthSupplier) {
        this.size = lengthSupplier instanceof FinalSupplier ? FinalSupplier.of(lengthSupplier.get().intValue() << 3) : () -> ((Number)lengthSupplier.get()).intValue() << 3;
        return this;
    }

    public QWordArraySpec length(int lengthValue) {
        this.size = FinalSupplier.of(lengthValue);
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return FormatSpecs.isFixedSize(this.size);
    }

    @Override
    public int matchSize() {
        return FormatSpecs.matchSize(this.size);
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return FormatSpecs.matches(buffer, this.size, b -> this.validateValue(this.decodeValue((ByteBuffer)b)));
    }

    @Override
    protected long[] decodeValue(FileScannerResultInputContext context) throws IOException {
        return context.readValue(this.size.get().intValue(), this::decodeValue);
    }

    private long[] decodeValue(ByteBuffer buffer) {
        ByteBuffer slice = buffer.slice();
        slice.limit(this.size.get().intValue());
        long[] value = new long[slice.remaining() >> 3];
        int valueIndex = 0;
        while (slice.hasRemaining()) {
            value[valueIndex] = slice.getLong();
            ++valueIndex;
        }
        buffer.position(buffer.position() + slice.position());
        return value;
    }
}

