/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.format.FlagRenderer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.Nullable;

public class QWordFlagRenderer
extends FlagRenderer<Long> {
    private static final long serialVersionUID = -2295541110505555035L;
    private static final long MSB = Long.MIN_VALUE;

    @Override
    public @Nullable String put(long flag, String symbol) {
        return this.put(Long.valueOf(flag), symbol);
    }

    @Override
    protected Iterator<Long> flags() {
        return new Iterator<Long>(){
            private long nextFlag = Long.MIN_VALUE;

            @Override
            public boolean hasNext() {
                return this.nextFlag != 0L;
            }

            @Override
            public Long next() {
                if (this.nextFlag == 0L) {
                    throw new NoSuchElementException();
                }
                long flag = this.nextFlag;
                this.nextFlag = QWordFlagRenderer.shift(this.nextFlag);
                return flag;
            }
        };
    }

    @Override
    protected boolean testFlag(Long value, Long flag) {
        long flagValue = flag;
        return (value & flagValue) != 0L;
    }

    @Override
    protected Long combineFlags(Long flag1, Long flag2) {
        return flag1 | flag2;
    }

    @Override
    protected String formatFlag(Long value, Long flag) {
        StringBuilder buffer = new StringBuilder();
        long valueValue = value;
        long flagValue = flag;
        long mask = Long.MIN_VALUE;
        while (mask != 0L) {
            if ((flagValue & mask) != mask) {
                buffer.append('.');
            } else if ((flagValue & valueValue) != 0L) {
                buffer.append('1');
            } else {
                buffer.append('0');
            }
            mask = QWordFlagRenderer.shift(mask);
        }
        return buffer.toString();
    }

    static long shift(long flag) {
        return flag >>> 1;
    }
}

