/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.StreamValue;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.filescanner.engine.util.LongHelper;
import de.carne.filescanner.engine.util.SizeRenderer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;

public class RangeAttributeSpec
extends AttributeSpec<StreamValue> {
    private Supplier<? extends Number> size = FinalSupplier.of(-1L);

    public RangeAttributeSpec(Supplier<String> name) {
        super(StreamValue.class, Objects::equals, name);
        this.renderer(this::sizeRenderer);
    }

    public RangeAttributeSpec(String name) {
        this(FinalSupplier.of(name));
    }

    public RangeAttributeSpec size(Supplier<? extends Number> sizeSupplier) {
        this.size = sizeSupplier;
        return this;
    }

    public RangeAttributeSpec size(int sizeValue) {
        this.size = FinalSupplier.of(sizeValue);
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return FormatSpecs.isFixedSize(this.size);
    }

    @Override
    public int matchSize() {
        return FormatSpecs.matchSize(this.size);
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return FormatSpecs.matches(buffer, this.size);
    }

    @Override
    protected StreamValue decodeValue(FileScannerResultInputContext context) throws IOException {
        long sizeValue = LongHelper.toUnsignedLong(this.size.get());
        return context.streamValue(sizeValue >= 0L ? sizeValue : context.remaining(), true);
    }

    private void sizeRenderer(RenderOutput out, StreamValue value) throws IOException {
        SizeRenderer.LONG_RENDERER.render(out, value.size());
    }
}

