/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultContextValueSpecs;
import de.carne.filescanner.engine.FileScannerResultDecodeContext;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.UnexpectedDataException;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.DWordSpec;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.util.FinalSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;

public class SequenceSpec
extends CompositeSpec {
    private final DWordSpec decodedElementCount = new DWordSpec(SequenceSpec.class.getSimpleName() + ".decodedElementCount");
    private final FormatSpec elementSpec;
    private @Nullable FormatSpec stopBeforeSpec = null;
    private @Nullable FormatSpec stopAfterSpec = null;
    private @Nullable Supplier<? extends Number> minSize = null;
    private @Nullable Supplier<? extends Number> maxSize = null;

    public SequenceSpec(FormatSpec elementSpec) {
        this.elementSpec = elementSpec;
    }

    public SequenceSpec stopBefore(FormatSpec stopSpec) {
        this.stopBeforeSpec = stopSpec;
        return this;
    }

    public SequenceSpec stopAfter(FormatSpec stopSpec) {
        this.stopAfterSpec = stopSpec;
        return this;
    }

    public SequenceSpec min(Supplier<? extends Number> min) {
        this.minSize = min;
        return this;
    }

    public SequenceSpec min(int min) {
        return this.min(FinalSupplier.of(min));
    }

    public SequenceSpec max(Supplier<? extends Number> max) {
        this.maxSize = max;
        return this;
    }

    public SequenceSpec miax(int max) {
        return this.max(FinalSupplier.of(max));
    }

    public SequenceSpec size(Supplier<? extends Number> size) {
        this.maxSize = size;
        this.minSize = this.maxSize;
        return this;
    }

    public SequenceSpec size(int size) {
        return this.size(FinalSupplier.of(size));
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public int matchSize() {
        return this.elementSpec.matchSize();
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return this.elementSpec.matches(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decodeComposite(FileScannerResultDecodeContext context) throws IOException {
        int maxMatchCount;
        long decodeStart = context.position();
        int matchCount = 0;
        int minMatchCount = this.minSize != null ? this.minSize.get().intValue() : 0;
        int n = maxMatchCount = this.maxSize != null ? this.maxSize.get().intValue() : Integer.MAX_VALUE;
        if (minMatchCount < 0 || maxMatchCount < minMatchCount) {
            throw new UnexpectedDataException("Unexpected sequence range " + minMatchCount + ":" + maxMatchCount);
        }
        boolean done = maxMatchCount == 0;
        try {
            while (!done) {
                FormatSpec checkedStopBeforeSpec = this.stopBeforeSpec;
                FormatSpec checkedStopAfterSpec = this.stopAfterSpec;
                context.bindContextValue(FileScannerResultContextValueSpecs.SEQUENCE_ELEMENT_INDEX, matchCount);
                if (checkedStopBeforeSpec != null && context.matchFormat(checkedStopBeforeSpec)) {
                    done = true;
                    continue;
                }
                if (checkedStopAfterSpec != null && context.matchFormat(checkedStopAfterSpec)) {
                    checkedStopAfterSpec.decode(context);
                    ++matchCount;
                    done = true;
                    continue;
                }
                if (context.matchFormat(this.elementSpec)) {
                    this.elementSpec.decode(context);
                    done = ++matchCount >= maxMatchCount;
                    continue;
                }
                done = true;
            }
        }
        finally {
            context.bindContextValue(FileScannerResultContextValueSpecs.SEQUENCE_ELEMENT_INDEX, -1);
        }
        if (matchCount < minMatchCount) {
            throw new UnexpectedDataException("Insufficent sequence length", decodeStart);
        }
        context.bindDecodedValue(this.decodedElementCount, matchCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderComposite(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        if (this.hasRenderer()) {
            super.renderComposite(out, context);
        } else if (!FormatSpecs.isResult(this.elementSpec)) {
            int elementCount = context.getValue(this.decodedElementCount);
            try {
                for (int elementIndex = 0; elementIndex < elementCount; ++elementIndex) {
                    context.bindContextValue(FileScannerResultContextValueSpecs.SEQUENCE_ELEMENT_INDEX, elementIndex);
                    this.elementSpec.render(out, context);
                }
            }
            finally {
                context.bindContextValue(FileScannerResultContextValueSpecs.SEQUENCE_ELEMENT_INDEX, -1);
            }
        } else {
            context.skip(context.remaining());
        }
    }
}

