/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.filescanner.engine.util.PrettyFormat;
import de.carne.filescanner.engine.util.StringHelper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

public abstract class StringAttributeSpec
extends AttributeSpec<String> {
    private Supplier<Charset> charset = FinalSupplier.of(StandardCharsets.US_ASCII);

    protected StringAttributeSpec(Supplier<String> name) {
        super(String.class, String::equals, name);
        this.format(PrettyFormat.STRING_FORMATTER);
    }

    protected StringAttributeSpec(String name) {
        this(FinalSupplier.of(name));
    }

    public StringAttributeSpec charset(Supplier<Charset> charsetSupplier) {
        this.charset = charsetSupplier;
        return this;
    }

    public StringAttributeSpec charset(Charset charsetValue) {
        this.charset = () -> charsetValue;
        return this;
    }

    public Charset charset() {
        return this.charset.get();
    }

    public String getStripped() {
        return StringHelper.strip((String)this.get());
    }
}

