/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.StreamValueDecoder;
import de.carne.filescanner.engine.ValueStreamerStatus;
import de.carne.filescanner.engine.format.StringAttributeSpec;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.util.SystemProperties;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.function.Supplier;

public class StringSpec
extends StringAttributeSpec {
    private static final int MAX_LENGTH = SystemProperties.intValue(StringSpec.class, (String)".maxLength", (int)Short.MAX_VALUE);

    public StringSpec(Supplier<String> name) {
        super(name);
    }

    public StringSpec(String name) {
        this(FinalSupplier.of(name));
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public int matchSize() {
        return 0;
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return true;
    }

    @Override
    protected String decodeValue(FileScannerResultInputContext context) throws IOException {
        final CharsetDecoder decoder = this.charset().newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int chunkSize = (int)Math.ceil(decoder.maxCharsPerByte());
        final int maxLength = MAX_LENGTH;
        return context.readValue(chunkSize, new StreamValueDecoder<String>(){
            private final CharBuffer stringBuffer;
            {
                this.stringBuffer = CharBuffer.allocate(maxLength);
            }

            @Override
            public ValueStreamerStatus stream(ByteBuffer buffer) {
                ValueStreamerStatus status;
                if (this.stringBuffer.hasRemaining() || this.stringBuffer.limit() < this.stringBuffer.capacity()) {
                    this.stringBuffer.limit(this.stringBuffer.position() + 1);
                    CoderResult coderResult = decoder.decode(buffer, this.stringBuffer, false);
                    if (!coderResult.isError()) {
                        int lastCharPosition = this.stringBuffer.position() - 1;
                        if (this.stringBuffer.get(lastCharPosition) == '\u0000') {
                            this.stringBuffer.position(lastCharPosition);
                            this.stringBuffer.flip();
                            status = ValueStreamerStatus.COMPLETE;
                        } else {
                            status = ValueStreamerStatus.STREAMING;
                        }
                    } else {
                        status = ValueStreamerStatus.FAILED;
                    }
                } else {
                    status = ValueStreamerStatus.FAILED;
                }
                return status;
            }

            @Override
            public String decode() throws IOException {
                return this.stringBuffer.toString();
            }
        });
    }
}

