/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultDecodeContext;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.format.CompositeSpec;
import de.carne.filescanner.engine.format.FormatSpec;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.filescanner.engine.util.SizeRenderer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StructSpec
extends CompositeSpec {
    private final List<FormatSpec> elements = new ArrayList<FormatSpec>();
    private int cachedFixedSize = -1;
    private int cachedMatchSize = -1;

    public <T extends FormatSpec> T add(T element) {
        this.elements.add(element);
        this.cachedFixedSize = -1;
        this.cachedMatchSize = -1;
        return element;
    }

    @Override
    public boolean isFixedSize() {
        return this.cachedFixedSize >= 0 ? this.cachedFixedSize != 0 : this.isFixedSize0();
    }

    private synchronized boolean isFixedSize0() {
        this.cachedFixedSize = 1;
        for (FormatSpec element : this.elements) {
            if (element.isFixedSize()) continue;
            this.cachedFixedSize = 0;
            break;
        }
        return this.cachedFixedSize != 0;
    }

    @Override
    public int matchSize() {
        return this.cachedMatchSize >= 0 ? this.cachedMatchSize : this.matchSize0();
    }

    private synchronized int matchSize0() {
        this.cachedMatchSize = 0;
        for (FormatSpec spec : this.elements) {
            this.cachedMatchSize += spec.matchSize();
            if (spec.isFixedSize()) continue;
            break;
        }
        return this.cachedMatchSize;
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        FormatSpec element;
        boolean match = true;
        Iterator<FormatSpec> iterator = this.elements.iterator();
        while (iterator.hasNext() && (match = (element = iterator.next()).matches(buffer)) && element.isFixedSize()) {
        }
        return match;
    }

    @Override
    public void decodeComposite(FileScannerResultDecodeContext context) throws IOException {
        if (this.elements.size() != 1) {
            for (FormatSpec element : this.elements) {
                element.decode(context);
            }
        } else {
            FormatSpec element = this.elements.get(0);
            element.decode(context);
            if (element instanceof CompositeSpec) {
                this.mergeDecodedExports((CompositeSpec)element);
            }
        }
    }

    @Override
    public void renderComposite(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        if (this.hasRenderer()) {
            super.renderComposite(out, context);
        } else {
            for (FormatSpec element : this.elements) {
                if (!FormatSpecs.isResult(element)) {
                    element.render(out, context);
                    continue;
                }
                this.renderRemaining(out, context);
                break;
            }
        }
    }

    private void renderRemaining(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        long remaining = context.remaining();
        if (!out.isEmpty() && remaining > 0L) {
            out.setStyle(RenderStyle.VALUE).write("{ ... }");
            SizeRenderer.LONG_RENDERER.render(out, remaining);
            out.writeln();
        }
        context.skip(remaining);
    }
}

