/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.format;

import de.carne.filescanner.engine.FileScannerResultInputContext;
import de.carne.filescanner.engine.format.AttributeSpec;
import de.carne.filescanner.engine.format.FormatSpecs;
import de.carne.filescanner.engine.util.FinalSupplier;
import de.carne.filescanner.engine.util.HexFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;

public class WordArraySpec
extends AttributeSpec<short[]> {
    private Supplier<? extends Number> size = FinalSupplier.of(0);

    public WordArraySpec(Supplier<String> name) {
        super(short[].class, Arrays::equals, name);
        this.format(HexFormat.SHORT_ARRAY_FORMATTER);
    }

    public WordArraySpec(String name) {
        this(FinalSupplier.of(name));
    }

    public WordArraySpec length(Supplier<? extends Number> lengthSupplier) {
        this.size = lengthSupplier instanceof FinalSupplier ? FinalSupplier.of(lengthSupplier.get().intValue() << 1) : () -> ((Number)lengthSupplier.get()).intValue() << 1;
        return this;
    }

    public WordArraySpec length(int lengthValue) {
        this.size = FinalSupplier.of(lengthValue);
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return FormatSpecs.isFixedSize(this.size);
    }

    @Override
    public int matchSize() {
        return FormatSpecs.matchSize(this.size);
    }

    @Override
    public boolean matches(ByteBuffer buffer) {
        return FormatSpecs.matches(buffer, this.size, b -> this.validateValue(this.decodeValue((ByteBuffer)b)));
    }

    @Override
    protected short[] decodeValue(FileScannerResultInputContext context) throws IOException {
        return context.readValue(this.size.get().intValue(), this::decodeValue);
    }

    private short[] decodeValue(ByteBuffer buffer) {
        ByteBuffer slice = buffer.slice();
        slice.limit(this.size.get().intValue());
        short[] value = new short[slice.remaining() >> 1];
        int valueIndex = 0;
        while (slice.hasRemaining()) {
            value[valueIndex] = slice.getShort();
            ++valueIndex;
        }
        buffer.position(buffer.position() + slice.position());
        return value;
    }
}

