/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.FileChannelInput;
import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.util.SystemProperties;
import de.carne.util.logging.Log;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public class BufferedFileChannelInput
extends FileScannerInput
implements Closeable {
    private final Map<Thread, Buffer> threadBuffers = new HashMap<Thread, Buffer>();
    private final FileChannelInput input;

    public BufferedFileChannelInput(FileChannelInput input) {
        super(input.name());
        this.input = input;
    }

    @Override
    public void close() throws IOException {
        try {
            this.input.close();
        }
        finally {
            this.clearBuffers();
        }
    }

    @Override
    public long size() throws IOException {
        return this.input.size();
    }

    @Override
    public int read(ByteBuffer buffer, long position) throws IOException {
        return this.getBuffer().read((FileScannerInput)this.input, buffer, position);
    }

    @Override
    public ByteBuffer read(long position, int size) throws IOException {
        return this.getBuffer().read((FileScannerInput)this.input, position, size);
    }

    private synchronized Buffer getBuffer() {
        return this.threadBuffers.computeIfAbsent(Thread.currentThread(), t -> new Buffer());
    }

    private synchronized void clearBuffers() {
        this.threadBuffers.clear();
    }

    private static class Buffer {
        private static final Log LOG;
        private static final int DEFAULT_BUFFER_SIZE = 65536;
        private static final int BUFFER_SIZE;
        private SoftReference<@Nullable ByteBuffer> bufferReference = new SoftReference<Object>(null);
        private long bufferPosition = -1L;

        public int read(FileScannerInput input, ByteBuffer buffer, long position) throws IOException {
            int read;
            int bufferRemaining = buffer.remaining();
            if (bufferRemaining <= BUFFER_SIZE >> 1) {
                ByteBuffer cacheBuffer = this.read0(input, position, bufferRemaining);
                read = cacheBuffer.remaining();
                buffer.put(cacheBuffer);
            } else {
                read = input.read(buffer, position);
            }
            return read > 0 ? read : -1;
        }

        public ByteBuffer read(FileScannerInput input, long position, int size) throws IOException {
            ByteBuffer buffer = size <= BUFFER_SIZE >> 1 ? this.read0(input, position, size) : input.read(position, size);
            return buffer;
        }

        private ByteBuffer read0(FileScannerInput input, long position, int size) throws IOException {
            ByteBuffer buffer = this.mapBuffer(input, position, size);
            ByteBuffer readBuffer = buffer.slice().asReadOnlyBuffer();
            readBuffer.limit(Math.min(readBuffer.remaining(), (int)(position - this.bufferPosition + (long)size)));
            readBuffer.position(Math.min(readBuffer.limit(), (int)(position - this.bufferPosition)));
            return readBuffer;
        }

        private ByteBuffer mapBuffer(FileScannerInput input, long position, int size) throws IOException {
            ByteBuffer buffer = this.bufferReference.get();
            if (buffer == null) {
                buffer = ByteBuffer.allocate(BUFFER_SIZE);
                long newBufferPosition = position & (long)(~((BUFFER_SIZE >> 1) - 1));
                buffer.clear();
                input.read(buffer, newBufferPosition);
                buffer.flip();
                this.bufferPosition = newBufferPosition;
                this.bufferReference = new SoftReference<ByteBuffer>(buffer);
            } else if (position < this.bufferPosition || this.bufferPosition + (long)buffer.capacity() < position + (long)size) {
                long newBufferPosition = position & (long)(~((BUFFER_SIZE >> 1) - 1));
                buffer.clear();
                input.read(buffer, newBufferPosition);
                buffer.flip();
                this.bufferPosition = newBufferPosition;
            }
            return buffer;
        }

        static {
            int alignedBufferSize;
            LOG = new Log();
            int bufferSize = SystemProperties.intValue(BufferedFileChannelInput.class, (String)".bufferSize", (int)65536);
            if (bufferSize != (alignedBufferSize = bufferSize >>> 13 << 13)) {
                LOG.warning("Unaligned buffer size {0}; using default", new Object[]{HexFormat.formatInt(bufferSize)});
                bufferSize = 65536;
            }
            LOG.info("Using input buffer size {0}", new Object[]{HexFormat.formatInt(bufferSize)});
            BUFFER_SIZE = bufferSize;
        }
    }
}

