/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.util.logging.Log;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class FileChannelInput
extends FileScannerInput
implements Closeable {
    private static final Log LOG = new Log();
    private final Path file;
    private final FileChannel fileChannel;

    FileChannelInput(Path file, OpenOption ... options) throws IOException {
        super(file.toAbsolutePath().toString());
        LOG.info("Opening input ''{0}''...", new Object[]{file});
        this.file = file;
        this.fileChannel = FileChannel.open(file, options);
    }

    public FileChannel channel() {
        return this.fileChannel;
    }

    @Override
    public void close() throws IOException {
        LOG.info("Closing input ''{0}''...", new Object[]{this.file});
        this.fileChannel.close();
    }

    @Override
    public long size() throws IOException {
        return this.fileChannel.size();
    }

    @Override
    public int read(ByteBuffer buffer, long position) throws IOException {
        return this.fileChannel.read(buffer, position);
    }
}

