/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.BufferedFileChannelInput;
import de.carne.filescanner.engine.input.FileChannelInput;
import de.carne.filescanner.engine.input.FileScannerInputByteChannel;
import de.carne.filescanner.engine.input.FileScannerInputInputStream;
import de.carne.filescanner.engine.input.FileScannerInputRange;
import de.carne.util.Check;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public abstract class FileScannerInput {
    private final String name;

    protected FileScannerInput(String name) {
        this.name = name;
    }

    public static BufferedFileChannelInput open(Path file) throws IOException {
        return new BufferedFileChannelInput(new FileChannelInput(file, StandardOpenOption.READ));
    }

    public String name() {
        return this.name;
    }

    public abstract long size() throws IOException;

    public abstract int read(ByteBuffer var1, long var2) throws IOException;

    public ByteBuffer read(long position, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        this.read(buffer, position);
        buffer.flip();
        return buffer;
    }

    public FileScannerInputRange range(long start, long end) throws IOException {
        Check.assertTrue((0L <= start ? 1 : 0) != 0);
        Check.assertTrue((start <= end ? 1 : 0) != 0);
        Check.assertTrue((end <= this.size() ? 1 : 0) != 0);
        return new FileScannerInputRange(this.name, this, 0L, start, end);
    }

    public SeekableByteChannel byteChannel(long start, long end) throws IOException {
        Check.assertTrue((0L <= start ? 1 : 0) != 0);
        Check.assertTrue((start <= end ? 1 : 0) != 0);
        Check.assertTrue((end <= this.size() ? 1 : 0) != 0);
        return new FileScannerInputByteChannel(this, start, end);
    }

    public InputStream inputStream(long start, long end) throws IOException {
        Check.assertTrue((0L <= start ? 1 : 0) != 0);
        Check.assertTrue((start <= end ? 1 : 0) != 0);
        Check.assertTrue((end <= this.size() ? 1 : 0) != 0);
        return new FileScannerInputInputStream(this, start, end);
    }

    public String toString() {
        return this.name;
    }
}

