/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.FileScannerInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.Nullable;

class FileScannerInputInputStream
extends InputStream {
    private final FileScannerInput input;
    private final long start;
    private final long end;
    private long position;
    private long mark = -1L;

    FileScannerInputInputStream(FileScannerInput input, long start, long end) {
        this.input = input;
        this.start = start;
        this.end = end;
        this.position = this.start;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b, 0, 1);
        return read > 0 ? b[0] & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte @Nullable [] b, int off, int len) throws IOException {
        int read;
        if (b == null) {
            throw new IllegalArgumentException();
        }
        int readLen = (int)Math.min((long)len, this.end - this.position);
        if (readLen > 0) {
            ByteBuffer buffer = ByteBuffer.wrap(b, off, readLen);
            read = this.input.read(buffer, this.position);
        } else {
            read = -1;
        }
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long oldPosition = this.position;
        if (n > 0L) {
            this.position = Math.max(this.position + n, this.end);
        }
        return this.position - oldPosition;
    }

    @Override
    public synchronized int available() throws IOException {
        return (int)Math.min(this.end - this.position, Integer.MAX_VALUE);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException("mark not set");
        }
        this.position = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

