/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.InsufficientDataException;
import de.carne.filescanner.engine.InvalidPositionException;
import de.carne.filescanner.engine.input.BufferedFileChannelInput;
import de.carne.filescanner.engine.input.DecodedInputMapper;
import de.carne.filescanner.engine.input.FileChannelInput;
import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.filescanner.engine.input.FileScannerInputRange;
import de.carne.filescanner.engine.input.InputDecoder;
import de.carne.filescanner.engine.input.InputDecoderException;
import de.carne.filescanner.engine.input.InputDecoderTable;
import de.carne.filescanner.engine.input.InputDecoders;
import de.carne.filescanner.engine.input.MappedFileScannerInput;
import de.carne.filescanner.engine.input.ZeroFileScannerInput;
import de.carne.filescanner.engine.util.HexFormat;
import de.carne.nio.compression.spi.Decoder;
import de.carne.nio.file.FileUtil;
import de.carne.nio.file.attribute.FileAttributes;
import de.carne.util.SystemProperties;
import de.carne.util.logging.Log;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public final class InputDecodeCache
implements Closeable {
    private static final Log LOG = new Log();
    private static final int DEFAUL_DECODE_BUFFER_SIZE = 65536;
    private static final int DECODE_BUFFER_SIZE;
    private final List<CacheFile> cacheFiles = new LinkedList<CacheFile>();
    private final Supplier<Boolean> shutdownCommenced;

    public InputDecodeCache(Supplier<Boolean> shutdownCommenced) {
        this.shutdownCommenced = shutdownCommenced;
    }

    public DecodeResult decodeInputs(DecodedInputMapper decodedInputMapper, InputDecoderTable inputDecoderTable, FileScannerInput input, long start) throws IOException {
        DecodeResult decodeResult;
        switch (inputDecoderTable.size()) {
            case 0: {
                decodeResult = this.decodeInput0(decodedInputMapper, input, start);
                break;
            }
            case 1: {
                decodeResult = this.decodeInput1(decodedInputMapper, inputDecoderTable.iterator().next(), input, start);
                break;
            }
            default: {
                decodeResult = this.decodeInputN(decodedInputMapper, inputDecoderTable, input, start);
            }
        }
        return decodeResult;
    }

    private DecodeResult decodeInput0(DecodedInputMapper decodedInputMapper, FileScannerInput input, long start) throws IOException {
        return new DecodeResult(decodedInputMapper.map(new FileScannerInputRange(decodedInputMapper.name(), input, start, start, 0L)), start, 0L);
    }

    private DecodeResult decodeInput1(DecodedInputMapper decodedInputMapper, InputDecoderTable.Entry inputDecoderTableEntry, FileScannerInput input, long start) throws IOException {
        DecodeResult decodeResult;
        long inputSize;
        InputDecoder inputDecoder = inputDecoderTableEntry.inputDecoder();
        long decodePosition = start;
        long decodeOffset = inputDecoderTableEntry.offset();
        if (decodeOffset > 0L) {
            decodePosition += decodeOffset;
        }
        if (decodePosition > (inputSize = input.size())) {
            throw new InvalidPositionException(input, decodePosition);
        }
        long encodedSize = inputDecoderTableEntry.encodedSize();
        long available = inputSize - decodePosition;
        if (encodedSize > 0L) {
            if (encodedSize > available) {
                throw new InsufficientDataException(input, decodePosition, encodedSize, available);
            }
            available = encodedSize;
        }
        if (InputDecoders.isIdentity(inputDecoder)) {
            long decodedSize = inputDecoderTableEntry.decodedSize();
            decodedSize = decodedSize >= 0L ? Math.min(decodedSize, encodedSize) : encodedSize;
            FileScannerInputRange mappedInput = new FileScannerInputRange(decodedInputMapper.name(), input, decodePosition, decodePosition, decodePosition + decodedSize);
            decodeResult = new DecodeResult(decodedInputMapper.map(mappedInput), decodePosition, encodedSize);
        } else if (InputDecoders.isZero(inputDecoder)) {
            ZeroFileScannerInput mappedInput = new ZeroFileScannerInput(decodedInputMapper.name(), inputDecoderTableEntry.decodedSize());
            decodeResult = new DecodeResult(decodedInputMapper.map(mappedInput), decodePosition, 0L);
        } else {
            decodeResult = this.decodeToCache(decodedInputMapper, input, decodePosition, decodePosition + available, inputDecoder);
        }
        return decodeResult;
    }

    private DecodeResult decodeInputN(DecodedInputMapper decodedInputMapper, InputDecoderTable inputDecoderTable, FileScannerInput input, long start) throws IOException {
        String decodedInputMapperName = decodedInputMapper.name();
        DecodedInputMapper identityMapper = new DecodedInputMapper(decodedInputMapperName);
        MappedFileScannerInput decodedInput = new MappedFileScannerInput(decodedInputMapperName);
        long decodePosition = start;
        long decodedEnd = start;
        Iterator<InputDecoderTable.Entry> iterator = inputDecoderTable.iterator();
        while (iterator.hasNext()) {
            InputDecoderTable.Entry inputDecoderTableEntry;
            DecodeResult result = this.decodeInput1(identityMapper, inputDecoderTableEntry, input, (inputDecoderTableEntry = iterator.next()).offset() >= 0L ? start : decodePosition);
            decodedInput.add(result.decodedInputs().get(0));
            decodePosition = result.decodePosition() + result.encodedSize();
            decodedEnd = Math.max(decodedEnd, decodePosition);
        }
        return new DecodeResult(decodedInputMapper.map(decodedInput), start, decodedEnd - start);
    }

    private DecodeResult decodeToCache(DecodedInputMapper decodedInputMapper, FileScannerInput input, long start, long limit, InputDecoder inputDecoder) throws IOException {
        DecodeResult decodeResult;
        try (CacheFileLock cacheFileLock = this.acquireCacheFileLock();
             SeekableByteChannel encodedByteChannel = input.byteChannel(start, limit);){
            CacheFile cacheFile = cacheFileLock.get();
            FileChannel cacheFileChannel = cacheFile.channel();
            Decoder decoder = inputDecoder.newDecoder();
            long decodedPosition = cacheFile.beginDecode();
            long decodedSize = 0L;
            ByteBuffer buffer = ByteBuffer.allocate(DECODE_BUFFER_SIZE);
            while (!this.shutdownCommenced.get().booleanValue() && decoder.decode(buffer, (ReadableByteChannel)encodedByteChannel) >= 0) {
                buffer.flip();
                decodedSize += (long)cacheFileChannel.write(buffer);
                buffer.clear();
            }
            cacheFile.endDecode(decodedSize);
            decodeResult = new DecodeResult(decodedInputMapper.map(new FileScannerInputRange(decodedInputMapper.name(), cacheFile.input(), decodedPosition, decodedPosition, decodedPosition + decodedSize)), start, decoder.totalIn());
        }
        catch (IOException e) {
            throw new InputDecoderException(inputDecoder, (Throwable)e);
        }
        return decodeResult;
    }

    private synchronized CacheFileLock acquireCacheFileLock() throws IOException {
        CacheFile acquiredCacheFile = null;
        for (CacheFile cacheFile : this.cacheFiles) {
            if (!cacheFile.tryLock()) continue;
            acquiredCacheFile = cacheFile;
            break;
        }
        if (acquiredCacheFile == null) {
            LOG.info("Creating decode cache file...", new Object[0]);
            Path tmpDir = FileUtil.tmpDir();
            Path cacheFilePath = Files.createTempFile(tmpDir, this.getClass().getSimpleName(), null, FileAttributes.userFileDefault((Path)tmpDir));
            FileChannelInput cacheFileChannelInput = new FileChannelInput(cacheFilePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.SPARSE);
            acquiredCacheFile = new CacheFile(cacheFilePath, cacheFileChannelInput);
            this.cacheFiles.add(acquiredCacheFile);
            LOG.info("Decode cache file ''{0}'' created", new Object[]{acquiredCacheFile});
        }
        return new CacheFileLock(acquiredCacheFile);
    }

    @Override
    public void close() throws IOException {
        IOException closeException = null;
        for (CacheFile cacheFile : this.cacheFiles) {
            try {
                cacheFile.close();
            }
            catch (IOException e) {
                if (closeException == null) {
                    closeException = e;
                    continue;
                }
                closeException.addSuppressed(e);
            }
        }
        this.cacheFiles.clear();
        if (closeException != null) {
            throw closeException;
        }
    }

    static {
        int decodeBufferSize = SystemProperties.intValue(InputDecodeCache.class, (String)".decodeBufferSize", (int)65536);
        if (decodeBufferSize <= 0) {
            LOG.warning("Invalid decode buffer size {0}; using default", new Object[]{HexFormat.formatInt(decodeBufferSize)});
            decodeBufferSize = 65536;
        }
        LOG.info("Using decode buffer size {0}", new Object[]{HexFormat.formatInt(decodeBufferSize)});
        DECODE_BUFFER_SIZE = decodeBufferSize;
    }

    private static class CacheFileLock
    implements AutoCloseable,
    Supplier<CacheFile> {
        private final CacheFile cacheFile;

        CacheFileLock(CacheFile cacheFile) {
            this.cacheFile = cacheFile;
        }

        @Override
        public CacheFile get() {
            return this.cacheFile;
        }

        @Override
        public void close() {
            this.cacheFile.release();
        }
    }

    private static class CacheFile
    implements Closeable {
        private static final byte[] SPARSE_MARKER = new byte[]{-34, -83, -66, -17};
        private final AtomicBoolean lock = new AtomicBoolean(true);
        private final Path path;
        private final FileChannel channel;
        private final BufferedFileChannelInput input;
        private long extent = 0L;

        CacheFile(Path path, FileChannelInput fileChannelInput) {
            this.path = path;
            this.channel = fileChannelInput.channel();
            this.input = new BufferedFileChannelInput(fileChannelInput);
        }

        public boolean tryLock() {
            return this.lock.compareAndSet(false, true);
        }

        public void release() {
            this.lock.set(false);
        }

        public long beginDecode() throws IOException {
            this.channel.truncate(this.extent);
            return this.extent;
        }

        public void endDecode(long decoded) throws IOException {
            this.extent += decoded;
            this.channel.write(ByteBuffer.wrap(SPARSE_MARKER), this.extent);
        }

        public FileChannel channel() {
            return this.channel;
        }

        public FileScannerInput input() {
            return this.input;
        }

        @Override
        public void close() throws IOException {
            this.input.close();
            Files.delete(this.path);
        }

        public String toString() {
            return this.path.toString();
        }
    }

    public static class DecodeResult {
        private final List<FileScannerInput> decodedInputs;
        private final long decodePosition;
        private final long encodedSize;

        DecodeResult(List<FileScannerInput> decodedInputs, long decodePosition, long encodedSize) {
            this.decodedInputs = decodedInputs;
            this.decodePosition = decodePosition;
            this.encodedSize = encodedSize;
        }

        public List<FileScannerInput> decodedInputs() {
            return this.decodedInputs;
        }

        public long decodePosition() {
            return this.decodePosition;
        }

        public long encodedSize() {
            return this.encodedSize;
        }
    }
}

