/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.FileScannerInput;
import de.carne.util.Check;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;

public class MappedFileScannerInput
extends FileScannerInput {
    private NavigableMap<Long, Mapping> mappings = new TreeMap<Long, Mapping>();

    public MappedFileScannerInput(String name) {
        super(name);
    }

    public MappedFileScannerInput add(FileScannerInput input) throws IOException {
        return this.add(input, 0L, input.size());
    }

    public MappedFileScannerInput add(FileScannerInput input, long start, long end) {
        Check.assertTrue((start <= end ? 1 : 0) != 0);
        if (start < end) {
            this.mappings.put(this.size(), new Mapping(input, start, end));
        }
        return this;
    }

    @Override
    public long size() {
        Map.Entry<Long, Mapping> lastEntry = this.mappings.lastEntry();
        return lastEntry != null ? lastEntry.getKey() + lastEntry.getValue().size() : 0L;
    }

    @Override
    public int read(ByteBuffer buffer, long position) throws IOException {
        long readPosition = position;
        int totalRead = -1;
        Map.Entry<Long, Mapping> entry = this.mappings.floorEntry(position);
        while (entry != null && buffer.hasRemaining()) {
            long mappingOffset = readPosition - entry.getKey();
            Mapping mapping = entry.getValue();
            long mappingRemaining = mapping.size() - mappingOffset;
            if (mappingRemaining > 0L) {
                int read = mapping.read(buffer, mappingOffset);
                if (read > 0) {
                    totalRead = Math.max(0, totalRead) + read;
                    entry = this.nextMapping(readPosition += (long)read);
                    continue;
                }
                entry = null;
                continue;
            }
            entry = null;
        }
        return totalRead;
    }

    private  @Nullable Map.Entry<Long, Mapping> nextMapping(long nextOffset) {
        Long nextKey = nextOffset;
        Map.Entry<Long, Mapping> next = this.mappings.floorEntry(nextKey);
        return next != null && next.getKey().equals(nextKey) ? next : null;
    }

    private class Mapping {
        private final FileScannerInput input;
        private final long start;
        private final long size;

        protected Mapping(FileScannerInput input, long start, long end) {
            this.input = input;
            this.start = start;
            this.size = end - start;
        }

        public long size() {
            return this.size;
        }

        public final int read(ByteBuffer buffer, long offset) throws IOException {
            int limit = (int)Math.min((long)buffer.remaining(), this.size - offset);
            ByteBuffer limitedBuffer = buffer.duplicate();
            limitedBuffer.limit(limitedBuffer.position() + limit);
            int read = this.input.read(limitedBuffer, this.start + offset);
            buffer.position(limitedBuffer.position());
            return read;
        }
    }
}

