/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.input;

import de.carne.filescanner.engine.input.FileScannerInput;
import java.nio.ByteBuffer;

public class ZeroFileScannerInput
extends FileScannerInput {
    private static final byte[] ZEROS = new byte[512];
    private final long size;

    public ZeroFileScannerInput(long size) {
        this("<zeros>", size);
    }

    public ZeroFileScannerInput(String name, long size) {
        super(name);
        this.size = size;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public int read(ByteBuffer buffer, long position) {
        int read;
        int putLength;
        for (int remaining = read = (int)Math.min((long)buffer.remaining(), this.size - position); remaining > 0; remaining -= putLength) {
            putLength = Math.min(buffer.remaining(), ZEROS.length);
            buffer.put(ZEROS, 0, putLength);
        }
        return read;
    }
}

