/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.spi;

import de.carne.filescanner.engine.FileScannerResult;
import de.carne.filescanner.engine.FileScannerResultDecodeContext;
import de.carne.filescanner.engine.format.CompositeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.regex.Pattern;

public abstract class Format {
    private final String name;
    private final List<CompositeSpec> headerSpecs = new ArrayList<CompositeSpec>();
    private final List<CompositeSpec> trailerSpecs = new ArrayList<CompositeSpec>();
    private final List<Pattern> inputNamePatterns = new ArrayList<Pattern>();
    private boolean absolute = false;

    protected Format(String name) {
        this.name = name;
    }

    public static Iterable<Format> providers() {
        return ServiceLoader.load(Format.class);
    }

    protected Format registerHeaderSpec(CompositeSpec headerSpec) {
        this.headerSpecs.add(headerSpec);
        return this;
    }

    protected Format registerTrailerSpec(CompositeSpec trailerSpec) {
        this.trailerSpecs.add(trailerSpec);
        return this;
    }

    protected Format registerInputNamePattern(Pattern inputNamePattern) {
        this.inputNamePatterns.add(inputNamePattern);
        return this;
    }

    protected Format setAbsolute(boolean absolute) {
        this.absolute = absolute;
        return this;
    }

    public final String name() {
        return this.name;
    }

    public boolean hasHeaderSpecs() {
        return !this.headerSpecs.isEmpty();
    }

    public List<CompositeSpec> headerSpecs() {
        return Collections.unmodifiableList(this.headerSpecs);
    }

    public boolean hasTrailerSpecs() {
        return !this.trailerSpecs.isEmpty();
    }

    public List<CompositeSpec> trailerSpecs() {
        return Collections.unmodifiableList(this.trailerSpecs);
    }

    public boolean hasInputNamePatterns() {
        return !this.inputNamePatterns.isEmpty();
    }

    public List<Pattern> inputNamePatterns() {
        return Collections.unmodifiableList(this.inputNamePatterns);
    }

    public final boolean isAbsolute() {
        return this.absolute;
    }

    public abstract FileScannerResult decode(FileScannerResultDecodeContext var1) throws IOException;
}

