/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.transfer;

import de.carne.filescanner.engine.FileScannerResult;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.RenderOption;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.filescanner.engine.transfer.Renderer;
import de.carne.filescanner.engine.transfer.TransferSource;
import de.carne.util.Check;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;

public final class RenderOutput
implements Closeable {
    private final Renderer renderer;
    private final Set<RenderOption> options = new HashSet<RenderOption>();
    private boolean prepared = false;
    private boolean newLine = true;
    private int currentIndent = 0;
    private RenderStyle currentStyle = RenderStyle.NORMAL;

    public RenderOutput(Renderer renderer) {
        this.renderer = renderer;
    }

    public static long render(FileScannerResult result, Renderer renderer, @Nullable FileScannerResultRenderHandler renderHandler, long offset) throws IOException {
        long decoded;
        try (RenderOutput out = new RenderOutput(renderer);){
            decoded = result.render(out, renderHandler, offset);
        }
        return decoded;
    }

    public boolean isEmpty() {
        return !this.prepared;
    }

    public boolean isStyled() {
        return this.renderer.isStyled();
    }

    public RenderOutput enableOption(RenderOption option) {
        Check.assertTrue((!this.prepared ? 1 : 0) != 0);
        this.options.add(option);
        return this;
    }

    public RenderOutput disableOption(RenderOption option) {
        Check.assertTrue((!this.prepared ? 1 : 0) != 0);
        this.options.remove((Object)option);
        return this;
    }

    public RenderOutput increaseIndent() {
        ++this.currentIndent;
        return this;
    }

    public RenderOutput decreaseIndent() {
        Check.isTrue((this.currentIndent > 0 ? 1 : 0) != 0);
        --this.currentIndent;
        return this;
    }

    public RenderOutput setStyle(RenderStyle style) {
        this.currentStyle = style;
        return this;
    }

    public RenderOutput write(String text) throws IOException {
        this.prepareIfNeeded();
        this.renderer.emitText(this.newLine ? this.currentIndent : -1, this.currentStyle, text, false);
        this.newLine = false;
        return this;
    }

    public RenderOutput write(String text, long href) throws IOException {
        this.prepareIfNeeded();
        this.renderer.emitText(this.newLine ? this.currentIndent : -1, this.currentStyle, text, href, false);
        this.newLine = false;
        return this;
    }

    public RenderOutput writeln(String text) throws IOException {
        this.prepareIfNeeded();
        this.renderer.emitText(this.newLine ? this.currentIndent : -1, this.currentStyle, text, true);
        this.newLine = true;
        return this;
    }

    public RenderOutput writeln(String text, long href) throws IOException {
        this.prepareIfNeeded();
        this.renderer.emitText(this.newLine ? this.currentIndent : -1, this.currentStyle, text, href, true);
        this.newLine = true;
        return this;
    }

    public RenderOutput write(TransferSource source) throws IOException {
        this.prepareIfNeeded();
        this.renderer.emitMediaData(this.newLine ? this.currentIndent : -1, this.currentStyle, source, false);
        this.newLine = false;
        return this;
    }

    public RenderOutput writeln(TransferSource source) throws IOException {
        this.prepareIfNeeded();
        this.renderer.emitMediaData(this.newLine ? this.currentIndent : -1, this.currentStyle, source, true);
        this.newLine = true;
        return this;
    }

    public RenderOutput writeln() throws IOException {
        return this.writeln("");
    }

    @Override
    public void close() throws IOException {
        if (this.prepared) {
            this.renderer.emitEpilogue();
        }
        this.renderer.close();
    }

    private void prepareIfNeeded() throws IOException {
        if (!this.prepared) {
            this.renderer.emitPrologue(this.options);
            this.prepared = true;
        }
    }
}

