/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.transfer.handler;

import de.carne.filescanner.engine.FileScannerResult;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.FileScannerResults;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.RenderStyle;
import de.carne.filescanner.engine.transfer.TransferSource;
import de.carne.filescanner.engine.transfer.TransferType;
import de.carne.mcd.MCDOutput;
import de.carne.mcd.MachineCodeDecoder;
import de.carne.mcd.PlainMCDOutput;
import de.carne.mcd.jvmdecoder.ClassFileDecoder;
import de.carne.mcd.x86decoder.X86b16Decoder;
import de.carne.mcd.x86decoder.X86b32Decoder;
import de.carne.mcd.x86decoder.X86b64Decoder;
import de.carne.util.logging.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.function.Supplier;

public class McdTransferHandler
implements FileScannerResultExportHandler,
FileScannerResultRenderHandler {
    private static final Log LOG = new Log();
    private static final String EXTENSION_TXT = ".txt";
    public static final McdTransferHandler JAVA_CLASS_FILE_TRANSFER = new McdTransferHandler(ClassFileDecoder::new, "Java class file", ".txt");
    public static final McdTransferHandler X86B16_TRANSFER = new McdTransferHandler(X86b16Decoder::new, "x86-16 instructions", ".txt");
    public static final McdTransferHandler X86B32_TRANSFER = new McdTransferHandler(X86b32Decoder::new, "x86-32 instructions", ".txt");
    public static final McdTransferHandler X86B64_TRANSFER = new McdTransferHandler(X86b64Decoder::new, "x86-64 instructions", ".txt");
    private final Supplier<MachineCodeDecoder> mcd;
    private final String name;
    private final String extension;

    private McdTransferHandler(Supplier<MachineCodeDecoder> mcd, String name, String extension) {
        this.mcd = mcd;
        this.name = name;
        this.extension = extension;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TransferType transferType() {
        return TransferType.TEXT_PLAIN;
    }

    @Override
    public String defaultFileExtension() {
        return this.extension;
    }

    @Override
    public String defaultFileName(FileScannerResult result) throws IOException {
        return FileScannerResults.defaultFileName(result, this.defaultFileExtension());
    }

    @Override
    public TransferSource export(FileScannerResultRenderContext context) throws IOException {
        final Supplier<MachineCodeDecoder> exportMcd = this.mcd;
        final FileScannerResult exportResult = context.result();
        return new TransferSource(){

            @Override
            public String name() {
                return McdTransferHandler.this.name();
            }

            @Override
            public TransferType transferType() {
                return McdTransferHandler.this.transferType();
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public void transfer(WritableByteChannel target) throws IOException {
                try (SeekableByteChannel in = exportResult.input().byteChannel(exportResult.start(), exportResult.end());
                     PlainMCDOutput out = new PlainMCDOutput(target, false);){
                    ((MachineCodeDecoder)exportMcd.get()).decode((ReadableByteChannel)in, (MCDOutput)out);
                }
            }

            @Override
            public void transfer(OutputStream target) throws IOException {
                try (WritableByteChannel targetChannel = Channels.newChannel(target);){
                    this.transfer(targetChannel);
                }
            }
        };
    }

    @Override
    public void render(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        FileScannerResult result = context.result();
        long renderStart = context.position();
        try (SeekableByteChannel in = result.input().byteChannel(renderStart, result.end());){
            long decodeStart = renderStart - result.start();
            long decoded = this.mcd.get().decode((ReadableByteChannel)in, (MCDOutput)new MCDRenderOutput(out), decodeStart);
            context.skip(decoded);
        }
        catch (IOException e) {
            LOG.error((Throwable)e, "Failed to completely decode ''{0}''", new Object[]{this.name});
        }
    }

    private static class MCDRenderOutput
    implements MCDOutput {
        private final RenderOutput out;

        MCDRenderOutput(RenderOutput out) {
            this.out = out;
        }

        public MCDRenderOutput increaseIndent() throws IOException {
            this.out.increaseIndent();
            return this;
        }

        public MCDRenderOutput decreaseIndent() throws IOException {
            this.out.decreaseIndent();
            return this;
        }

        public MCDRenderOutput println() throws IOException {
            this.out.writeln();
            return this;
        }

        public MCDRenderOutput print(String text) throws IOException {
            return this.printStyle(RenderStyle.NORMAL, text);
        }

        public MCDRenderOutput println(String text) throws IOException {
            return this.printlnStyle(RenderStyle.NORMAL, text);
        }

        public MCDRenderOutput printValue(String value) throws IOException {
            return this.printStyle(RenderStyle.VALUE, value);
        }

        public MCDRenderOutput printlnValue(String value) throws IOException {
            return this.printlnStyle(RenderStyle.VALUE, value);
        }

        public MCDRenderOutput printComment(String comment) throws IOException {
            return this.printStyle(RenderStyle.COMMENT, comment);
        }

        public MCDRenderOutput printlnComment(String comment) throws IOException {
            return this.printlnStyle(RenderStyle.COMMENT, comment);
        }

        public MCDRenderOutput printKeyword(String keyword) throws IOException {
            return this.printStyle(RenderStyle.KEYWORD, keyword);
        }

        public MCDRenderOutput printlnKeyword(String keyword) throws IOException {
            return this.printlnStyle(RenderStyle.KEYWORD, keyword);
        }

        public MCDRenderOutput printOperator(String operator) throws IOException {
            return this.printStyle(RenderStyle.OPERATOR, operator);
        }

        public MCDRenderOutput printlnOperator(String operator) throws IOException {
            return this.printlnStyle(RenderStyle.OPERATOR, operator);
        }

        public MCDRenderOutput printLabel(String label) throws IOException {
            return this.printStyle(RenderStyle.LABEL, label);
        }

        public MCDRenderOutput printlnLabel(String label) throws IOException {
            return this.printlnStyle(RenderStyle.LABEL, label);
        }

        public MCDRenderOutput printError(String error) throws IOException {
            return this.printStyle(RenderStyle.ERROR, error);
        }

        public MCDRenderOutput printlnError(String error) throws IOException {
            return this.printlnStyle(RenderStyle.ERROR, error);
        }

        private MCDRenderOutput printStyle(RenderStyle style, String text) throws IOException {
            this.out.setStyle(style);
            this.out.write(text);
            return this;
        }

        private MCDRenderOutput printlnStyle(RenderStyle style, String text) throws IOException {
            this.out.setStyle(style);
            this.out.writeln(text);
            return this;
        }
    }
}

