/*
 * Decompiled with CFR 0.152.
 */
package de.carne.filescanner.engine.transfer.handler;

import de.carne.filescanner.engine.FileScannerResult;
import de.carne.filescanner.engine.FileScannerResultRenderContext;
import de.carne.filescanner.engine.FileScannerResults;
import de.carne.filescanner.engine.transfer.FileScannerResultExportHandler;
import de.carne.filescanner.engine.transfer.FileScannerResultRenderHandler;
import de.carne.filescanner.engine.transfer.RenderOption;
import de.carne.filescanner.engine.transfer.RenderOutput;
import de.carne.filescanner.engine.transfer.TransferSource;
import de.carne.filescanner.engine.transfer.TransferType;
import de.carne.io.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Set;

public class RawTransferHandler
implements FileScannerResultExportHandler,
FileScannerResultRenderHandler {
    public static final RawTransferHandler APPLICATION_OCTET_STREAM_TRANSFER = new RawTransferHandler("Raw", TransferType.APPLICATION_OCTET_STREAM, ".bin", new RenderOption[0]);
    public static final RawTransferHandler IMAGE_BMP_TRANSFER = new RawTransferHandler("BMP image file", TransferType.IMAGE_BMP, ".bmp", RenderOption.TRANSPARENCY);
    public static final RawTransferHandler IMAGE_GIF_TRANSFER = new RawTransferHandler("GIF image file", TransferType.IMAGE_GIF, ".gif", RenderOption.TRANSPARENCY);
    public static final RawTransferHandler IMAGE_JPEG_TRANSFER = new RawTransferHandler("JPEG image file", TransferType.IMAGE_JPEG, ".jpg", RenderOption.TRANSPARENCY);
    public static final RawTransferHandler IMAGE_PNG_TRANSFER = new RawTransferHandler("PNG image file", TransferType.IMAGE_PNG, ".png", RenderOption.TRANSPARENCY);
    public static final RawTransferHandler IMAGE_TIFF_TRANSFER = new RawTransferHandler("TIFF image file", TransferType.IMAGE_TIFF, ".tif", RenderOption.TRANSPARENCY);
    public static final RawTransferHandler TEXT_PLAIN_TRANSFER = new RawTransferHandler("Plain text file", TransferType.TEXT_PLAIN, ".txt", new RenderOption[0]);
    public static final RawTransferHandler TEXT_XML_TRANSFER = new RawTransferHandler("XML file", TransferType.TEXT_XML, ".xml", new RenderOption[0]);
    public static final RawTransferHandler APPLICATION_PDF_TRANSFER = new RawTransferHandler("PDF file", TransferType.APPLICATION_PDF, ".pdf", new RenderOption[0]);
    private final String name;
    private final TransferType transferType;
    private final String extension;
    private final Set<RenderOption> renderOptions = new HashSet<RenderOption>();

    public RawTransferHandler(String name, TransferType transferType, String extension, RenderOption ... renderOptions) {
        this.name = name;
        this.transferType = transferType;
        this.extension = extension;
        for (RenderOption renderOption : renderOptions) {
            this.renderOptions.add(renderOption);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TransferType transferType() {
        return this.transferType;
    }

    @Override
    public String defaultFileExtension() {
        return this.extension;
    }

    @Override
    public String defaultFileName(FileScannerResult result) throws IOException {
        return FileScannerResults.defaultFileName(result, result.type() != FileScannerResult.Type.INPUT ? this.defaultFileExtension() : null);
    }

    @Override
    public TransferSource export(FileScannerResultRenderContext context) throws IOException {
        return new RawTransferSource(context.result());
    }

    @Override
    public void render(RenderOutput out, FileScannerResultRenderContext context) throws IOException {
        if (out.isEmpty()) {
            for (RenderOption renderOption : this.renderOptions) {
                out.enableOption(renderOption);
            }
        }
        FileScannerResult result = context.result();
        out.writeln(new RawTransferSource(result));
        context.skip(context.remaining());
    }

    protected ReadableByteChannel newResultChannel(FileScannerResult result) throws IOException {
        return result.input().byteChannel(result.start(), result.end());
    }

    private class RawTransferSource
    implements TransferSource {
        private final FileScannerResult result;

        public RawTransferSource(FileScannerResult result) {
            this.result = result;
        }

        @Override
        public String name() {
            return RawTransferHandler.this.name();
        }

        @Override
        public TransferType transferType() {
            return RawTransferHandler.this.transferType();
        }

        @Override
        public long size() {
            return this.result.size();
        }

        @Override
        public void transfer(WritableByteChannel target) throws IOException {
            try (SeekableByteChannel resultChannel = this.result.input().byteChannel(this.result.start(), this.result.end());){
                IOUtil.copyChannel((WritableByteChannel)target, (ReadableByteChannel)resultChannel);
            }
        }

        @Override
        public void transfer(OutputStream target) throws IOException {
            try (InputStream resultStream = this.result.input().inputStream(this.result.start(), this.result.end());){
                IOUtil.copyStream((OutputStream)target, (InputStream)resultStream);
            }
        }
    }
}

